/*!
  * Sa11y, the accessibility quality assurance assistant.
  * @version 4.1.1
  * @author Adam Chaboryk
  * @license GPL-2.0-or-later
  * @copyright © 2020 - 2025 Toronto Metropolitan University.
  * @contact adam.chaboryk@torontomu.ca
  * GitHub: git+https://github.com/ryersondmp/sa11y.git | Website: https://sa11y.netlify.app
  * For all acknowledgements, please visit: https://sa11y.netlify.app/acknowledgements/
  * The above copyright notice shall be included in all copies or substantial portions of the Software.
**/
const e={checkRoot:"body",containerIgnore:".sa11y-ignore",contrastIgnore:".sr-only",outlineIgnore:"",headerIgnore:"",headerIgnoreSpan:"",headerIgnoreStrings:"",imageIgnore:"",linkIgnore:"",linkIgnoreSpan:"",linkIgnoreStrings:"",aboutContent:"",panelPosition:"right",showMovePanelToggle:!0,checkAllHideToggles:!1,developerChecksOnByDefault:!1,showHinPageOutline:!1,showTitleInPageOutline:!0,showImageOutline:!0,editImageURLofCMS:"",relativePathImageSRC:"",relativePathImageID:"",ignoreEditImageURL:[],ignoreEditImageClass:[],delayCheck:0,delayCustomCheck:500,detectSPArouting:!1,doNotRun:"",headless:!1,selectorPath:!1,shadowComponents:"",autoDetectShadowComponents:!1,showGoodImageButton:!0,showGoodLinkButton:!0,dismissAnnotations:!0,dismissAll:!0,ignoreHiddenOverflow:"",insertAnnotationBefore:"",readabilityPlugin:!0,readabilityRoot:"body",readabilityIgnore:"",contrastPlugin:!0,contrastAPCA:!1,customChecks:!1,linksAdvancedPlugin:!0,formLabelsPlugin:!0,embeddedContentPlugin:!0,developerPlugin:!0,colourFilterPlugin:!0,exportResultsPlugin:!1,susAltStopWords:"",linkStopWords:"",extraPlaceholderStopWords:"",imageWithinLightbox:"",checks:{HEADING_SKIPPED_LEVEL:!0,HEADING_EMPTY_WITH_IMAGE:!0,HEADING_EMPTY:!0,HEADING_FIRST:!0,HEADING_LONG:{maxLength:170},HEADING_MISSING_ONE:!0,MISSING_ALT_LINK:!0,MISSING_ALT_LINK_HAS_TEXT:!0,MISSING_ALT:!0,IMAGE_DECORATIVE_CAROUSEL:{sources:".carousel"},LINK_IMAGE_NO_ALT_TEXT:!0,LINK_IMAGE_TEXT:!0,IMAGE_FIGURE_DECORATIVE:!0,IMAGE_DECORATIVE:!0,LINK_ALT_FILE_EXT:!0,ALT_FILE_EXT:!0,LINK_PLACEHOLDER_ALT:!0,ALT_PLACEHOLDER:!0,LINK_SUS_ALT:!0,SUS_ALT:!0,LINK_IMAGE_LONG_ALT:{maxLength:250},IMAGE_ALT_TOO_LONG:{maxLength:250},LINK_IMAGE_ALT:{dismissAll:!0},LINK_IMAGE_ALT_AND_TEXT:!0,IMAGE_FIGURE_DUPLICATE_ALT:!0,IMAGE_PASS:{dismissAll:!0},DUPLICATE_TITLE:{dismissAll:!0},LINK_EMPTY_LABELLEDBY:!0,LINK_EMPTY_NO_LABEL:!0,LINK_STOPWORD:!0,LINK_STOPWORD_ARIA:!0,LINK_SYMBOLS:!0,LINK_CLICK_HERE:!0,LINK_DOI:{dismissAll:!0},LINK_URL:{maxLength:40},LINK_LABEL:{dismissAll:!0},LINK_EMPTY:!0,LINK_IDENTICAL_NAME:{dismissAll:!0},LINK_NEW_TAB:{dismissAll:!0},LINK_FILE_EXT:!0,LABELS_MISSING_IMAGE_INPUT:!0,LABELS_INPUT_RESET:!0,LABELS_MISSING_LABEL:!0,LABELS_ARIA_LABEL_INPUT:!0,LABELS_NO_FOR_ATTRIBUTE:!0,LABELS_PLACEHOLDER:!0,EMBED_AUDIO:{sources:""},EMBED_VIDEO:{sources:""},EMBED_DATA_VIZ:{sources:""},EMBED_UNFOCUSABLE:!0,EMBED_MISSING_TITLE:!0,EMBED_GENERAL:!0,QA_BAD_LINK:{sources:""},QA_STRONG_ITALICS:!0,QA_IN_PAGE_LINK:!0,QA_DOCUMENT:{sources:"",dismissAll:!0},QA_PDF:{dismissAll:!0},QA_BLOCKQUOTE:!0,TABLES_MISSING_HEADINGS:!0,TABLES_SEMANTIC_HEADING:!0,TABLES_EMPTY_HEADING:!0,QA_FAKE_HEADING:!0,QA_FAKE_LIST:!0,QA_UPPERCASE:!0,QA_UNDERLINE:!0,QA_SUBSCRIPT:!0,QA_NESTED_COMPONENTS:{sources:""},QA_JUSTIFY:!0,QA_SMALL_TEXT:!0,META_LANG:!0,META_SCALABLE:!0,META_MAX:!0,META_REFRESH:!0,DUPLICATE_ID:!0,META_TITLE:!0,UNCONTAINED_LI:!0,TABINDEX_ATTR:!0,HIDDEN_FOCUSABLE:!0,LABEL_IN_NAME:!0,BTN_EMPTY:!0,BTN_EMPTY_LABELLEDBY:!0,BTN_ROLE_IN_NAME:!0,CONTRAST_WARNING:{dismissAll:!0},CONTRAST_INPUT:!0,CONTRAST_ERROR:!0,CONTRAST_PLACEHOLDER:!0,CONTRAST_ERROR_GRAPHIC:!0,CONTRAST_WARNING_GRAPHIC:{dismissAll:!0},CONTRAST_UNSUPPORTED:{dismissAll:!0}}},t={langStrings:{},addI18n(e){this.langStrings=e},_(e){return this.translate(e)},sprintf(e,...t){let n=this._(e);return n=this.prepHTML(n),t&&t.length&&t.forEach((e=>{n=n.replace(/%\([a-zA-z]+\)/,e)})),n},translate(e){return this.langStrings[e]||e},prepHTML:e=>e.replaceAll(/<hr>/g,'<hr aria-hidden="true">').replaceAll(/<a[\s]href=/g,'<a target="_blank" rel="noopener noreferrer" href=').replaceAll(/<\/a>/g,`<span class="visually-hidden"> (${t._("NEW_TAB")})</span></a>`).replaceAll(/{C}/g,'class="colour"').replaceAll(/{B}/g,'class="badge"').replaceAll(/{ALT}/g,`<strong class="badge">${t._("ALT")}</strong>`).replaceAll(/{L}/g,`<strong class="badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></strong>`)},n=function(){const e={};const o={};const i={};const s={};const a={};return{initializeRoot:function(o,i){if(e.areaToCheck=document.querySelector(o),e.areaToCheck||(e.areaToCheck=document.querySelector("body")),e.Readability=document.querySelector(i),!e.Readability)if(e.areaToCheck){e.Readability=e.areaToCheck;const{readabilityDetails:o,readabilityToggle:s}=n.Panel,a="true"===s?.getAttribute("aria-pressed");if(o&&a){const n=document.createElement("div");n.id="readability-alert",n.innerHTML=`<hr aria-hidden="true"><p>${t.sprintf("MISSING_READABILITY_ROOT",e.areaToCheck.tagName.toLowerCase(),i)}</p>`,o.insertAdjacentElement("afterend",n)}}else e.Readability=document.querySelector("body")},Root:e,initializeGlobal:function(e){o.html=document.querySelector("html"),o.headless=e.headless,o.panelPosition=e.panelPosition,o.dismissAnnotations=e.dismissAnnotations,o.aboutContent=e.aboutContent,o.contrastAPCA=e.contrastAPCA,o.contrastSuggestions=e.contrastSuggestions,o.developerPlugin=e.developerPlugin,o.colourFilterPlugin=e.colourFilterPlugin,o.checkAllHideToggles=e.checkAllHideToggles,o.exportResultsPlugin=e.exportResultsPlugin,o.showImageOutline=e.showImageOutline,o.editImageURLofCMS=e.editImageURLofCMS,o.relativePathImageSRC=e.relativePathImageSRC,o.relativePathImageID=e.relativePathImageID,o.ignoreEditImageURL=e.ignoreEditImageURL,o.ignoreEditImageClass=e.ignoreEditImageClass,o.showMovePanelToggle=e.showMovePanelToggle;let t=!1;"function"==typeof window.matchMedia&&(t=window.matchMedia("(prefers-reduced-motion: reduce)")),o.scrollBehaviour=!t||t.matches?"auto":"smooth",o.langDirection="rtl"===o.html.getAttribute("dir")?"rtl":"ltr";const n=e.checks.QA_DOCUMENT.sources,i='a[href$=".doc"], a[href$=".docx"], a[href*=".doc?"], a[href*=".docx?"], a[href$=".ppt"], a[href$=".pptx"], a[href*=".ppt?"], a[href*=".pptx?"], a[href^="https://drive.google.com/file"], a[href^="https://docs.google."], a[href^="https://sway."]';n.length?o.documentSources=`${i}, ${n}`:o.documentSources=i;const s=e.checks.EMBED_VIDEO.sources,a='video, [src*="Video"], [src*="video"], [src*="watch"], [src*="youtube.com"], [src*="vimeo.com"], [src*="panopto.com"], [src*="wistia.com"], [src*="dailymotion.com"], [src*="brightcove.com"], [src*="vidyard.com"]';if(s.length){const e=s.split(/\s*[\s,]\s*/).map((e=>`[src*="${e}"]`));o.VideoSources=`${a}, ${e.join(", ")}`}else o.VideoSources=a;const r=e.checks.EMBED_AUDIO.sources,l='audio, [src*="soundcloud.com"], [src*="simplecast.com"], [src*="podbean.com"], [src*="buzzsprout.com"], [src*="blubrry.com"], [src*="transistor.fm"], [src*="fusebox.fm"], [src*="libsyn.com"], [src*="spotify.com"], [src*="podcasts.apple.com"], [src*="castbox.fm"], [src*="megaphone.fm"], [src*="spreaker.com"], [src*="anchor.fm"], [src*="rss.com"], [src*="redcircle.com"]';if(r.length){const e=r.split(/\s*[\s,]\s*/).map((e=>`[src*="${e}"]`));o.AudioSources=`${l}, ${e.join(", ")}`}else o.AudioSources=l;const c=e.checks.EMBED_DATA_VIZ.sources,d='[src*="datastudio"], [src*="tableau"], [src*="lookerstudio"], [src*="powerbi"], [src*="qlik"]';if(c.length){const e=c.split(/\s*[\s,]\s*/).map((e=>`[src*="${e}"]`));o.VisualizationSources=`${d}, ${e.join(", ")}`}else o.VisualizationSources=d;o.AllEmbeddedContent=`${o.VideoSources}, ${o.AudioSources}, ${o.VisualizationSources}`},Global:o,initializePanelSelectors:function(){const e=document.querySelector("sa11y-control-panel").shadowRoot;i.panel=e.getElementById("panel"),i.content=e.getElementById("panel-content"),i.controls=e.getElementById("panel-controls"),i.outline=e.getElementById("outline-panel"),i.outlineContent=e.getElementById("outline-content"),i.outlineList=e.getElementById("outline-list"),i.outlineHeader=e.getElementById("outline-header"),i.images=e.getElementById("images-panel"),i.imagesContent=e.getElementById("images-content"),i.imagesList=e.getElementById("images-list"),i.imagesHeader=e.getElementById("images-header"),i.notifBadge=e.getElementById("notification-badge"),i.notifCount=e.getElementById("notification-count"),i.notifText=e.getElementById("notification-text"),i.status=e.getElementById("status"),i.pageIssues=e.getElementById("page-issues"),i.pageIssuesList=e.getElementById("page-issues-list"),i.pageIssuesHeader=e.getElementById("page-issues-header"),i.pageIssuesContent=e.getElementById("page-issues-content"),i.settings=e.getElementById("settings-panel"),i.settingsHeader=e.getElementById("settings-header"),i.settingsContent=e.getElementById("settings-content"),i.developerToggle=e.getElementById("developer-toggle"),i.readabilityToggle=e.getElementById("readability-toggle"),i.themeToggle=e.getElementById("theme-toggle"),i.developerItem=e.getElementById("developer-item"),i.readabilityItem=e.getElementById("readability-item"),i.darkModeItem=e.getElementById("dark-mode-item"),i.colourPanel=e.getElementById("panel-colour-filters"),i.colourFilterItem=e.getElementById("colour-filter-item"),i.colourFilterSelect=e.getElementById("colour-filter-select"),i.colourFilterIcon=e.getElementById("filter-icon"),i.toggle=e.getElementById("toggle"),i.outlineToggle=e.getElementById("outline-toggle"),i.imagesToggle=e.getElementById("images-toggle"),i.settingsToggle=e.getElementById("settings-toggle"),i.movePanelToggle=e.getElementById("move-panel"),i.skipButton=e.getElementById("skip-button"),i.dismissButton=e.getElementById("dismiss-button"),i.dismissTooltip=e.getElementById("dismiss-tooltip"),i.skipToPageIssues=e.getElementById("skip-to-page-issues"),i.exportHTML=e.getElementById("export-html"),i.exportCSV=e.getElementById("export-csv"),i.alert=e.getElementById("panel-alert"),i.alertText=e.getElementById("panel-alert-text"),i.alertPreview=e.getElementById("panel-alert-preview"),i.alertClose=e.getElementById("close-alert"),i.readability=e.getElementById("readability-panel"),i.readabilityInfo=e.getElementById("readability-info"),i.readabilityDetails=e.getElementById("readability-details")},Panel:i,initializeReadability:function(e){if(e.readabilityPlugin){s.Lang=t._("LANG_CODE").substring(0,2);const e=["en","fr","es","de","nl","it","sv","fi","da","no","nb","nn","pt"],o=n.Global.html.getAttribute("lang");if(o){const t=o.toLowerCase().substring(0,2);e.includes(t)&&e.includes(s.Lang)?s.Plugin=!0:s.Plugin=!1}else s.Plugin=!1}},Readability:s,initializeExclusions:function(e){a.Sa11yElements=["sa11y-heading-label","sa11y-heading-anchor","sa11y-annotation","sa11y-tooltips","sa11y-panel-tooltips","sa11y-control-panel","#sa11y-colour-filters","#sa11y-colour-filters *"];const t=["style","script","noscript"];if(a.Container=["#wpadminbar","#wpadminbar *",...t],e.containerIgnore){const t=e.containerIgnore.split(",").map((e=>e.trim()));a.Container=a.Container.concat(t.flatMap((e=>[`${e} *`,e])))}a.Contrast=["link","hr","option","audio","audio *","video","video *",'input[type="color"]','input[type="range"]',"progress","progress *","meter","meter *","iframe","svg title","svg desc",...t],e.contrastIgnore&&(a.Contrast=e.contrastIgnore.split(",").map((e=>e.trim())).flatMap((e=>[e,`${e} *`])).concat(a.Contrast)),a.Readability=["nav li",'[role="navigation"] li',...t],e.readabilityIgnore&&(a.Readability=e.readabilityIgnore.split(",").map((e=>e.trim())).flatMap((e=>[e,`${e} *`])).concat(a.Readability)),a.Headings=e.headerIgnore?e.headerIgnore.split(",").map((e=>e.trim())):[],a.HeaderSpan=e.headerIgnoreSpan?e.headerIgnoreSpan.split(",").map((e=>e.trim())):[],a.Outline=e.outlineIgnore?e.outlineIgnore.split(",").map((e=>e.trim())):[],a.Images=['[role="presentation"]'],e.imageIgnore&&(a.Images=e.imageIgnore.split(",").map((e=>e.trim())).concat(a.Images)),a.Links=[".anchorjs-link"],e.linkIgnore&&(a.Links=e.linkIgnore.split(",").map((e=>e.trim())).concat(a.Links)),a.LinkSpan=e.linkIgnoreSpan?e.linkIgnoreSpan.split(",").map((e=>e.trim())):[]},Exclusions:a}}();function o(e,t,o){let i;"document"===t?i=document:"readability"===t?(i=n.Readability.Root,i||(i=n.Root.areaToCheck)):"root"===t?(i=n.Root.areaToCheck,i||(i=document.body)):"panel"===t?(i=n.Panel.panel,i||(i=document.body)):(i=document.querySelector(t),i||(i=document.body));const s=document.querySelectorAll("[data-sa11y-has-shadow-root]"),a=s?", [data-sa11y-has-shadow-root]":"",r=n.Exclusions.Container.join(", "),l=o?.join(", ")||"",c=l?`, ${l}`:"",d=Array.from(i.querySelectorAll(`:is(${e}${a}):not(${r}${c})`));if(s.length){const t=[];if(d.forEach(((n,o)=>{n&&n.matches&&n.matches("[data-sa11y-has-shadow-root]")&&n.shadowRoot&&(t[o]=n.shadowRoot.querySelectorAll(`:is(${e}):not(${r}${c})`))})),t.length>0)for(let e=t.length-1;e>=0;e--)t[e]&&d.splice(e,1,...t[e])}return d.filter((e=>"SLOT"!==e.parentNode.tagName))}const i=(e,t)=>{const n=e=>{if("none"===e)return"";const t=e.includes("url(")||e.includes("image-set(")?e.match(/\/\s*"([^"]+)"/):e.match(/"([^"]+)"/);return t?t[1]:""};return`${n(window.getComputedStyle(e,":before").getPropertyValue("content"))}${t}${n(window.getComputedStyle(e,":after").getPropertyValue("content"))}`},s=e=>{for(let t=0;t<1e3;t++){if(e.nextSibling())return e.previousNode();if(!e.parentNode())return!1}return!1},a=(e,t=!1)=>{const n=e.getAttribute("aria-labelledby");if(!t&&n)return n.split(/\s+/).filter((e=>e.trim())).map((e=>{const t=document.querySelector(`#${CSS.escape(e)}`);return t?r(t,"",1):""})).join(" ");const o=e.getAttribute("aria-label");return o&&o.trim().length>0?o:"noAria"},r=(e,t=[],n=0)=>{const o=a(e,n);if("noAria"!==o)return o;if("TEXTAREA"===e.tagName&&e.hasAttribute("title"))return e.getAttribute("title");let l="";if(!e.children.length)return l=i(e,e.textContent),!l.trim()&&e.hasAttribute("title")?e.getAttribute("title"):l;const c=(d=e,p=!0,u=!0,document.createTreeWalker(d,NodeFilter.SHOW_ALL,{acceptNode:e=>p&&e.nodeType===Node.ELEMENT_NODE||u&&e.nodeType===Node.TEXT_NODE?NodeFilter.FILTER_ACCEPT:NodeFilter.FILTER_REJECT}));var d,p,u;let h=!1,m=!1,g=0,f=!0;const b=t&&t.length?t.join(", "):"",y=[...b?[b]:[],"noscript","style","script","video","audio"].join(", "),E=e.querySelectorAll(y);for(;c.nextNode()&&f;){g+=1;if(Array.from(E).some((e=>e.contains(c.currentNode))));else if(c.currentNode.nodeType===Node.TEXT_NODE)"SLOT"!==c.currentNode.parentNode.tagName&&(l+=` ${c.currentNode.nodeValue}`);else if(h&&!c.currentNode.closest("a"))m===l&&(l+=h),h=!1,m=!1;else if(!c.currentNode.hasAttribute("aria-hidden")||n&&g<3){const e=a(c.currentNode,n);if("noAria"!==e)l+=` ${e}`,s(c)||(f=!1);else switch(c.currentNode.tagName){case"IMG":c.currentNode.hasAttribute("alt")&&(l+=c.currentNode.getAttribute("alt"));break;case"SVG":if("img"===c.currentNode.hasAttribute("role")||"graphics-document"===c.currentNode.hasAttribute("role"))l+=a(c.currentNode);else{const e=c.currentNode.querySelector("title");e&&(l+=e)}break;case"A":c.currentNode.hasAttribute("title")?(h=c.currentNode.getAttribute("title"),m=l):(h=!1,m=!1),l+=i(c.currentNode,"");break;case"SLOT":if(c.currentNode.assignedNodes()){const e=c.currentNode.assignedNodes();let t="";e?.forEach((e=>{e.nodeType===Node.ELEMENT_NODE?t+=r(e):e.nodeType===Node.TEXT_NODE&&(t+=e.nodeValue)})),l+=t}l+=i(c.currentNode,"");break;default:l+=i(c.currentNode,"")}}else s(c)||(f=!1)}h&&!m&&(l+=` ${h}`);return l=l.replace(/[\uE000-\uF8FF]/gu,""),!l.trim()&&e.hasAttribute("title")?e.getAttribute("title"):l};function l(e){if(e.getAttribute("hidden")||0===e.offsetWidth&&0===e.offsetHeight||1===e.clientHeight&&1===e.clientWidth)return!0;return"none"===getComputedStyle(e).getPropertyValue("display")}function c(e){const t=window.getComputedStyle(e),n=t.getPropertyValue("clip-path"),{position:o}=t,i=parseFloat(t.width),s=parseFloat(t.height),{overflow:a}=t;return"inset(50%)"===n||"absolute"===o&&1===i&&1===s&&"hidden"===a}function d(e){if(e.getAttribute("hidden"))return!0;return"none"===getComputedStyle(e).getPropertyValue("display")}function p(e){const t=document.createElement("div");return t.textContent=e,t.innerHTML.replaceAll('"',"&quot;").replaceAll("'","&#039;").replaceAll("`","&#x60;")}function u(e){return e.replace(/[^\w. ]/gi,(e=>`&#${e.charCodeAt(0)};`))}function h(e){if(!e)return"#";const t=String(e).trim();if(/^javascript:/i.test(t))return"#";if(/^data:/i.test(t))return"#";if(!["http:","https:","mailto:","tel:","ftp:"].some((e=>t.toLowerCase().startsWith(e)))&&!t.startsWith("/")&&!t.startsWith("#"))return`./${t}`;const n=t.replace(/<[^>]*>/g,"");return encodeURI(n)}function m(e,t=!1){const n=document.createElement("div");n.innerHTML=e,["script","style","noscript","iframe","form"].forEach((e=>{const t=n.getElementsByTagName(e);for(;t.length>0;)t[0].parentNode.removeChild(t[0])}));return Array.from(n.getElementsByTagName("*")).forEach((e=>{Array.from(e.attributes).forEach((t=>{t.name.startsWith("on")&&e.removeAttribute(t.name)})),t||e.removeAttribute("style")})),n.innerHTML}function g(e,t=[]){const n=["noscript","script","style","audio","video","form","iframe",...t].join(", "),o=e.cloneNode(!0);return Array.from(o.querySelectorAll(n)).forEach((e=>{e.parentElement.removeChild(e)})),o}function f(e){return g(e).textContent.replace(/[\r\n]+/g,"").replace(/\s+/g," ").trim()}function b(e){return e.replace(/[\r\n]+/g," ").replace(/\s+/g," ").trim()}function y(e,t){const n=e.substring(0,t).trimEnd();return e.length>t?`${n}...`:e}function E(e,t,n){let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null}function A(e){const t=e.getBoundingClientRect(),n=window.pageYOffset||document.documentElement.scrollTop;return{top:t.top+n}}const v={getItem(e){try{return null===localStorage.getItem(e)?sessionStorage.getItem(e):localStorage.getItem(e)}catch(e){return!1}},setItem(e,t){try{localStorage.setItem(e,t)}catch(n){sessionStorage.setItem(e,t)}return!0},removeItem(e){try{localStorage.removeItem(e)}catch(t){sessionStorage.removeItem(e)}return!0}};function _(e){const t="data-sa11y-pulse-border";e.setAttribute(t,""),setTimeout((()=>{e.removeAttribute(t)}),2500)}function I(e){return String(e).replace(/([^0-9a-zA-Z])/g,"").substring(0,256)}function L(){const e=document.querySelector("sa11y-control-panel").shadowRoot,t=e.getElementById("panel-alert"),n=e.getElementById("panel-alert-text"),o=e.getElementById("panel-alert-preview");for(t.classList.remove("active"),o.classList.remove("panel-alert-preview");n.firstChild;)n.removeChild(n.firstChild);for(;o.firstChild;)o.removeChild(o.firstChild)}function T(e,t,n){L();const o=document.querySelector("sa11y-control-panel").shadowRoot,i=o.getElementById("panel-alert"),s=o.getElementById("panel-alert-text"),a=o.getElementById("panel-alert-preview"),r=o.getElementById("close-alert"),l=o.getElementById("skip-button");i.classList.add("active"),s.innerHTML=e;const c=n?`<div class="element-preview">${n}</div>`:"";function d(){L();(l.hasAttribute("disabled")?o.getElementById("toggle"):l).focus()}t&&(a.classList.add("panel-alert-preview"),a.innerHTML=`${c}<div class="preview-message">${t}</div>`),setTimeout((()=>{r.focus()}),300),r.addEventListener("click",d),i.onkeydown=e=>{"Escape"===(e||window.event).key&&i.classList.contains("active")&&d()}}function x(e,t){e.forEach((e=>{o(`[${e}]`,`${t}`).forEach((t=>{t.removeAttribute(e)}))}))}function N(e,t){o(`${e}`,`${t}`).forEach((e=>{e.parentNode.removeChild(e)}))}function k(e,t,n){setTimeout((()=>{e.scrollHeight>t.clientHeight?(t.classList.add("scrollable"),e.setAttribute("tabindex","0"),n&&(e.setAttribute("aria-label",n),e.setAttribute("role","region"))):t.classList.remove("scrollable")}),50)}function S(e){const t=e=>e?.split(",").pop()?.trim()?.split(/\s+/)[0],n=t(e.getAttribute("data-src")||e.getAttribute("srcset"));if(n)return n;const o=e.closest("picture")?.querySelector("source[srcset]")?.getAttribute("srcset"),i=t(o);return i||e.getAttribute("src")}function w(e){const t=e.element,n=`<pre><code>${p(y(m(e.htmlPath),600))}</code></pre>`,o=e=>{const t=f(e),o=y(t,100);return t.length?u(o):n},i={SPAN:o,P:o,A:e=>{const t=f(e),o=y(t,100);return t.length>1&&e.href&&!e.hasAttribute("role")?`<a href="${h(e.href)}">${u(o)}</a>`:n},IMG:e=>{const t=e.closest("a[href]"),o=e.alt?`alt="${u(e.alt)}"`:"alt",i=S(e);return i?t?`<a href="${h(t.href)}" rel="noopener noreferrer"><img src="${h(i)}" ${o}/></a>`:`<img src="${h(i)}" ${o}/>`:n},IFRAME:e=>{const t=e.src,o=e.title?e.title:"",i=e.getAttribute("aria-label");if(t){const e=i||""||o;return`<iframe src="${h(t)}" aria-label="${u(e)}"></iframe>`}return n},AUDIO:()=>m(e.htmlPath),VIDEO:()=>m(e.htmlPath)}[t.tagName];return i?i(t):n}function C(e){let t="";const n=r(e).toLowerCase();e.childNodes.forEach((e=>{e.nodeType===Node.TEXT_NODE?t+=e.textContent:e.nodeType===Node.ELEMENT_NODE&&(l(e)||(t+=e.textContent))}));let o=t.replace(/[\p{Emoji_Presentation}\p{Extended_Pictographic}]/gu,"");return o=b(o).toLowerCase(),"x"!==o&&(0!==o.length&&!n.includes(o))}const O=function(){const e={};const t={};return{initializeElements:function(t){e.Everything=o("*","root",n.Exclusions.Sa11yElements),e.Contrast=e.Everything.filter((e=>!n.Exclusions.Contrast.some((t=>e.matches(t)))&&!n.Exclusions.Contrast.includes(e))),e.Images=e.Everything.filter((e=>"IMG"===e.tagName&&!n.Exclusions.Images.some((t=>e.matches(t))))),e.Links=e.Everything.filter((e=>("A"===e.tagName||"a"===e.tagName)&&e.hasAttribute("href")&&!e.matches('[role="button"]')&&!n.Exclusions.Links.some((t=>e.matches(t))))),e.Headings=o('h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]',"document",n.Exclusions.Headings),e.HeadingOne=o('h1, [role="heading"][aria-level="1"]',"document",n.Exclusions.Headings),e.ExcludedHeadings=e.Headings.filter((e=>n.Exclusions.Headings.some((t=>e.matches(t))))),e.Paragraphs=e.Everything.filter((e=>"P"===e.tagName&&!e.closest("table"))),e.Lists=e.Everything.filter((e=>"LI"===e.tagName)),e.Blockquotes=e.Everything.filter((e=>"BLOCKQUOTE"===e.tagName)),e.Tables=e.Everything.filter((e=>"TABLE"===e.tagName&&!e.matches('[role="presentation"]')&&!e.matches('[role="none"]'))),e.StrongItalics=e.Everything.filter((e=>["STRONG","EM"].includes(e.tagName))),e.Subscripts=e.Everything.filter((e=>["SUP","SUB"].includes(e.tagName)));const i=t.checks.QA_BAD_LINK.sources;e.CustomErrorLinks=i.length?e.Links.filter((e=>i.split(",").some((t=>e.matches(t.trim()))))):[];const s=e=>n.Root.Readability.contains(e)&&!n.Exclusions.Readability.some((t=>e.matches(t)));e.Readability=[...e.Paragraphs.filter(s),...e.Lists.filter(s)];const a=t.checks.QA_NESTED_COMPONENTS.sources||'[role="tablist"], details';e.NestedComponents=a?e.Everything.filter((e=>e.matches(a))):[],e.TabIndex=e.Everything.filter((e=>e.hasAttribute("tabindex")&&"0"!==e.getAttribute("tabindex")&&!e.getAttribute("tabindex").startsWith("-"))),e.Svg=e.Everything.filter((e=>"svg"===e.tagName)),e.Buttons=e.Everything.filter((e=>"BUTTON"===e.tagName||e.matches('[role="button"]'))),e.Inputs=e.Everything.filter((e=>["INPUT","SELECT","TEXTAREA","METER","PROGRESS"].includes(e.tagName))),e.Labels=e.Everything.filter((e=>"LABEL"===e.tagName)),e.iframes=e.Everything.filter((e=>["IFRAME","AUDIO","VIDEO"].includes(e.tagName))),e.Videos=e.iframes.filter((e=>e.matches(n.Global.VideoSources))),e.Audio=e.iframes.filter((e=>e.matches(n.Global.AudioSources))),e.Visualizations=e.iframes.filter((e=>e.matches(n.Global.VisualizationSources))),e.EmbeddedContent=e.iframes.filter((e=>!e.matches(n.Global.AllEmbeddedContent)));const r=document.querySelector("html");e.Language=r.getAttribute("lang")},Found:e,initializeAnnotations:function(){t.Array=o("sa11y-annotation","document"),t.Array.forEach(((e,t)=>{e.setAttribute("data-sa11y-position",t)}))},Annotations:t}}();const P=e=>{if(0===e.shadowRoot.querySelectorAll(".sa11y-css-utilities").length){const t=document.createElement("style");t.setAttribute("class","sa11y-css-utilities"),t.textContent="[data-sa11y-overflow]{overflow:auto!important}[data-sa11y-clone-image-text]{display:none!important}[data-sa11y-readability-period]{clip:rect(1px,1px,1px,1px)!important;border:0!important;clip-path:inset(50%)!important;display:block!important;height:1px!important;overflow:hidden!important;padding:0!important;position:absolute!important;white-space:nowrap!important;width:1px!important}[data-sa11y-error-inline],[data-sa11y-error]{outline:5px solid var(--sa11y-error)!important;outline-offset:2px}[data-sa11y-warning-inline]:not([data-sa11y-error-inline]),[data-sa11y-warning]:not([data-sa11y-error]){outline:5px solid var(--sa11y-warning)!important;outline-offset:2px}[data-sa11y-pulse-border]{animation:pulse 2s 3;box-shadow:0;outline:5px solid var(--sa11y-focus-color)!important}[data-sa11y-pulse-border]:focus,[data-sa11y-pulse-border]:hover{animation:none}@keyframes pulse{0%{box-shadow:0 0 0 5px var(--sa11y-focus-color)}70%{box-shadow:0 0 0 12px var(--sa11y-pulse-color)}to{box-shadow:0 0 0 5px var(--sa11y-pulse-color)}}@media (prefers-reduced-motion:reduce){[data-sa11y-pulse-border]{animation:none!important}}@media (forced-colors:active){[data-sa11y-error-inline],[data-sa11y-error],[data-sa11y-good],[data-sa11y-pulse-border],[data-sa11y-warning-inline],[data-sa11y-warning]{forced-color-adjust:none}}",e.shadowRoot.appendChild(t)}};function R(e,t,n){if(!0===e){let e=window.location.href;const o=function(e,t){let n=null;return(...o)=>{window.clearTimeout(n),n=window.setTimeout((()=>{e(...o)}),t)}}((async()=>{e!==window.location.href&&("Closed"!==v.getItem("sa11y-panel")&&v.getItem("sa11y-panel")?(n(!1),await t()):t(),e=window.location.href)}),250);window.addEventListener("click",o),window.addEventListener("keydown",o)}}function D(e,o){const i=JSON.parse(localStorage.getItem("sa11y-dismissed")||"[]"),s=window.location.pathname,a=[...e.filter((e=>i.some((t=>((e,t)=>t.key.includes(e.dismiss)&&t.href===s&&("warning"===e.type||"good"===e.type))(e,t))))),...e.filter((e=>i.some((t=>((e,t)=>"string"==typeof t.dismissAll&&e.dismissAll===t.dismissAll&&t.href===s)(e,t)))))],r=a.length,l=e.filter((e=>!a.some((t=>t.dismiss===e.dismiss&&("warning"===e.type||"good"===e.type)))));return r?(n.Panel.dismissButton.classList.add("active"),n.Panel.dismissTooltip.innerText=t.sprintf("PANEL_DISMISS_BUTTON",r),o.object.setContent(t.sprintf("PANEL_DISMISS_BUTTON",r))):n.Panel.dismissButton.classList.remove("active"),{dismissedIssues:i,updatedResults:l,dismissCount:r,dismissedResults:a}}let M,B;function $(e,i,s,a){if(n.Global.dismissAnnotations){B=n=>{(async(e,n,i,s)=>{let a=JSON.parse(v.getItem("sa11y-dismissed"));const r=e.target;if(document.querySelector("sa11y-panel-tooltips").hidden=!1,"BUTTON"===r.tagName&&r.hasAttribute("data-sa11y-dismiss")){const e=parseInt(r.getAttribute("data-sa11y-dismiss"),10),l=n.find((t=>t.id===e));if(null===a&&(setTimeout((()=>T(t._("DISMISS_REMINDER"))),0),a=[]),l.dismiss){const e=r.hasAttribute("data-sa11y-dismiss-all")?l.dismissAll:"",t={key:l.dismiss,href:window.location.pathname,...e?{dismissAll:e}:{}},n=o(`[data-sa11y-annotation='${l.id}']`),c=n[0]?n[0].getAttribute("data-sa11y-position"):0;v.setItem("sa11y-latest-dismissed",c),v.setItem("sa11y-dismiss-item",JSON.stringify(t)),a.push(t),v.setItem("sa11y-dismissed",JSON.stringify(a)),v.removeItem("sa11y-dismiss-item");const d=r?.closest("[data-tippy-root]");d&&setTimeout((()=>{d.remove()}),0),s(!1),await i()}}})(n,e,s,a)};document.querySelector("sa11y-tooltips").shadowRoot.addEventListener("click",B),n.Panel.panel.addEventListener("click",B)}M=()=>{(async(e,t,o)=>{document.querySelector("sa11y-panel-tooltips").hidden=!0;const i=e.filter((e=>e.href!==window.location.pathname));v.setItem("sa11y-dismissed",JSON.stringify(i)),n.Panel.dismissButton.classList.remove("active"),o(!1),await t()})(i,s,a)},n.Panel.dismissButton?.addEventListener("click",M)}function G(){const e=new Date,t=String(e.getDate()).padStart(2,"0"),n=String(e.getMonth()+1).padStart(2,"0"),o=e.getFullYear(),i=(new Date).toLocaleString(),s=`${n}-${t}-${o}`,a=document.querySelector("head title"),r=!a||0===a.textContent.trim().length;return{date:i,numericDate:s,titleCheck:r,metaTitle:r?"":a.textContent,pageURL:window.location.href}}function U(e,n){const o=function(e,n){const o=e.filter((e=>"error"===e.type)),i=e.filter((e=>"warning"===e.type)),s={error:o.length,warning:i.length,dismiss:n.length};function a(e,n){const o={error:t._("ERRORS"),warning:t._("WARNINGS"),dismissed:t._("DISMISSED")}[n];if(!(e.length>0))return"";let i=`<h2>${o}</h2>`,a="<ol>",r="</ol>";return"dismissed"===n&&(a=`<details><summary>${t.sprintf("PANEL_DISMISS_BUTTON",s.dismiss)}</summary><ol>`,r="</details>"),i+=a,e.forEach((e=>{let n="";e.element&&(n=["IMG","IFRAME","AUDIO","VIDEO"].includes(e.element.tagName)?`\n              <li>\n                <strong>${t._("PREVIEW")}:</strong>\n                ${w(e)}\n              </li>\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${p(e.htmlPath)}</code></pre>\n              </li>`:`\n              <li>\n                <strong>${t._("ELEMENT")}:</strong>\n                <pre><code>${p(e.htmlPath)}</code></pre>\n              </li>`);const o=e.cssPath?`<li>\n            <strong>${t._("PATH")}:</strong>\n            <pre><code>${e.cssPath}</code></pre>\n          </li>`:"";i+=`<li>\n                <p>${e.content.replace('<hr aria-hidden="true">'," | ")}</p>\n                <ul>${n}${o}</ul>\n              </li>`})),i+=r,i}const r=a(o,"error"),l=a(i,"warning"),c=a(n,"dismissed"),d=G(),u=d.titleCheck?"":`<dt>${t._("PAGE_TITLE")}</dt><dd>${d.metaTitle}</dd>`,h=0!==s.error?`<dt>${t._("ERRORS")}</dt><dd>${s.error}</dd>`:"",m=0!==s.warning?`<dt>${t._("WARNINGS")}</dt><dd>${s.warning}</dd>`:"",g=0!==s.dismiss?`<dt>${t._("DISMISSED")}</dt><dd>${s.dismiss}</dd>`:"";return`\n      <!DOCTYPE html>\n      <html lang="${t._("LANG_CODE")}">\n      <head>\n        <meta charset="UTF-8">\n        <meta name="viewport" content="width=device-width, initial-scale=1.0">\n        <title>${t._("RESULTS")}: ${d.metaTitle}</title>\n        <style>:root{--font-primary:system-ui,"Segoe UI",roboto,helvetica,arial,sans-serif;--font-secondary:Consolas,monaco,"Ubuntu Mono","Liberation Mono","Courier New",Courier,monospace;--body-text:#333;--bg-primary:#fff;--bg-secondary:#f6f8fa;--bg-tertiary:#d7d7d7;--link-primary:#004c9b;--red-text:#d30017}@media (prefers-color-scheme:dark){:root{--body-text:#dde8ff;--bg-primary:#0a2051;--bg-secondary:#072c7c;--bg-tertiary:#0041c9;--link-primary:#64b2ff;--red-text:#fe5b5f}}*{margin:0;padding:0}article,aside,nav,ol,p,pre,section,ul{margin-bottom:1rem}body{background:var(--bg-primary);font-family:var(--font-primary);font-size:1rem;line-height:1.5;margin:0 auto;max-width:70ch;overflow-wrap:break-word;overflow-x:hidden;padding:2rem;word-break:break-word}body,h1,h2,h3{color:var(--body-text)}h1,h2,h3{line-height:1;margin-bottom:8px;padding-bottom:2px;padding-top:.875rem}h1{font-size:2.25rem}h2{font-size:1.85rem}h3{font-size:1.55rem}a{color:var(--link-primary)}a:focus,a:hover{text-decoration:none}footer,header{background:var(--bg-secondary);padding:2rem calc(50vw - 50%)}header{border-bottom:1px solid var(--bg-tertiary);margin:-2rem calc(-50vw + 50%) 2rem}footer{border-top:1px solid var(--bg-tertiary);margin:3rem calc(-50vw + 50%) -2rem;text-align:center}header>:first-child{margin-top:0;padding-top:0}header>:last-child{margin-bottom:0}code,kbd,pre,samp{background:var(--bg-secondary);border:1px solid var(--bg-tertiary);border-radius:4px;font-family:var(--font-secondary);font-size:.9rem;padding:3px 6px}pre{display:block;max-width:100%;overflow:auto;padding:1rem 1.4rem}code pre,pre code{background:inherit;border:0;color:inherit;font-size:inherit;margin:0;padding:0}code pre{display:inline}details{background:var(--bg-primary);border:2px solid var(--link-primary);border-radius:4px;padding:.6rem 1rem}summary{cursor:pointer;font-weight:700}details[open]{padding-bottom:.75rem}details[open] summary{margin-bottom:6px}details[open]>:last-child{margin-bottom:0}.two-columns{display:flex}.column{flex:1;margin-inline-end:20px}.count{max-width:220px}.column dl{width:100%}dl{padding-top:10px}dt{font-weight:700}dd{padding-bottom:10px}ol ol,ol ul,ul ol,ul ul{margin-bottom:0}ul li{margin-bottom:.5rem}ol,ul{padding-left:2rem}li li:has(pre,img,iframe,video,audio){list-style:none;margin-top:1rem}ol li:not(li li){margin-bottom:3rem}iframe,img{border:1px solid var(--bg-tertiary);display:block;max-width:50%}audio,video{border:0;display:block}.red-text{color:var(--red-text)}.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}</style>\n      </head>\n      <body>\n        <header>\n          <h1>${t._("RESULTS")}</h1>\n          <dl class="two-columns">\n            <div class="column">\n              ${u}\n              <dt>URL</dt>\n              <dd><a href="${d.pageURL}">${d.pageURL}</a></dd>\n              <dt>${t._("DATE")}</dt>\n              <dd>${d.date}</dd>\n            </div>\n            <div class="column count">\n              ${h}\n              ${m}\n              ${g}\n            </div>\n        </dl>\n        </header>\n        ${r}\n        ${l}\n        ${c}\n        <footer>\n          <p>${t.sprintf("GENERATED",'<a href="https://sa11y.netlify.app">Sa11y</a>')}</p>\n        </footer>\n      </body>\n      </html>\n    `}(e,n),i=G(),s=new Blob([o],{type:"text/html"}),a=document.createElement("a"),r=i.titleCheck?"":`_${i.metaTitle.trim().replace(/ /g,"")}`;a.href=window.URL.createObjectURL(s),a.download=`Sa11y_${i.numericDate+r}.html`,document.body.appendChild(a),a.click(),setTimeout((()=>{document.body.removeChild(a),window.URL.revokeObjectURL(a.href)}),100)}function H(e){const t=G(),n=e.filter((e=>"warning"===e.type||"error"===e.type)).map((e=>{const{type:n,content:o,htmlPath:i,cssPath:s}=e,a=o.replaceAll(/<span\s+class="visually-hidden"[^>]*>.*?<\/span>/gi,"").replaceAll('<hr aria-hidden="true">'," | ").replaceAll(/"/g,'""');const r=function(e){return e.replace(/&(#?[a-zA-Z0-9]+);/g,((e,t)=>{switch(t){case"amp":return"&";case"lt":return"<";case"gt":return">";case"quot":case"#39":return"'";default:return"#"===t.charAt(0)?String.fromCharCode("x"===t.charAt(1)?parseInt(t.substr(2),16):parseInt(t.substr(1),10)):e}}))}(String(a).replace(/<[^>]*>/g,"")),l={Title:`"${t.metaTitle}"`,URL:`"${t.pageURL}"`,Type:`"${String(n)}"`,Issue:`"${r}"`,Element:`"${i}"`};return s&&(l.Path=`"${s}"`),l})),o=Object.keys(n[0]),i=`${o.join(",")}\n${n.map((e=>o.map((t=>e[t])).join(","))).join("\n")}`,s=new Uint8Array([239,187,191]),a=new Blob([s,i],{type:"text/csv;charset=utf-8;"}),r=window.URL.createObjectURL(a),l=document.createElement("a");l.href=r,l.href=window.URL.createObjectURL(a);const c=t.titleCheck?"":`_${t.metaTitle.trim().replace(/ /g,"")}`;l.setAttribute("download",`Sa11y_${t.numericDate+c}.csv`),document.body.appendChild(l),l.click(),setTimeout((()=>{document.body.removeChild(l),window.URL.revokeObjectURL(l.href)}),100)}let F,K;const W="4.1.1";var Y='.visually-hidden{clip:rect(1px,1px,1px,1px);border:0;clip-path:inset(50%);display:block;height:1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}[hidden]{display:none!important}.header-text,.header-text-inline,h2{color:var(--sa11y-panel-primary);display:block;font-size:var(--sa11y-large-text);font-weight:600;margin-bottom:3px}.header-text-inline{display:inline-block!important}code{font-family:monospace!important;font-size:calc(var(--sa11y-normal-text) - 1px);font-weight:600}.kbd,code,kbd{background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);padding:1.6px 4.8px}.bold{font-weight:600}.error .colour,.red-text{color:var(--sa11y-red-text);font-family:var(--sa11y-font-face)}.warning .colour,.yellow-text{color:var(--sa11y-yellow-text);font-family:var(--sa11y-font-face)}.badge,.normal-badge{background-color:var(--sa11y-panel-badge);border-radius:10px;color:var(--sa11y-panel-primary);display:inline;font-size:14px;font-weight:700!important;line-height:1;min-width:10px;outline:1px solid transparent;padding:1px 5px 1.75px;text-align:center;vertical-align:baseline;white-space:nowrap}.error .badge{background:var(--sa11y-error);color:var(--sa11y-error-text)}.error-badge{background:var(--sa11y-error)!important;color:var(--sa11y-error-text)!important}.warning .badge{background:var(--sa11y-yellow-text);color:var(--sa11y-panel-bg)}.warning-badge{background:var(--sa11y-yellow-text)!important;color:var(--sa11y-panel-bg)!important}.good-contrast{background:var(--sa11y-good)!important;color:var(--sa11y-good-text)!important}#contrast-preview{background-color:#e8e8e8;background-image:linear-gradient(45deg,#ccc 25%,transparent 0,transparent 75%,#ccc 0,#ccc),linear-gradient(45deg,#ccc 25%,transparent 0,transparent 75%,#ccc 0,#ccc);background-position:0 0,5px 5px;background-size:10px 10px;border:2px dashed var(--sa11y-panel-bg-splitter);border-radius:3.2px;line-height:1;margin-top:10px;max-height:100px;overflow:clip;overflow-wrap:break-word;padding:5px}#color-pickers{display:flex;justify-content:space-between;margin-bottom:10px;margin-top:10px}#color-pickers label{align-items:center;display:flex}#color-pickers input{margin-inline-start:7px}input[type=color i]{background:var(--sa11y-panel-bg-secondary);block-size:30px;border-color:var(--sa11y-button-outline);border-radius:50%;border-style:solid;border-width:1px;inline-size:30px;padding:2px}input[type=color i]::-webkit-color-swatch-wrapper{padding:1px}input[type=color i]::-webkit-color-swatch{border-color:var(--sa11y-button-outline);border-radius:50%}input[type=color i]::-moz-color-swatch{border-color:var(--sa11y-button-outline);border-radius:50%}input[type=color i].unknown{box-shadow:0 0 0 2px var(--sa11y-yellow-text)}input[type=color i].unknown:after{align-items:center;color:#fff;content:"?";display:flex;font-size:18px;height:24px;justify-content:center;margin:-24px 0;pointer-events:none;position:absolute;width:24px;z-index:2}.close-btn{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:50%;color:var(--sa11y-panel-primary);cursor:pointer;float:var(--sa11y-float-rtl);font-size:var(--sa11y-normal-text);font-weight:400;height:32px;margin:0;position:relative;transition:all .2s ease-in-out;width:32px}.close-btn:focus,.close-btn:hover{background-color:var(--sa11y-shortcut-hover)}.close-btn:after{background:var(--sa11y-setting-switch-bg-off);content:"";inset:-7px;-webkit-mask:var(--sa11y-close-btn-svg) center no-repeat;mask:var(--sa11y-close-btn-svg) center no-repeat;position:absolute}@media screen and (forced-colors:active){.close-btn:after{filter:invert(1)}}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:focus,#container input:focus,#container select:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus,#container .switch:focus{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus:not(:focus-visible),#container [tabindex="-1"]:focus:not(:focus-visible),#container [tabindex="0"]:focus:not(:focus-visible),#container button:focus:not(:focus-visible),#container input:focus:not(:focus-visible),#container select:focus:not(:focus-visible){box-shadow:none;outline:0}#container [tabindex="-1"]:focus-visible,#container [tabindex="0"]:focus-visible,#container a:focus-visible,#container button:not(#panel-controls button):not(.switch):focus-visible,#container input:focus-visible,#container select:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}#container #panel-controls button:focus-visible,#container .switch:focus-visible{box-shadow:inset 0 0 0 4px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){#panel-controls button:focus{border:3px solid transparent}#container [tabindex="-1"]:focus,#container [tabindex="0"]:focus,#container a:focus,#container button:focus,#container select:focus,.close-btn:focus{outline:3px solid transparent!important}}';class z extends HTMLElement{constructor(e){super(),this.error=e}connectedCallback(){const e=this.attachShadow({mode:"open"}),o=document.createElement("style");o.innerHTML=":host{background:var(--sa11y-panel-bg);border-top:5px solid var(--sa11y-panel-bg-splitter);bottom:0;display:block;height:-moz-fit-content;height:fit-content;left:0;position:fixed;right:0;width:100%;z-index:999999}*{-webkit-font-smoothing:auto!important;color:var(--sa11y-panel-primary);font-family:var(--sa11y-font-face)!important;font-size:var(--sa11y-normal-text);line-height:22px!important}#dialog{margin:20px auto;max-width:900px;padding:20px}h2{font-size:var(--sa11y-large-text);margin-top:0}a{color:var(--sa11y-hyperlink);cursor:pointer;text-decoration:underline}a:focus,a:hover{text-decoration:none}p{margin-top:0}.error{background:var(--sa11y-error);border:2px dashed #f08080;color:var(--sa11y-error-text);margin-bottom:0;padding:5px}"+Y,e.appendChild(o);const i=document.createElement("div");i.setAttribute("id","dialog"),i.setAttribute("tabindex","-1");const s=window.location,a=`## Error Description\n\`\`\`javascript\n${this.error.stack}\n\`\`\`\n\n## Details\n- **URL:** ${s}\n- **Version:** ${W}\n\n## Comments\n`,r=`https://github.com/ryersondmp/sa11y/issues/new?title=Bug%20report&body=${encodeURIComponent(a)}`;i.innerHTML=`\n      <button class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n      <h2>${t._("ERROR")}</h2>\n      <p>${t.sprintf("CONSOLE_ERROR","https://forms.gle/sjzK9XykETaoqZv99",r)}</p>\n      <p class="error">${p(this.error.stack)}<br><br>Version: ${W} <br> URL: ${s}</p>\n    `,e.appendChild(i),setTimeout((()=>{n.Panel.toggle.style.display="none";const e=document.querySelector("sa11y-console-error");e.shadowRoot.getElementById("dialog").focus();e.shadowRoot.querySelector(".close-btn").addEventListener("click",(()=>{e.remove()}))}),0)}}class Q extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"});const e=document.createElement("style");e.textContent='a,button,code,div,h1,h2,h3,kbd,label,li,ol,p,pre,span,strong,svg,ul{all:unset;box-sizing:border-box!important}:after,:before{all:unset}div{display:block}*{-webkit-font-smoothing:auto!important;font-family:var(--sa11y-font-face)!important}label,li,ol,p,ul{font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;line-height:22px!important;text-align:start;word-break:break-word}.sa11y-overflow{overflow:auto}iframe,img,video{border:0;display:block;height:auto;max-width:100%}audio{max-width:100%}#toggle{align-items:center;background:linear-gradient(0deg,#e040fb,#00bcd4);background-color:var(--sa11y-setting-switch-bg-off);background-size:150% 150%;border-radius:50%;bottom:15px;color:#fff;cursor:pointer;display:flex;height:55px;inset-inline-end:18px;justify-content:center;margin:0;overflow:visible;position:fixed;transition:all .2s ease-in-out;width:55px;z-index:2147483644}#toggle.left,#toggle.top-left{inset-inline-start:18px}#toggle.top-left,#toggle.top-right{bottom:unset;top:15px}@media screen and (forced-colors:active){#toggle{background:ButtonFace!important;border:2px solid transparent}}#toggle svg{height:35px;width:35px}#toggle svg path{fill:var(--sa11y-panel-bg)}#toggle:focus,#toggle:hover{animation:sa11y-toggle-gradient 3s ease}#toggle:disabled:focus,#toggle:disabled:hover{animation:none}#toggle.on{background:linear-gradient(180deg,#e040fb,#00bcd4)}#toggle:disabled{background:unset;background-color:var(--sa11y-setting-switch-bg-off);cursor:not-allowed}#notification-badge{text-wrap:nowrap;align-items:center;background-color:#eb0000;border:1px solid transparent;border-radius:12px;color:#fff;display:none;font-size:13.5px;font-weight:400;justify-content:center;line-height:1;min-width:20px;padding:2.5px;position:absolute;right:-3px;top:-5.5px}#notification-badge.notification-badge-warning{background-color:var(--sa11y-warning-hover);border:1px solid var(--sa11y-warning);color:var(--sa11y-warning-text)}#panel{background:var(--sa11y-panel-bg);border-radius:4px;bottom:25px;box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15);inset-inline-end:42px;opacity:0;overflow:visible;position:fixed;transform:scale(0);transform-origin:100% 100%;transition:transform .2s,opacity background .2s .2s;visibility:hidden;z-index:2147483643}#panel.left,#panel.top-left{inset-inline-end:unset;inset-inline-start:42px}#panel.top-left,#panel.top-right{bottom:unset;top:35px}#panel.active{height:auto;opacity:1;transform:scale(1);transform-origin:bottom right;transition:transform .2s,opacity .2s;visibility:visible}@media screen and (forced-colors:active){#panel{border:2px solid transparent}}#panel.active.left,[dir=rtl] #panel.active{transform-origin:bottom left}#panel.active.top-left{transform-origin:top left}#panel.active.top-right{transform-origin:top right}#panel-alert{display:none;opacity:0}#panel-alert.active{display:block;opacity:1}#panel-alert-content{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-primary);line-height:22px;max-height:400px;overflow-y:auto;padding:15px 20px 15px 15px;position:relative}.top-left #panel-alert-content,.top-right #panel-alert-content{border:0}#panel-alert-preview .close-tooltip{display:none}#panel-alert-preview,#panel-alert-text{font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}.panel-alert-preview{background:var(--sa11y-panel-bg-secondary);border:1px dashed var(--sa11y-panel-bg-splitter);border-radius:5px;margin-top:15px;padding:10px}.panel-alert-preview ul{margin:0;margin-block-end:0;margin-block-start:0;padding:0;position:relative}.panel-alert-preview li{display:list-item;margin:5px 10px 0 20px;padding-bottom:5px}.element-preview{background-color:var(--sa11y-element-preview);border-radius:3.2px;margin-bottom:10px;overflow-wrap:break-word;padding:5px}button[data-sa11y-dismiss]{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:block;margin:10px 5px 5px 0;margin-inline-end:15px;padding:4px 8px}button[data-sa11y-dismiss]:focus,button[data-sa11y-dismiss]:hover{background:var(--sa11y-shortcut-hover)}h2{font-size:var(--sa11y-large-text);font-weight:700}h2,h3{display:block;margin-bottom:3px}h3{font-size:calc(var(--sa11y-large-text) - 1px)}h3,strong{font-weight:600}a:not(#outline-list a):not(.edit){border-bottom:0;color:var(--sa11y-hyperlink);cursor:pointer;font-weight:500;text-decoration:underline}a:focus,a:hover{text-decoration:none!important}hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}#dismiss-button,#skip-button{background:var(--sa11y-panel-bg-secondary);border:1px solid var(--sa11y-button-outline);border-radius:50px;cursor:pointer;display:none;height:36px;margin-inline-end:8px;margin-inline-start:2px;overflow:visible;position:relative;text-align:center;transition:all .1s ease-in-out;width:36px}#dismiss-button.active,#skip-button.active{display:block}#dismiss-button:disabled,#skip-button:disabled{background:none;border:0;box-shadow:none;cursor:default}#dismiss-button:before,#skip-button:before{content:"";inset:-5px;position:absolute}#dismiss-button:focus:not(:disabled),#dismiss-button:hover:not(:disabled),#skip-button:focus:not(:disabled),#skip-button:hover:not(:disabled){background-color:var(--sa11y-shortcut-hover)}#panel.left #dismiss-button,#panel.left #skip-button,#panel.top-left #dismiss-button,#panel.top-left #skip-button{margin-inline-end:2px;margin-inline-start:8px}.dismiss-icon{background:var(--sa11y-setting-switch-bg-off);display:inline-block;height:24px;margin-bottom:-4px;-webkit-mask:var(--sa11y-dismiss-icon) center no-repeat;mask:var(--sa11y-dismiss-icon) center no-repeat;width:24px}@media screen and (forced-colors:active){.dismiss-icon{filter:invert(1)}}#panel-content{align-items:center;color:var(--sa11y-panel-primary);display:flex;padding:6px}#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{height:26px;margin:0 auto;width:26px}#panel-content.errors .panel-icon{background:var(--sa11y-panel-error);margin-top:-2px;-webkit-mask:var(--sa11y-error-svg) center no-repeat;mask:var(--sa11y-error-svg) center no-repeat}#panel-content.good .panel-icon{background:var(--sa11y-good);-webkit-mask:var(--sa11y-good-svg) center no-repeat;mask:var(--sa11y-good-svg) center no-repeat}#panel-content.warnings .panel-icon{background:var(--sa11y-yellow-text);-webkit-mask:var(--sa11y-warning-svg) center no-repeat;mask:var(--sa11y-warning-svg) center no-repeat;transform:scaleX(var(--sa11y-icon-direction))}@media screen and (forced-colors:active){#panel-content.errors .panel-icon,#panel-content.good .panel-icon,#panel-content.warnings .panel-icon{filter:invert(1)}}#panel.left #panel-content,#panel.top-left #panel-content{flex-direction:row-reverse}#status{font-size:var(--sa11y-large-text)}#status,.panel-count{color:var(--sa11y-panel-primary)}.panel-count{background-color:var(--sa11y-panel-badge);border-radius:4px;font-size:15px;font-weight:400;margin-left:3px;margin-right:3px;padding:2px 4px}#images-panel,#outline-panel,#page-issues,#settings-panel{color:var(--sa11y-panel-primary);display:none;opacity:0}#images-panel.active,#outline-panel.active,#page-issues.active,#settings-panel.active{display:block;opacity:1}.panel-header{display:flex;justify-content:space-between;padding:10px 15px 0;text-align:start}#about-content{padding-top:5px}#about-content p{display:block;margin-block-end:1em}#images-content,#outline-content,#page-issues-content,#settings-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter);padding:0 15px 10px}.top-left #images-content,.top-left #outline-content,.top-left #page-issues-content,.top-left #settings-content,.top-right #images-content,.top-right #outline-content,.top-right #page-issues-content,.top-right #settings-content{border:0}#page-issues-content{max-height:160px;overflow-y:auto}#settings-content{max-height:400px;overflow-y:auto}#images-content,#outline-content{max-height:250px;overflow-y:auto}#outline-panel .outline-list-item.sa11y-red-text,#settings-panel .sa11y-red-text{color:var(--sa11y-red-text)}#outline-list{display:block;margin:0;padding:0}#outline-list a{cursor:pointer;display:block;text-decoration:none}#outline-list li{display:block;list-style-type:none;margin-bottom:3px;margin-top:0;padding:0}#outline-list li:first-child{margin-top:5px}#outline-list li a:focus,#outline-list li a:hover{background:var(--sa11y-panel-outline-hover);border-radius:5px;box-shadow:0 0 0 2px var(--sa11y-panel-outline-hover);display:block}#outline-list .outline-2{margin-inline-start:15px}#outline-list .outline-3{margin-inline-start:30px}#outline-list .outline-4{margin-inline-start:45px}#outline-list .outline-5{margin-inline-start:60px}#outline-list .outline-6{margin-inline-start:75px}#images-list{display:block;margin:0;padding:0}#images-list li{border-bottom:1px solid var(--sa11y-panel-bg-splitter);display:block;list-style-type:none;margin:15px 0;overflow:hidden;width:100%}#images-list li:first-child{margin-top:5px}#images-list li:last-child{border:none;margin-bottom:0}#images-list li .alt{padding:2px 5px 10px}#images-list li .edit-block{display:flex;justify-content:flex-end;margin-bottom:15px}#images-list li .edit{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;margin-inline-end:5px;padding:4px 7px;position:relative;text-decoration:none}#images-list li .edit:focus,#images-list li .edit:hover{background-color:var(--sa11y-shortcut-hover)}#images-list li .edit:before{content:"";inset:-10px;position:absolute}#images-list li img{border-radius:5px;float:inline-start;margin-block-end:15px;margin-inline-end:10px;max-width:110px}#images-list li.warning .alt{color:var(--sa11y-yellow-text)}#images-list li.warning img{background-color:var(--sa11y-yellow-text);border:5px solid var(--sa11y-yellow-text)}#images-list li.error .alt{color:var(--sa11y-error)}#images-list li.error img{background-color:var(--sa11y-error);border:5px solid var(--sa11y-error)}#images-list li.good img{background-color:var(--sa11y-panel-badge);border:5px solid var(--sa11y-panel-badge)}@media screen and (forced-colors:active){#images-list li img{background-color:ButtonBorder!important}}.move-panel-icon{height:18px;-webkit-mask:var(--sa11y-move-panel-icon);mask:var(--sa11y-move-panel-icon);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;width:18px}.info-icon,.move-panel-icon{background:var(--sa11y-setting-switch-bg-off);display:inline-block;vertical-align:middle}.info-icon{height:20px;margin-top:-2px;-webkit-mask:var(--sa11y-info-icon);mask:var(--sa11y-info-icon);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;width:20px}.sun-icon{-webkit-mask:var(--sa11y-sun-icon);mask:var(--sa11y-sun-icon);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat}.moon-icon,.sun-icon{background:var(--sa11y-setting-switch-bg-off);display:inline-block;height:18px;vertical-align:middle;width:18px}.moon-icon{-webkit-mask:var(--sa11y-moon-icon);mask:var(--sa11y-moon-icon);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat}.error-icon{background:var(--sa11y-error-text);margin-bottom:-4px;-webkit-mask:var(--sa11y-error-svg);mask:var(--sa11y-error-svg);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat}.error-icon,.hidden-icon{display:inline-block;height:16px;width:16px}.hidden-icon{margin-bottom:-3px;-webkit-mask:var(--sa11y-hidden-icon-svg);mask:var(--sa11y-hidden-icon-svg);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat}.hidden-icon,.link-icon{background:var(--sa11y-panel-primary)}.link-icon{display:inline-block;height:16px;margin-bottom:-3.5px;-webkit-mask:var(--sa11y-link-icon-svg);mask:var(--sa11y-link-icon-svg);-webkit-mask-position:center;mask-position:center;-webkit-mask-repeat:no-repeat;mask-repeat:no-repeat;width:16px}.error-badge .hidden-icon,.error-badge .link-icon{background:var(--sa11y-error-text)}.warning-badge .hidden-icon,.warning-badge .link-icon{background:var(--sa11y-panel-bg)}.error .link-icon{background:var(--sa11y-error-text)}.warning .link-icon{background:var(--sa11y-panel-bg)}@media screen and (forced-colors:active){.error-icon,.hidden-icon,.info-icon,.link-icon,.moon-icon,.move-panel-icon,.sun-icon{filter:invert(1)}}#panel-controls{border-bottom:1px solid var(--sa11y-panel-bg-splitter);border-radius:0 0 4px 4px;display:flex;overflow:hidden}#panel-controls button{background:var(--sa11y-panel-bg-secondary);background-color:var(--sa11y-panel-bg-secondary);border-inline-end:1px solid var(--sa11y-panel-bg-splitter);border-top:1px solid var(--sa11y-panel-bg-splitter);color:var(--sa11y-panel-secondary);cursor:pointer;display:block;font-size:var(--sa11y-normal-text);font-weight:400;height:30px;line-height:0;margin:0;opacity:1;outline:0;padding:0;position:relative;text-align:center;transition:background .2s;width:100%}#panel-controls button.active,#panel-controls button:hover{background-color:var(--sa11y-shortcut-hover)}#panel-controls button.active{font-weight:600}#export-results-mode,label{color:var(--sa11y-panel-primary);display:inline-block;font-weight:400;margin:0;width:100%}label:not(#colour-filter-mode,#export-results-mode){cursor:pointer}#panel.right #panel-controls:has(#images-toggle):after{content:"";width:80px}#panel.left #panel-controls:has(#images-toggle):before{content:"";width:50px}#settings-panel .appearance-group,#settings-panel .export-results-group{display:flex;margin:5px 0}#settings-panel .appearance-group button,#settings-panel .export-results-group button{align-items:center;border:2px solid var(--sa11y-setting-switch-bg-off);border-radius:5px;cursor:pointer;display:flex;justify-content:center;margin:2px 0;margin-inline-end:4px;margin-inline-start:8px;min-height:34px;min-width:44px;position:relative;text-align:center;white-space:nowrap}#settings-panel .appearance-group button:focus,#settings-panel .appearance-group button:focus-within,#settings-panel .appearance-group button:hover,#settings-panel .export-results-group button:focus,#settings-panel .export-results-group button:focus-within,#settings-panel .export-results-group button:hover{background:var(--sa11y-shortcut-hover)}#settings-panel .appearance-group button:before,#settings-panel .export-results-group button:before{content:"";inset:-7px;position:absolute}#settings-panel .appearance-group button .text,#settings-panel .export-results-group button .text{color:var(--sa11y-setting-switch-bg-off);font-weight:600;padding:0 6px}#settings-panel .switch{background:none;border:0;border-radius:5px;color:var(--sa11y-setting-switch-bg-off);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:600;height:44px;margin:0;padding:7px 10px;position:relative;text-align:end;width:105px}#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{content:"";display:inline-block;height:27px;margin:0 4px 4px;vertical-align:middle;width:27px}#settings-panel .switch[aria-pressed=true]:after{background:var(--sa11y-setting-switch-bg-on);-webkit-mask:var(--sa11y-setting-switch-on-svg) center no-repeat;mask:var(--sa11y-setting-switch-on-svg) center no-repeat}#settings-panel .switch[aria-pressed=false]:after{background:var(--sa11y-setting-switch-bg-off);-webkit-mask:var(--sa11y-setting-switch-off-svg) center no-repeat;mask:var(--sa11y-setting-switch-off-svg) center no-repeat}@media screen and (forced-colors:active){#settings-panel .switch[aria-pressed=false]:after,#settings-panel .switch[aria-pressed=true]:after{filter:invert(1)}}#settings-panel #settings-options li{align-items:center;border-bottom:1px solid var(--sa11y-panel-bg-splitter);display:flex;justify-content:space-between;list-style-type:none;padding:1px 0}#settings-panel #settings-options li:last-child{border:none}#page-issues{align-items:center;color:var(--sa11y-panel-primary)}#page-issues-list{display:block;margin-top:4px}#page-issues-list li{display:block;margin:0 0 10px}.top-left.has-page-issues #page-issues,.top-right.has-page-issues #page-issues{border-top:1px solid var(--sa11y-panel-bg-splitter);margin-top:-1px}#panel-colour-filters{align-items:center;color:var(--sa11y-panel-primary);display:none;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;line-height:22px}#panel-colour-filters.active{display:flex}#panel-colour-filters p{padding:6px 20px 6px 6px;width:100%}#panel-colour-filters[data-colour=protanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image:linear-gradient(94deg,#786719 11%,#e0c600 36%,#e0c600 47%,#0059e3 75%,#0042aa 91%);border-image-slice:1}#panel-colour-filters[data-colour=deuteranopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image:linear-gradient(270deg,#567fdb,#a4a28d 48%,#c3ad14 69%,#a79505);border-image-slice:1}#panel-colour-filters[data-colour=tritanopia]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image:linear-gradient(270deg,#b1506f,#0696c1 35%,#f3a9ba 70%,#d91c5d 87%,#fe015c);border-image-slice:1}#panel-colour-filters[data-colour=monochromacy]{border-bottom:6px solid transparent;-o-border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image:linear-gradient(270deg,#000,#a7a7a7 50%,#000);border-image-slice:1}#panel-colour-filters[data-colour=protanopia] .panel-icon{background:var(--sa11y-panel-error)}#panel-colour-filters[data-colour=deuteranopia] .panel-icon{background:var(--sa11y-good-hover)}#panel-colour-filters[data-colour=tritanopia] .panel-icon{background:var(--sa11y-blue)}#panel-colour-filters[data-colour=monochromacy] .panel-icon{background:linear-gradient(90deg,#38a459 20%,red 50%,#0077c8 80%)}#panel-colour-filters .panel-icon{height:30px;margin-inline-end:5px;margin-inline-start:10px;-webkit-mask:var(--sa11y-low-vision-icon) center no-repeat;mask:var(--sa11y-low-vision-icon) center no-repeat;width:30px}@media screen and (forced-colors:active){#panel-colour-filters .panel-icon{forced-color-adjust:none}}.select-dropdown{align-items:center;display:flex;position:relative}.select-dropdown:after{border-left:5px solid transparent;border-right:5px solid transparent;border-top:5px solid var(--sa11y-setting-switch-bg-off);content:" ";inset-inline-end:14px;position:absolute}#colour-filter-select{-webkit-appearance:none;-moz-appearance:none;appearance:none;background:var(--sa11y-panel-bg);border:2px solid var(--sa11y-setting-switch-bg-off);border-radius:5px;color:var(--sa11y-setting-switch-bg-off);cursor:pointer;font-size:var(--sa11y-normal-text);font-weight:600;height:30px;margin-inline-end:4px;padding-inline-end:25px;padding-inline-start:5px;position:relative;text-align:end;vertical-align:middle}#colour-filter-select:focus,#colour-filter-select:hover{background:var(--sa11y-shortcut-hover)}#colour-filter-select.active{box-shadow:0 0 0 2px var(--sa11y-setting-switch-bg-on)}#colour-filter-item label,#colour-filter-item select{margin-bottom:9px;margin-top:10px}#readability-panel{display:none;opacity:0}#readability-panel.active{display:block;opacity:1}.top-left #readability-content,.top-right #readability-content{border-top:1px solid var(--sa11y-panel-bg-splitter)}.left #readability-content,.right #readability-content{border-bottom:1px solid var(--sa11y-panel-bg-splitter)}#readability-content{color:var(--sa11y-panel-primary);padding:10px 15px;width:100%}#readability-details{list-style-type:none;margin:0;padding:0;white-space:normal}#readability-details li{display:inline-block;list-style-type:none;margin:0;padding-inline-end:10px}.readability-score{background-color:var(--sa11y-panel-badge);border-radius:4px;color:var(--sa11y-panel-primary);margin-inline-start:5px;padding:2px 5px}#readability-info{margin-inline-start:10px}#skip-to-page-issues{display:none}#panel.has-page-issues #skip-to-page-issues{clip:rect(0,0,0,0);background:var(--sa11y-panel-bg);border:0;border-radius:5px;display:block;font-weight:600;height:1px;margin:-1px;overflow:hidden;padding:0;position:absolute;white-space:nowrap;width:1px}#panel.has-page-issues #skip-to-page-issues:focus{clip:auto;height:auto;margin:0;overflow:visible;padding:7px 10px;white-space:normal;width:auto;z-index:1}.hide-settings-border{border-bottom:0!important;padding:0 15px!important}.hide-settings-border li:not(#colour-filter-item){display:none!important}.hide-settings-border #about-content{display:none}.hide-settings-border.scrollable:before{all:unset}#contrast-tools{display:none}::-webkit-scrollbar{height:6px;width:7px}::-webkit-scrollbar-thumb{background-color:var(--sa11y-button-outline);border-radius:6px}*{scrollbar-color:var(--sa11y-button-outline);scrollbar-width:thin}.scrollable:before{animation:fade 1s ease-in-out;background:linear-gradient(180deg,transparent 70%,var(--sa11y-panel-scrollable) 100%);background-position:bottom;bottom:auto;content:"";height:250px;left:0;position:absolute;right:0;top:auto;transition:opacity 1s ease-in-out;width:100%;z-index:-1}#settings-content.scrollable:before{height:400px}.top-left .scrollable:before,.top-right .scrollable:before{border-radius:5px}#page-issues-content.scrollable:before{height:160px}#panel-alert.scrollable:before{height:200px}@keyframes sa11y-toggle-gradient{0%{background-position:50% 0}50%{background-position:50% 100%}to{background-position:50% 0}}@keyframes fade{0%{opacity:0}to{opacity:1}}@media (prefers-reduced-motion:reduce){*{animation:none!important;transform:none!important;transition:none!important}}#panel{width:400px}#container:lang(en) #panel{width:315px}#container:lang(da) #panel,#container:lang(de) #panel,#container:lang(nb) #panel,#container:lang(pl) #panel,#container:lang(sv) #panel,#container:lang(zh) #panel{width:350px}#container:lang(bg) .switch:not(#export-results-item *),#container:lang(es) .switch:not(#export-results-item *){width:225px!important}#container:not(:lang(en)):not(:lang(de)) .switch{width:205px}'+Y,this.shadowRoot.appendChild(e);const o="On"===v.getItem("sa11y-developer"),i="On"===v.getItem("sa11y-readability"),s=v.getItem("sa11y-theme"),a=v.getItem("sa11y-position"),r=n.Global.checkAllHideToggles,l=n.Global.developerPlugin?`\n      <li id="developer-item" ${r?"hidden":""}>\n        <label id="check-developer" for="developer-toggle">\n          ${t._("DEVELOPER_CHECKS")} <span class="info-icon"></span>\n        </label>\n        <button type="button" id="developer-toggle" class="switch"\n          aria-labelledby="check-developer" aria-describedby="check-developer-desc"\n          aria-pressed="${o?"true":"false"}"\n        >${o?t._("ON"):t._("OFF")}</button>\n        <div id="check-developer-desc" hidden>${t._("DEVELOPER_DESC")}</div>\n      </li>`:"",c=n.Readability.Plugin?`\n      <li id="readability-item">\n        <label id="check-readability" for="readability-toggle">${t._("READABILITY")}</label>\n        <button type="button" id="readability-toggle" aria-labelledby="check-readability" class="switch"\n          aria-pressed="${i?"true":"false"}"\n        >${i?t._("ON"):t._("OFF")}</button>\n      </li>`:"",d=n.Global.colourFilterPlugin?`\n      <li id="colour-filter-item">\n        <label id="colour-filter-mode" for="colour-filter">${t._("COLOUR_FILTER")}</label>\n        <div class="select-dropdown">\n          <select id="colour-filter-select">\n            <option value="0">${t._("OFF")}</option>\n            <option value="1">${t._("PROTANOPIA")}</option>\n            <option value="2">${t._("DEUTERANOPIA")}</option>\n            <option value="3">${t._("TRITANOPIA")}</option>\n            <option value="4">${t._("MONOCHROMACY")}</option>\n          </select>\n        </div>\n      </li>`:"",p=n.Global.colourFilterPlugin?`\n      <div id="panel-colour-filters" role="region" aria-labelledby="colour-filter-mode">\n        <div id="filter-icon" class="panel-icon" role="img"></div>\n        <p>${t._("COLOUR_FILTER_MESSAGE")}</p>\n      </div>`:"",u=n.Global.exportResultsPlugin?`\n      <li id="export-results-item">\n        <span id="export-results-mode">${t._("EXPORT_RESULTS")}</span>\n        <div class="export-results-group">\n          <button type="button" id="export-csv" aria-describedby="export-results-mode">\n            <span class="text">CSV</span>\n          </button>\n          <button type="button" id="export-html" aria-describedby="export-results-mode">\n            <span class="text">HTML</span>\n          </button>\n        </div>\n      </li>`:"",h=n.Global.aboutContent?`\n      <div id="about-content">${n.Global.aboutContent}</div>`:"",m=`\n      <button type="button" aria-expanded="false" id="toggle" aria-describedby="notification-badge" aria-label="${t._("MAIN_TOGGLE_LABEL")}" class="${a}" disabled>\n        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path d="M256 48c114.953 0 208 93.029 208 208 0 114.953-93.029 208-208 208-114.953 0-208-93.029-208-208 0-114.953 93.029-208 208-208m0-40C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 56C149.961 64 64 149.961 64 256s85.961 192 192 192 192-85.961 192-192S362.039 64 256 64zm0 44c19.882 0 36 16.118 36 36s-16.118 36-36 36-36-16.118-36-36 16.118-36 36-36zm117.741 98.023c-28.712 6.779-55.511 12.748-82.14 15.807.851 101.023 12.306 123.052 25.037 155.621 3.617 9.26-.957 19.698-10.217 23.315-9.261 3.617-19.699-.957-23.316-10.217-8.705-22.308-17.086-40.636-22.261-78.549h-9.686c-5.167 37.851-13.534 56.208-22.262 78.549-3.615 9.255-14.05 13.836-23.315 10.217-9.26-3.617-13.834-14.056-10.217-23.315 12.713-32.541 24.185-54.541 25.037-155.621-26.629-3.058-53.428-9.027-82.141-15.807-8.6-2.031-13.926-10.648-11.895-19.249s10.647-13.926 19.249-11.895c96.686 22.829 124.283 22.783 220.775 0 8.599-2.03 17.218 3.294 19.249 11.895 2.029 8.601-3.297 17.219-11.897 19.249z"/></svg>\n        <div id="notification-badge">\n          <span id="notification-count"></span>\n          <span id="notification-text" class="visually-hidden"></span>\n        </div>\n      </button>`,g=`\n      <div id="page-issues">\n        <div class="panel-header">\n          <h2 id="page-issues-header" tabindex="-1">${t._("PAGE_ISSUES")}</h2>\n        </div>\n        <div id="page-issues-content">\n          <ul id="page-issues-list" role="list" aria-labelledby="page-issues-header"></ul>\n        </div>\n      </div>`,f=`\n      <div id="outline-panel" role="tabpanel" aria-labelledby="outline-header">\n        <div class="panel-header">\n          <h2 id="outline-header" tabindex="-1">${t._("OUTLINE")}</h2>\n        </div>\n        <div id="outline-content">\n          <ul id="outline-list" tabindex="0" role="list" aria-labelledby="outline-header"></ul>\n        </div>\n        <div id="readability-panel">\n          <div id="readability-content">\n            <h2 class="header-text-inline">${t._("READABILITY")}</h2>\n            <p id="readability-info"></p>\n            <ul id="readability-details"></ul>\n          </div>\n        </div>\n      </div>`,b=n.Global.showImageOutline?`\n      <div id="images-panel" role="tabpanel" aria-labelledby="images-header">\n        <div class="panel-header">\n          <h2 id="images-header" tabindex="-1">${t._("IMAGES")}</h2>\n        </div>\n        <div id="images-content">\n          <ul id="images-list" tabindex="0" role="list" aria-labelledby="images-header"></ul>\n        </div>\n      </div>`:"",y="left"===a||"top-left"===a?"true":"false",E=n.Global.showMovePanelToggle?`<button type="button" id="move-panel"\n          aria-label="${t._("MOVE_PANEL")}"\n          aria-pressed="${y}"\n          ><span class="move-panel-icon"></span>\n        </button>`:"",A=`\n      <div id="settings-panel" role="tabpanel" aria-labelledby="settings-header">\n        <div class="panel-header">\n          <h2 id="settings-header" tabindex="-1">${t._("SETTINGS")}</h2>\n        </div>\n        <div id="settings-content">\n          <ul id="settings-options">\n            ${l}\n            ${c}\n            <li id="appearance-item">\n              <span id="appearance-mode">${t._("APPEARANCE")}</span>\n              <div class="appearance-group">\n                <button type="button" id="theme-toggle"\n                  aria-label="${t._("DARK_MODE")}"\n                  aria-pressed=${"dark"===s?"true":"false"}\n                ><span class="moon-icon"></span></button>\n                ${E}\n              </div>\n            </li>\n            ${u}\n            ${d}\n          </ul>\n          ${h}\n        </div>\n      </div>`,_=`\n      <div id="panel-alert" role="alertdialog" aria-labelledby="alert-heading" aria-describedby="panel-alert-text">\n        <div id="panel-alert-content">\n          <div class="header-text">\n            <button type="button" id="close-alert" class="close-btn" aria-label="${t._("ALERT_CLOSE")}"></button>\n            <h2 id="alert-heading">${t._("ALERT_TEXT")}</h2>\n          </div>\n          <p id="panel-alert-text"></p>\n          <div id="panel-alert-preview"></div>\n        </div>\n      </div>`,I=`\n      <div id="panel-content">\n        <button type="button" id="skip-to-page-issues">\n          ${t._("SKIP_TO_PAGE_ISSUES")}\n        </button>\n        <button type="button" id="skip-button">\n          <div class="panel-icon"></div>\n          <span class="visually-hidden">${t._("SHORTCUT_SR")}</span>\n        </button>\n        <button type="button" id="dismiss-button">\n          <div class="dismiss-icon"></div>\n          <span id="dismiss-tooltip" class="visually-hidden"></span>\n        </button>\n        <div id="panel-text">\n          <h1 class="visually-hidden">${t._("PANEL_HEADING")}</h1>\n          <p id="status" aria-live="polite"></p>\n        </div>\n      </div>`,L=`<button type="button" role="tab" aria-expanded="false" id="images-toggle" aria-controls="images-panel">${t._("IMAGES")}</button>`,T=`\n      <div id="panel-controls" role="tablist" aria-orientation="horizontal">\n        <button type="button" role="tab" aria-expanded="false" id="outline-toggle" aria-controls="outline-panel">${t._("OUTLINE")}</button>\n        ${n.Global.showImageOutline?L:""}\n        <button type="button" role="tab" aria-expanded="false" id="settings-toggle" aria-controls="settings-panel">${t._("SETTINGS")}</button>\n      </div>`,x=document.createElement("div");x.setAttribute("id","container"),x.setAttribute("role","region"),x.setAttribute("data-sa11y-version",W),x.setAttribute("lang",t._("LANG_CODE")),x.setAttribute("aria-label",t._("CONTAINER_LABEL")),x.setAttribute("dir",n.Global.langDirection),x.innerHTML="top-left"===a||"top-right"===a?`\n        ${m}\n        <div id="panel" class="${a}">\n          ${I}\n          ${p}\n          ${T}\n          ${f}\n          ${b}\n          ${A}\n          ${_}\n          ${g}\n        </div>`:`\n        ${m}\n        <div id="panel" class="${a}">\n          ${g}\n          ${f}\n          ${b}\n          ${A}\n          ${_}\n          ${p}\n          ${I}\n          ${T}\n        </div>`,this.shadowRoot.appendChild(x),n.initializePanelSelectors()}}const V=()=>{n.Panel.outlineToggle.classList.add("active"),n.Panel.outline.classList.add("active"),n.Panel.outlineToggle.setAttribute("aria-expanded","true"),v.setItem("sa11y-outline","Opened"),k(n.Panel.outlineList,n.Panel.outlineContent);o("sa11y-heading-label","root").forEach((e=>e.hidden=!1));const e=new CustomEvent("sa11y-build-heading-outline");document.dispatchEvent(e)},j=()=>{n.Panel.outline.classList.remove("active"),n.Panel.outlineToggle.classList.remove("active"),n.Panel.outlineToggle.setAttribute("aria-expanded","false"),v.setItem("sa11y-outline","Closed");o("sa11y-heading-label","root").forEach((e=>e.hidden=!0))},q=()=>{n.Panel.imagesToggle.classList.add("active"),n.Panel.images.classList.add("active"),n.Panel.imagesToggle.setAttribute("aria-expanded","true"),v.setItem("sa11y-images","Opened"),k(n.Panel.imagesList,n.Panel.imagesContent);const e=new CustomEvent("sa11y-build-image-outline");document.dispatchEvent(e)},X=()=>{n.Global.showImageOutline&&(n.Panel.imagesToggle.classList.remove("active"),n.Panel.images.classList.remove("active"),n.Panel.imagesToggle.setAttribute("aria-expanded","false"),v.setItem("sa11y-images","Closed"))},Z=()=>{n.Panel.settingsToggle.classList.add("active"),n.Panel.settings.classList.add("active"),n.Panel.settingsToggle.setAttribute("aria-expanded","true"),v.setItem("sa11y-settings","Opened"),k(n.Panel.settingsContent,n.Panel.settingsContent,t._("SETTINGS"))},J=()=>{n.Panel.settings.classList.remove("active"),n.Panel.settingsToggle.classList.remove("active"),n.Panel.settingsToggle.setAttribute("aria-expanded","false"),v.setItem("sa11y-settings","Closed")};function ee(e,i,s){const a=()=>{const r=[];let l;if(e.map((e=>i.find((t=>e.key===t.dismiss&&e.href===window.location.pathname)))).filter(Boolean).forEach((e=>Object.assign(e,{dismissedHeading:!0}))),s.showTitleInPageOutline){const e=document.querySelector("head title");if(e&&0!==e.textContent.trim().length){const n=f(e);l=`<li><span class="badge">${t._("TITLE")}</span> ${u(n)}</li>`}else l=`<li><div class="badge error-badge"><span aria-hidden="true"><span class="error-icon"></span></span> ${t._("TITLE")}</div> <div class="badge error-badge">${t._("MISSING")}</div></li>`;r.push(l)}return i.forEach((e=>{const o=e.element,i=e.headingLevel,a=e.text,l=e.index,c=e.type,d=e.hidden,p=e.visibleParent,u=e.dismissedHeading,{isWithinRoot:h}=e;if(!(n.Exclusions.Outline?O.Found.ExcludedHeadings:[]).includes(o)){const e=!0===d?'<span class="hidden-icon"></span><span class="visually-hidden">Hidden</span>':"",n=!0===d?'class="hidden-h"':"",m=!0===s.showHinPageOutline||1===s.showHinPageOutline?"H":"";let g;"error"===c&&!0===h?(g=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${n}>\n            <span class="badge error-badge">\n            <span aria-hidden="true">${e}\n              <span class="error-icon"></span>\n            </span>\n            <span class="visually-hidden">${t._("ERROR")}</span> ${m+i}</span>\n            <strong class="outline-list-item red-text">${a}</strong>\n          </a>\n        </li>`,r.push(g)):"warning"!==c||u||!0!==h?(g=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${n}>\n            <span class="badge">${e} ${m+i}</span>\n            <span class="outline-list-item">${a}</span>\n          </a>\n        </li>`,r.push(g)):(g=`\n        <li class="outline-${i}">\n          <a role="button" id="sa11y-link-${l}" tabindex="-1" ${n}>\n            <span class="badge warning-badge">\n            <span aria-hidden="true">${e} &#x3f;</span>\n            <span class="visually-hidden">${t._("WARNING")}</span> ${m+i}</span>\n            <strong class="outline-list-item yellow-text">${a}</strong>\n          </a>\n        </li>`,r.push(g));const f=document.createElement("sa11y-heading-label"),b=document.createElement("sa11y-heading-anchor");if(f.hidden=!0,null!==p){o.insertAdjacentElement("beforeend",f);const e=p.previousElementSibling;b.setAttribute("id",`sa11y-h${l}`),e?(e.insertAdjacentElement("beforebegin",b),e.setAttribute("data-sa11y-parent",`h${l}`)):(p.parentNode.insertAdjacentElement("beforebegin",b),p.parentNode.setAttribute("data-sa11y-parent",`h${l}`))}else o.insertAdjacentElement("beforeend",f),f.insertAdjacentElement("beforebegin",b),b.setAttribute("id",`sa11y-h${l}`);const y=document.createElement("span");y.classList.add("heading-label"),y.innerHTML=`H${i}`,f.shadowRoot.appendChild(y),"Opened"===v.getItem("sa11y-outline")&&(f.hidden=!1)}})),n.Panel.outlineList.innerHTML=0===i.length?`${l||""} <li>${t._("PANEL_NO_HEADINGS")}</li>`:r.join(" "),setTimeout((()=>{const e=document.querySelector("sa11y-control-panel").shadowRoot,i=Array.from(e.querySelectorAll("#outline-list a"));i.forEach(((i,s)=>{const a=e.getElementById(`sa11y-link-${s}`),r=o(`#sa11y-h${s}, [data-sa11y-parent="h${s}"]`,"document",n.Exclusions.Container),l=e=>{("keyup"===e.type&&"Enter"===e.code||"click"===e.type)&&(r.forEach((e=>{(e=>{_(e.parentElement),e.scrollIntoView({behavior:`${n.Global.scrollBehaviour}`,block:"center"})})(e)})),a.classList.contains("hidden-h")?T(`${t._("HEADING_NOT_VISIBLE")}`):n.Panel.alert.classList.contains("active")&&L()),e.preventDefault()};a?.addEventListener("click",l,!1),a?.addEventListener("keyup",l,!1)}));let s=0;const a=e=>{if(!["ArrowUp","ArrowDown","Space"].includes(e.code))return;if("Space"===e.code)return void i[s].click();let t;i[s].setAttribute("tabindex",-1),"ArrowDown"===e.code?(t=s+1,s===i.length-1&&(t=0)):"ArrowUp"===e.code&&(t=s-1,0===s&&(t=i.length-1)),i[t].setAttribute("tabindex",0),i[t].focus(),s=t,e.preventDefault()};n.Panel.outlineList.addEventListener("focus",(()=>{i.length>0&&(n.Panel.outlineList.setAttribute("tabindex",-1),i[s].setAttribute("tabindex",0),i[s].focus()),n.Panel.outlineList.addEventListener("keydown",a)})),n.Panel.outlineList.addEventListener("blur",(()=>{n.Panel.outlineList.removeEventListener("keydown",a)}))}),0),document.removeEventListener("sa11y-build-heading-outline",a),e};"Opened"===v.getItem("sa11y-outline")&&a(),document.addEventListener("sa11y-build-heading-outline",a)}const te=e=>{const{src:o}=e.element,i=n.Global.ignoreEditImageURL.some((e=>o.includes(e))),s=n.Global.ignoreEditImageClass.some((t=>e.element.classList.contains(t)));if(i||s)return"";const a=n.Global.relativePathImageSRC||window.location.host,r=o.split(a)[1]||"",l=n.Global.relativePathImageID;let c;l.length&&e.element.classList.length&&e.element.classList.forEach((e=>{if(e.startsWith(l)){const[t]=e.match(/\d+/)||[];c=t}}));const d=a&&l.length?n.Global.editImageURLofCMS+c:n.Global.editImageURLofCMS+r;return(l.length&&void 0!==c||!l)&&((p=o).includes(window.location.host)||p.startsWith(a))?`<div class="edit-block"><a href="${encodeURI(d)}" target="_blank" rel="noopener noreferrer" class="edit">${t._("EDIT")}</a></div>`:"";var p};var ne="top",oe="bottom",ie="right",se="left",ae="auto",re=[ne,oe,ie,se],le="start",ce="end",de="viewport",pe="popper",ue=re.reduce((function(e,t){return e.concat([t+"-"+le,t+"-"+ce])}),[]),he=[].concat(re,[ae]).reduce((function(e,t){return e.concat([t,t+"-"+le,t+"-"+ce])}),[]),me=["beforeRead","read","afterRead","beforeMain","main","afterMain","beforeWrite","write","afterWrite"];function ge(e){return e?(e.nodeName||"").toLowerCase():null}function fe(e){if(null==e)return window;if("[object Window]"!==e.toString()){var t=e.ownerDocument;return t&&t.defaultView||window}return e}function be(e){return e instanceof fe(e).Element||e instanceof Element}function ye(e){return e instanceof fe(e).HTMLElement||e instanceof HTMLElement}function Ee(e){return"undefined"!=typeof ShadowRoot&&(e instanceof fe(e).ShadowRoot||e instanceof ShadowRoot)}var Ae={name:"applyStyles",enabled:!0,phase:"write",fn:function(e){var t=e.state;Object.keys(t.elements).forEach((function(e){var n=t.styles[e]||{},o=t.attributes[e]||{},i=t.elements[e];ye(i)&&ge(i)&&(Object.assign(i.style,n),Object.keys(o).forEach((function(e){var t=o[e];!1===t?i.removeAttribute(e):i.setAttribute(e,!0===t?"":t)})))}))},effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};return Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow),function(){Object.keys(t.elements).forEach((function(e){var o=t.elements[e],i=t.attributes[e]||{},s=Object.keys(t.styles.hasOwnProperty(e)?t.styles[e]:n[e]).reduce((function(e,t){return e[t]="",e}),{});ye(o)&&ge(o)&&(Object.assign(o.style,s),Object.keys(i).forEach((function(e){o.removeAttribute(e)})))}))}},requires:["computeStyles"]};function ve(e){return e.split("-")[0]}var _e=Math.max,Ie=Math.min,Le=Math.round;function Te(){var e=navigator.userAgentData;return null!=e&&e.brands&&Array.isArray(e.brands)?e.brands.map((function(e){return e.brand+"/"+e.version})).join(" "):navigator.userAgent}function xe(){return!/^((?!chrome|android).)*safari/i.test(Te())}function Ne(e,t,n){void 0===t&&(t=!1),void 0===n&&(n=!1);var o=e.getBoundingClientRect(),i=1,s=1;t&&ye(e)&&(i=e.offsetWidth>0&&Le(o.width)/e.offsetWidth||1,s=e.offsetHeight>0&&Le(o.height)/e.offsetHeight||1);var a=(be(e)?fe(e):window).visualViewport,r=!xe()&&n,l=(o.left+(r&&a?a.offsetLeft:0))/i,c=(o.top+(r&&a?a.offsetTop:0))/s,d=o.width/i,p=o.height/s;return{width:d,height:p,top:c,right:l+d,bottom:c+p,left:l,x:l,y:c}}function ke(e){var t=Ne(e),n=e.offsetWidth,o=e.offsetHeight;return Math.abs(t.width-n)<=1&&(n=t.width),Math.abs(t.height-o)<=1&&(o=t.height),{x:e.offsetLeft,y:e.offsetTop,width:n,height:o}}function Se(e,t){var n=t.getRootNode&&t.getRootNode();if(e.contains(t))return!0;if(n&&Ee(n)){var o=t;do{if(o&&e.isSameNode(o))return!0;o=o.parentNode||o.host}while(o)}return!1}function we(e){return fe(e).getComputedStyle(e)}function Ce(e){return["table","td","th"].indexOf(ge(e))>=0}function Oe(e){return((be(e)?e.ownerDocument:e.document)||window.document).documentElement}function Pe(e){return"html"===ge(e)?e:e.assignedSlot||e.parentNode||(Ee(e)?e.host:null)||Oe(e)}function Re(e){return ye(e)&&"fixed"!==we(e).position?e.offsetParent:null}function De(e){for(var t=fe(e),n=Re(e);n&&Ce(n)&&"static"===we(n).position;)n=Re(n);return n&&("html"===ge(n)||"body"===ge(n)&&"static"===we(n).position)?t:n||function(e){var t=/firefox/i.test(Te());if(/Trident/i.test(Te())&&ye(e)&&"fixed"===we(e).position)return null;var n=Pe(e);for(Ee(n)&&(n=n.host);ye(n)&&["html","body"].indexOf(ge(n))<0;){var o=we(n);if("none"!==o.transform||"none"!==o.perspective||"paint"===o.contain||-1!==["transform","perspective"].indexOf(o.willChange)||t&&"filter"===o.willChange||t&&o.filter&&"none"!==o.filter)return n;n=n.parentNode}return null}(e)||t}function Me(e){return["top","bottom"].indexOf(e)>=0?"x":"y"}function Be(e,t,n){return _e(e,Ie(t,n))}function $e(e){return Object.assign({},{top:0,right:0,bottom:0,left:0},e)}function Ge(e,t){return t.reduce((function(t,n){return t[n]=e,t}),{})}var Ue={name:"arrow",enabled:!0,phase:"main",fn:function(e){var t,n=e.state,o=e.name,i=e.options,s=n.elements.arrow,a=n.modifiersData.popperOffsets,r=ve(n.placement),l=Me(r),c=[se,ie].indexOf(r)>=0?"height":"width";if(s&&a){var d=function(e,t){return $e("number"!=typeof(e="function"==typeof e?e(Object.assign({},t.rects,{placement:t.placement})):e)?e:Ge(e,re))}(i.padding,n),p=ke(s),u="y"===l?ne:se,h="y"===l?oe:ie,m=n.rects.reference[c]+n.rects.reference[l]-a[l]-n.rects.popper[c],g=a[l]-n.rects.reference[l],f=De(s),b=f?"y"===l?f.clientHeight||0:f.clientWidth||0:0,y=m/2-g/2,E=d[u],A=b-p[c]-d[h],v=b/2-p[c]/2+y,_=Be(E,v,A),I=l;n.modifiersData[o]=((t={})[I]=_,t.centerOffset=_-v,t)}},effect:function(e){var t=e.state,n=e.options.element,o=void 0===n?"[data-popper-arrow]":n;null!=o&&("string"!=typeof o||(o=t.elements.popper.querySelector(o)))&&Se(t.elements.popper,o)&&(t.elements.arrow=o)},requires:["popperOffsets"],requiresIfExists:["preventOverflow"]};function He(e){return e.split("-")[1]}var Fe={top:"auto",right:"auto",bottom:"auto",left:"auto"};function Ke(e){var t,n=e.popper,o=e.popperRect,i=e.placement,s=e.variation,a=e.offsets,r=e.position,l=e.gpuAcceleration,c=e.adaptive,d=e.roundOffsets,p=e.isFixed,u=a.x,h=void 0===u?0:u,m=a.y,g=void 0===m?0:m,f="function"==typeof d?d({x:h,y:g}):{x:h,y:g};h=f.x,g=f.y;var b=a.hasOwnProperty("x"),y=a.hasOwnProperty("y"),E=se,A=ne,v=window;if(c){var _=De(n),I="clientHeight",L="clientWidth";if(_===fe(n)&&"static"!==we(_=Oe(n)).position&&"absolute"===r&&(I="scrollHeight",L="scrollWidth"),i===ne||(i===se||i===ie)&&s===ce)A=oe,g-=(p&&_===v&&v.visualViewport?v.visualViewport.height:_[I])-o.height,g*=l?1:-1;if(i===se||(i===ne||i===oe)&&s===ce)E=ie,h-=(p&&_===v&&v.visualViewport?v.visualViewport.width:_[L])-o.width,h*=l?1:-1}var T,x=Object.assign({position:r},c&&Fe),N=!0===d?function(e,t){var n=e.x,o=e.y,i=t.devicePixelRatio||1;return{x:Le(n*i)/i||0,y:Le(o*i)/i||0}}({x:h,y:g},fe(n)):{x:h,y:g};return h=N.x,g=N.y,l?Object.assign({},x,((T={})[A]=y?"0":"",T[E]=b?"0":"",T.transform=(v.devicePixelRatio||1)<=1?"translate("+h+"px, "+g+"px)":"translate3d("+h+"px, "+g+"px, 0)",T)):Object.assign({},x,((t={})[A]=y?g+"px":"",t[E]=b?h+"px":"",t.transform="",t))}var We={passive:!0};var Ye={left:"right",right:"left",bottom:"top",top:"bottom"};function ze(e){return e.replace(/left|right|bottom|top/g,(function(e){return Ye[e]}))}var Qe={start:"end",end:"start"};function Ve(e){return e.replace(/start|end/g,(function(e){return Qe[e]}))}function je(e){var t=fe(e);return{scrollLeft:t.pageXOffset,scrollTop:t.pageYOffset}}function qe(e){return Ne(Oe(e)).left+je(e).scrollLeft}function Xe(e){var t=we(e),n=t.overflow,o=t.overflowX,i=t.overflowY;return/auto|scroll|overlay|hidden/.test(n+i+o)}function Ze(e){return["html","body","#document"].indexOf(ge(e))>=0?e.ownerDocument.body:ye(e)&&Xe(e)?e:Ze(Pe(e))}function Je(e,t){var n;void 0===t&&(t=[]);var o=Ze(e),i=o===(null==(n=e.ownerDocument)?void 0:n.body),s=fe(o),a=i?[s].concat(s.visualViewport||[],Xe(o)?o:[]):o,r=t.concat(a);return i?r:r.concat(Je(Pe(a)))}function et(e){return Object.assign({},e,{left:e.x,top:e.y,right:e.x+e.width,bottom:e.y+e.height})}function tt(e,t,n){return t===de?et(function(e,t){var n=fe(e),o=Oe(e),i=n.visualViewport,s=o.clientWidth,a=o.clientHeight,r=0,l=0;if(i){s=i.width,a=i.height;var c=xe();(c||!c&&"fixed"===t)&&(r=i.offsetLeft,l=i.offsetTop)}return{width:s,height:a,x:r+qe(e),y:l}}(e,n)):be(t)?function(e,t){var n=Ne(e,!1,"fixed"===t);return n.top=n.top+e.clientTop,n.left=n.left+e.clientLeft,n.bottom=n.top+e.clientHeight,n.right=n.left+e.clientWidth,n.width=e.clientWidth,n.height=e.clientHeight,n.x=n.left,n.y=n.top,n}(t,n):et(function(e){var t,n=Oe(e),o=je(e),i=null==(t=e.ownerDocument)?void 0:t.body,s=_e(n.scrollWidth,n.clientWidth,i?i.scrollWidth:0,i?i.clientWidth:0),a=_e(n.scrollHeight,n.clientHeight,i?i.scrollHeight:0,i?i.clientHeight:0),r=-o.scrollLeft+qe(e),l=-o.scrollTop;return"rtl"===we(i||n).direction&&(r+=_e(n.clientWidth,i?i.clientWidth:0)-s),{width:s,height:a,x:r,y:l}}(Oe(e)))}function nt(e,t,n,o){var i="clippingParents"===t?function(e){var t=Je(Pe(e)),n=["absolute","fixed"].indexOf(we(e).position)>=0&&ye(e)?De(e):e;return be(n)?t.filter((function(e){return be(e)&&Se(e,n)&&"body"!==ge(e)})):[]}(e):[].concat(t),s=[].concat(i,[n]),a=s[0],r=s.reduce((function(t,n){var i=tt(e,n,o);return t.top=_e(i.top,t.top),t.right=Ie(i.right,t.right),t.bottom=Ie(i.bottom,t.bottom),t.left=_e(i.left,t.left),t}),tt(e,a,o));return r.width=r.right-r.left,r.height=r.bottom-r.top,r.x=r.left,r.y=r.top,r}function ot(e){var t,n=e.reference,o=e.element,i=e.placement,s=i?ve(i):null,a=i?He(i):null,r=n.x+n.width/2-o.width/2,l=n.y+n.height/2-o.height/2;switch(s){case ne:t={x:r,y:n.y-o.height};break;case oe:t={x:r,y:n.y+n.height};break;case ie:t={x:n.x+n.width,y:l};break;case se:t={x:n.x-o.width,y:l};break;default:t={x:n.x,y:n.y}}var c=s?Me(s):null;if(null!=c){var d="y"===c?"height":"width";switch(a){case le:t[c]=t[c]-(n[d]/2-o[d]/2);break;case ce:t[c]=t[c]+(n[d]/2-o[d]/2)}}return t}function it(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=void 0===o?e.placement:o,s=n.strategy,a=void 0===s?e.strategy:s,r=n.boundary,l=void 0===r?"clippingParents":r,c=n.rootBoundary,d=void 0===c?de:c,p=n.elementContext,u=void 0===p?pe:p,h=n.altBoundary,m=void 0!==h&&h,g=n.padding,f=void 0===g?0:g,b=$e("number"!=typeof f?f:Ge(f,re)),y=u===pe?"reference":pe,E=e.rects.popper,A=e.elements[m?y:u],v=nt(be(A)?A:A.contextElement||Oe(e.elements.popper),l,d,a),_=Ne(e.elements.reference),I=ot({reference:_,element:E,strategy:"absolute",placement:i}),L=et(Object.assign({},E,I)),T=u===pe?L:_,x={top:v.top-T.top+b.top,bottom:T.bottom-v.bottom+b.bottom,left:v.left-T.left+b.left,right:T.right-v.right+b.right},N=e.modifiersData.offset;if(u===pe&&N){var k=N[i];Object.keys(x).forEach((function(e){var t=[ie,oe].indexOf(e)>=0?1:-1,n=[ne,oe].indexOf(e)>=0?"y":"x";x[e]+=k[n]*t}))}return x}function st(e,t){void 0===t&&(t={});var n=t,o=n.placement,i=n.boundary,s=n.rootBoundary,a=n.padding,r=n.flipVariations,l=n.allowedAutoPlacements,c=void 0===l?he:l,d=He(o),p=d?r?ue:ue.filter((function(e){return He(e)===d})):re,u=p.filter((function(e){return c.indexOf(e)>=0}));0===u.length&&(u=p);var h=u.reduce((function(t,n){return t[n]=it(e,{placement:n,boundary:i,rootBoundary:s,padding:a})[ve(n)],t}),{});return Object.keys(h).sort((function(e,t){return h[e]-h[t]}))}var at={name:"flip",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name;if(!t.modifiersData[o]._skip){for(var i=n.mainAxis,s=void 0===i||i,a=n.altAxis,r=void 0===a||a,l=n.fallbackPlacements,c=n.padding,d=n.boundary,p=n.rootBoundary,u=n.altBoundary,h=n.flipVariations,m=void 0===h||h,g=n.allowedAutoPlacements,f=t.options.placement,b=ve(f),y=l||(b===f||!m?[ze(f)]:function(e){if(ve(e)===ae)return[];var t=ze(e);return[Ve(e),t,Ve(t)]}(f)),E=[f].concat(y).reduce((function(e,n){return e.concat(ve(n)===ae?st(t,{placement:n,boundary:d,rootBoundary:p,padding:c,flipVariations:m,allowedAutoPlacements:g}):n)}),[]),A=t.rects.reference,v=t.rects.popper,_=new Map,I=!0,L=E[0],T=0;T<E.length;T++){var x=E[T],N=ve(x),k=He(x)===le,S=[ne,oe].indexOf(N)>=0,w=S?"width":"height",C=it(t,{placement:x,boundary:d,rootBoundary:p,altBoundary:u,padding:c}),O=S?k?ie:se:k?oe:ne;A[w]>v[w]&&(O=ze(O));var P=ze(O),R=[];if(s&&R.push(C[N]<=0),r&&R.push(C[O]<=0,C[P]<=0),R.every((function(e){return e}))){L=x,I=!1;break}_.set(x,R)}if(I)for(var D=function(e){var t=E.find((function(t){var n=_.get(t);if(n)return n.slice(0,e).every((function(e){return e}))}));if(t)return L=t,"break"},M=m?3:1;M>0;M--){if("break"===D(M))break}t.placement!==L&&(t.modifiersData[o]._skip=!0,t.placement=L,t.reset=!0)}},requiresIfExists:["offset"],data:{_skip:!1}};function rt(e,t,n){return void 0===n&&(n={x:0,y:0}),{top:e.top-t.height-n.y,right:e.right-t.width+n.x,bottom:e.bottom-t.height+n.y,left:e.left-t.width-n.x}}function lt(e){return[ne,ie,oe,se].some((function(t){return e[t]>=0}))}var ct={name:"offset",enabled:!0,phase:"main",requires:["popperOffsets"],fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.offset,s=void 0===i?[0,0]:i,a=he.reduce((function(e,n){return e[n]=function(e,t,n){var o=ve(e),i=[se,ne].indexOf(o)>=0?-1:1,s="function"==typeof n?n(Object.assign({},t,{placement:e})):n,a=s[0],r=s[1];return a=a||0,r=(r||0)*i,[se,ie].indexOf(o)>=0?{x:r,y:a}:{x:a,y:r}}(n,t.rects,s),e}),{}),r=a[t.placement],l=r.x,c=r.y;null!=t.modifiersData.popperOffsets&&(t.modifiersData.popperOffsets.x+=l,t.modifiersData.popperOffsets.y+=c),t.modifiersData[o]=a}};var dt={name:"preventOverflow",enabled:!0,phase:"main",fn:function(e){var t=e.state,n=e.options,o=e.name,i=n.mainAxis,s=void 0===i||i,a=n.altAxis,r=void 0!==a&&a,l=n.boundary,c=n.rootBoundary,d=n.altBoundary,p=n.padding,u=n.tether,h=void 0===u||u,m=n.tetherOffset,g=void 0===m?0:m,f=it(t,{boundary:l,rootBoundary:c,padding:p,altBoundary:d}),b=ve(t.placement),y=He(t.placement),E=!y,A=Me(b),v="x"===A?"y":"x",_=t.modifiersData.popperOffsets,I=t.rects.reference,L=t.rects.popper,T="function"==typeof g?g(Object.assign({},t.rects,{placement:t.placement})):g,x="number"==typeof T?{mainAxis:T,altAxis:T}:Object.assign({mainAxis:0,altAxis:0},T),N=t.modifiersData.offset?t.modifiersData.offset[t.placement]:null,k={x:0,y:0};if(_){if(s){var S,w="y"===A?ne:se,C="y"===A?oe:ie,O="y"===A?"height":"width",P=_[A],R=P+f[w],D=P-f[C],M=h?-L[O]/2:0,B=y===le?I[O]:L[O],$=y===le?-L[O]:-I[O],G=t.elements.arrow,U=h&&G?ke(G):{width:0,height:0},H=t.modifiersData["arrow#persistent"]?t.modifiersData["arrow#persistent"].padding:{top:0,right:0,bottom:0,left:0},F=H[w],K=H[C],W=Be(0,I[O],U[O]),Y=E?I[O]/2-M-W-F-x.mainAxis:B-W-F-x.mainAxis,z=E?-I[O]/2+M+W+K+x.mainAxis:$+W+K+x.mainAxis,Q=t.elements.arrow&&De(t.elements.arrow),V=Q?"y"===A?Q.clientTop||0:Q.clientLeft||0:0,j=null!=(S=null==N?void 0:N[A])?S:0,q=P+z-j,X=Be(h?Ie(R,P+Y-j-V):R,P,h?_e(D,q):D);_[A]=X,k[A]=X-P}if(r){var Z,J="x"===A?ne:se,ee="x"===A?oe:ie,te=_[v],ae="y"===v?"height":"width",re=te+f[J],ce=te-f[ee],de=-1!==[ne,se].indexOf(b),pe=null!=(Z=null==N?void 0:N[v])?Z:0,ue=de?re:te-I[ae]-L[ae]-pe+x.altAxis,he=de?te+I[ae]+L[ae]-pe-x.altAxis:ce,me=h&&de?function(e,t,n){var o=Be(e,t,n);return o>n?n:o}(ue,te,he):Be(h?ue:re,te,h?he:ce);_[v]=me,k[v]=me-te}t.modifiersData[o]=k}},requiresIfExists:["offset"]};function pt(e,t,n){void 0===n&&(n=!1);var o,i,s=ye(t),a=ye(t)&&function(e){var t=e.getBoundingClientRect(),n=Le(t.width)/e.offsetWidth||1,o=Le(t.height)/e.offsetHeight||1;return 1!==n||1!==o}(t),r=Oe(t),l=Ne(e,a,n),c={scrollLeft:0,scrollTop:0},d={x:0,y:0};return(s||!s&&!n)&&(("body"!==ge(t)||Xe(r))&&(c=(o=t)!==fe(o)&&ye(o)?{scrollLeft:(i=o).scrollLeft,scrollTop:i.scrollTop}:je(o)),ye(t)?((d=Ne(t,!0)).x+=t.clientLeft,d.y+=t.clientTop):r&&(d.x=qe(r))),{x:l.left+c.scrollLeft-d.x,y:l.top+c.scrollTop-d.y,width:l.width,height:l.height}}function ut(e){var t=new Map,n=new Set,o=[];function i(e){n.add(e.name),[].concat(e.requires||[],e.requiresIfExists||[]).forEach((function(e){if(!n.has(e)){var o=t.get(e);o&&i(o)}})),o.push(e)}return e.forEach((function(e){t.set(e.name,e)})),e.forEach((function(e){n.has(e.name)||i(e)})),o}var ht={placement:"bottom",modifiers:[],strategy:"absolute"};function mt(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return!t.some((function(e){return!(e&&"function"==typeof e.getBoundingClientRect)}))}function gt(e){void 0===e&&(e={});var t=e,n=t.defaultModifiers,o=void 0===n?[]:n,i=t.defaultOptions,s=void 0===i?ht:i;return function(e,t,n){void 0===n&&(n=s);var i,a,r={placement:"bottom",orderedModifiers:[],options:Object.assign({},ht,s),modifiersData:{},elements:{reference:e,popper:t},attributes:{},styles:{}},l=[],c=!1,d={state:r,setOptions:function(n){var i="function"==typeof n?n(r.options):n;p(),r.options=Object.assign({},s,r.options,i),r.scrollParents={reference:be(e)?Je(e):e.contextElement?Je(e.contextElement):[],popper:Je(t)};var a,c,u=function(e){var t=ut(e);return me.reduce((function(e,n){return e.concat(t.filter((function(e){return e.phase===n})))}),[])}((a=[].concat(o,r.options.modifiers),c=a.reduce((function(e,t){var n=e[t.name];return e[t.name]=n?Object.assign({},n,t,{options:Object.assign({},n.options,t.options),data:Object.assign({},n.data,t.data)}):t,e}),{}),Object.keys(c).map((function(e){return c[e]}))));return r.orderedModifiers=u.filter((function(e){return e.enabled})),r.orderedModifiers.forEach((function(e){var t=e.name,n=e.options,o=void 0===n?{}:n,i=e.effect;if("function"==typeof i){var s=i({state:r,name:t,instance:d,options:o}),a=function(){};l.push(s||a)}})),d.update()},forceUpdate:function(){if(!c){var e=r.elements,t=e.reference,n=e.popper;if(mt(t,n)){r.rects={reference:pt(t,De(n),"fixed"===r.options.strategy),popper:ke(n)},r.reset=!1,r.placement=r.options.placement,r.orderedModifiers.forEach((function(e){return r.modifiersData[e.name]=Object.assign({},e.data)}));for(var o=0;o<r.orderedModifiers.length;o++)if(!0!==r.reset){var i=r.orderedModifiers[o],s=i.fn,a=i.options,l=void 0===a?{}:a,p=i.name;"function"==typeof s&&(r=s({state:r,options:l,name:p,instance:d})||r)}else r.reset=!1,o=-1}}},update:(i=function(){return new Promise((function(e){d.forceUpdate(),e(r)}))},function(){return a||(a=new Promise((function(e){Promise.resolve().then((function(){a=void 0,e(i())}))}))),a}),destroy:function(){p(),c=!0}};if(!mt(e,t))return d;function p(){l.forEach((function(e){return e()})),l=[]}return d.setOptions(n).then((function(e){!c&&n.onFirstUpdate&&n.onFirstUpdate(e)})),d}}var ft=gt({defaultModifiers:[{name:"eventListeners",enabled:!0,phase:"write",fn:function(){},effect:function(e){var t=e.state,n=e.instance,o=e.options,i=o.scroll,s=void 0===i||i,a=o.resize,r=void 0===a||a,l=fe(t.elements.popper),c=[].concat(t.scrollParents.reference,t.scrollParents.popper);return s&&c.forEach((function(e){e.addEventListener("scroll",n.update,We)})),r&&l.addEventListener("resize",n.update,We),function(){s&&c.forEach((function(e){e.removeEventListener("scroll",n.update,We)})),r&&l.removeEventListener("resize",n.update,We)}},data:{}},{name:"popperOffsets",enabled:!0,phase:"read",fn:function(e){var t=e.state,n=e.name;t.modifiersData[n]=ot({reference:t.rects.reference,element:t.rects.popper,strategy:"absolute",placement:t.placement})},data:{}},{name:"computeStyles",enabled:!0,phase:"beforeWrite",fn:function(e){var t=e.state,n=e.options,o=n.gpuAcceleration,i=void 0===o||o,s=n.adaptive,a=void 0===s||s,r=n.roundOffsets,l=void 0===r||r,c={placement:ve(t.placement),variation:He(t.placement),popper:t.elements.popper,popperRect:t.rects.popper,gpuAcceleration:i,isFixed:"fixed"===t.options.strategy};null!=t.modifiersData.popperOffsets&&(t.styles.popper=Object.assign({},t.styles.popper,Ke(Object.assign({},c,{offsets:t.modifiersData.popperOffsets,position:t.options.strategy,adaptive:a,roundOffsets:l})))),null!=t.modifiersData.arrow&&(t.styles.arrow=Object.assign({},t.styles.arrow,Ke(Object.assign({},c,{offsets:t.modifiersData.arrow,position:"absolute",adaptive:!1,roundOffsets:l})))),t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-placement":t.placement})},data:{}},Ae,ct,at,dt,Ue,{name:"hide",enabled:!0,phase:"main",requiresIfExists:["preventOverflow"],fn:function(e){var t=e.state,n=e.name,o=t.rects.reference,i=t.rects.popper,s=t.modifiersData.preventOverflow,a=it(t,{elementContext:"reference"}),r=it(t,{altBoundary:!0}),l=rt(a,o),c=rt(r,i,s),d=lt(l),p=lt(c);t.modifiersData[n]={referenceClippingOffsets:l,popperEscapeOffsets:c,isReferenceHidden:d,hasPopperEscaped:p},t.attributes.popper=Object.assign({},t.attributes.popper,{"data-popper-reference-hidden":d,"data-popper-escaped":p})}}]}),bt="tippy-content",yt="tippy-arrow",Et="tippy-svg-arrow",At={passive:!0,capture:!0},vt=function(){return document.body};function _t(e,t,n){if(Array.isArray(e)){var o=e[t];return null==o?Array.isArray(n)?n[t]:n:o}return e}function It(e,t){var n={}.toString.call(e);return 0===n.indexOf("[object")&&n.indexOf(t+"]")>-1}function Lt(e,t){return"function"==typeof e?e.apply(void 0,t):e}function Tt(e,t){return 0===t?e:function(o){clearTimeout(n),n=setTimeout((function(){e(o)}),t)};var n}function xt(e){return[].concat(e)}function Nt(e,t){-1===e.indexOf(t)&&e.push(t)}function kt(e){return[].slice.call(e)}function St(e){return Object.keys(e).reduce((function(t,n){return void 0!==e[n]&&(t[n]=e[n]),t}),{})}function wt(){return document.createElement("div")}function Ct(e){return["Element","Fragment"].some((function(t){return It(e,t)}))}function Ot(e){return Ct(e)?[e]:function(e){return It(e,"NodeList")}(e)?kt(e):Array.isArray(e)?e:kt(document.querySelectorAll(e))}function Pt(e,t){e.forEach((function(e){e&&(e.style.transitionDuration=t+"ms")}))}function Rt(e,t){e.forEach((function(e){e&&e.setAttribute("data-state",t)}))}function Dt(e,t,n){var o=t+"EventListener";["transitionend","webkitTransitionEnd"].forEach((function(t){e[o](t,n)}))}function Mt(e,t){for(var n=t;n;){var o;if(e.contains(n))return!0;n=null==n.getRootNode||null==(o=n.getRootNode())?void 0:o.host}return!1}var Bt={isTouch:!1},$t=0;function Gt(){Bt.isTouch||(Bt.isTouch=!0,window.performance&&document.addEventListener("mousemove",Ut))}function Ut(){var e=performance.now();e-$t<20&&(Bt.isTouch=!1,document.removeEventListener("mousemove",Ut)),$t=e}function Ht(){var e,t=document.activeElement;if((e=t)&&e._tippy&&e._tippy.reference===e){var n=t._tippy;t.blur&&!n.state.isVisible&&t.blur()}}var Ft=!!("undefined"!=typeof window&&"undefined"!=typeof document)&&!!window.msCrypto,Kt=Object.assign({appendTo:vt,aria:{content:"auto",expanded:"auto"},delay:0,duration:[300,250],getReferenceClientRect:null,hideOnClick:!0,ignoreAttributes:!1,interactive:!1,interactiveBorder:2,interactiveDebounce:0,moveTransition:"",offset:[0,10],onAfterUpdate:function(){},onBeforeUpdate:function(){},onCreate:function(){},onDestroy:function(){},onHidden:function(){},onHide:function(){},onMount:function(){},onShow:function(){},onShown:function(){},onTrigger:function(){},onUntrigger:function(){},onClickOutside:function(){},placement:"top",plugins:[],popperOptions:{},render:null,showOnCreate:!1,touch:!0,trigger:"mouseenter focus",triggerTarget:null},{animateFill:!1,followCursor:!1,inlinePositioning:!1,sticky:!1},{allowHTML:!1,animation:"fade",arrow:!0,content:"",inertia:!1,maxWidth:350,role:"tooltip",theme:"",zIndex:9999}),Wt=Object.keys(Kt);function Yt(e){var t=(e.plugins||[]).reduce((function(t,n){var o,i=n.name,s=n.defaultValue;i&&(t[i]=void 0!==e[i]?e[i]:null!=(o=Kt[i])?o:s);return t}),{});return Object.assign({},e,t)}function zt(e,t){var n=Object.assign({},t,{content:Lt(t.content,[e])},t.ignoreAttributes?{}:function(e,t){return(t?Object.keys(Yt(Object.assign({},Kt,{plugins:t}))):Wt).reduce((function(t,n){var o=(e.getAttribute("data-tippy-"+n)||"").trim();if(!o)return t;if("content"===n)t[n]=o;else try{t[n]=JSON.parse(o)}catch(e){t[n]=o}return t}),{})}(e,t.plugins));return n.aria=Object.assign({},Kt.aria,n.aria),n.aria={expanded:"auto"===n.aria.expanded?t.interactive:n.aria.expanded,content:"auto"===n.aria.content?t.interactive?null:"describedby":n.aria.content},n}function Qt(e,t){e.innerHTML=t}function Vt(e){var t=wt();return!0===e?t.className=yt:(t.className=Et,Ct(e)?t.appendChild(e):Qt(t,e)),t}function jt(e,t){Ct(t.content)?(Qt(e,""),e.appendChild(t.content)):"function"!=typeof t.content&&(t.allowHTML?Qt(e,t.content):e.textContent=t.content)}function qt(e){var t=e.firstElementChild,n=kt(t.children);return{box:t,content:n.find((function(e){return e.classList.contains(bt)})),arrow:n.find((function(e){return e.classList.contains(yt)||e.classList.contains(Et)})),backdrop:n.find((function(e){return e.classList.contains("tippy-backdrop")}))}}function Xt(e){var t=wt(),n=wt();n.className="tippy-box",n.setAttribute("data-state","hidden"),n.setAttribute("tabindex","-1");var o=wt();function i(n,o){var i=qt(t),s=i.box,a=i.content,r=i.arrow;o.theme?s.setAttribute("data-theme",o.theme):s.removeAttribute("data-theme"),"string"==typeof o.animation?s.setAttribute("data-animation",o.animation):s.removeAttribute("data-animation"),o.inertia?s.setAttribute("data-inertia",""):s.removeAttribute("data-inertia"),s.style.maxWidth="number"==typeof o.maxWidth?o.maxWidth+"px":o.maxWidth,o.role?s.setAttribute("role",o.role):s.removeAttribute("role"),n.content===o.content&&n.allowHTML===o.allowHTML||jt(a,e.props),o.arrow?r?n.arrow!==o.arrow&&(s.removeChild(r),s.appendChild(Vt(o.arrow))):s.appendChild(Vt(o.arrow)):r&&s.removeChild(r)}return o.className=bt,o.setAttribute("data-state","hidden"),jt(o,e.props),t.appendChild(n),n.appendChild(o),i(e.props,e.props),{popper:t,onUpdate:i}}Xt.$$tippy=!0;var Zt=1,Jt=[],en=[];function tn(e,t){var n,o,i,s,a,r,l,c,d=zt(e,Object.assign({},Kt,Yt(St(t)))),p=!1,u=!1,h=!1,m=!1,g=[],f=Tt(Q,d.interactiveDebounce),b=Zt++,y=(c=d.plugins).filter((function(e,t){return c.indexOf(e)===t})),E={id:b,reference:e,popper:wt(),popperInstance:null,props:d,state:{isEnabled:!0,isVisible:!1,isDestroyed:!1,isMounted:!1,isShown:!1},plugins:y,clearDelayTimeouts:function(){clearTimeout(n),clearTimeout(o),cancelAnimationFrame(i)},setProps:function(t){if(E.state.isDestroyed)return;P("onBeforeUpdate",[E,t]),Y();var n=E.props,o=zt(e,Object.assign({},n,St(t),{ignoreAttributes:!0}));E.props=o,W(),n.interactiveDebounce!==o.interactiveDebounce&&(M(),f=Tt(Q,o.interactiveDebounce));n.triggerTarget&&!o.triggerTarget?xt(n.triggerTarget).forEach((function(e){e.removeAttribute("aria-expanded")})):o.triggerTarget&&e.removeAttribute("aria-expanded");D(),O(),_&&_(n,o);E.popperInstance&&(X(),J().forEach((function(e){requestAnimationFrame(e._tippy.popperInstance.forceUpdate)})));P("onAfterUpdate",[E,t])},setContent:function(e){E.setProps({content:e})},show:function(){var e=E.state.isVisible,t=E.state.isDestroyed,n=!E.state.isEnabled,o=Bt.isTouch&&!E.props.touch,i=_t(E.props.duration,0,Kt.duration);if(e||t||n||o)return;if(k().hasAttribute("disabled"))return;if(P("onShow",[E],!1),!1===E.props.onShow(E))return;E.state.isVisible=!0,N()&&(v.style.visibility="visible");O(),U(),E.state.isMounted||(v.style.transition="none");if(N()){var s=w();Pt([s.box,s.content],0)}r=function(){var e;if(E.state.isVisible&&!m){if(m=!0,v.offsetHeight,v.style.transition=E.props.moveTransition,N()&&E.props.animation){var t=w(),n=t.box,o=t.content;Pt([n,o],i),Rt([n,o],"visible")}R(),D(),Nt(en,E),null==(e=E.popperInstance)||e.forceUpdate(),P("onMount",[E]),E.props.animation&&N()&&function(e,t){F(e,t)}(i,(function(){E.state.isShown=!0,P("onShown",[E])}))}},function(){var e,t=E.props.appendTo,n=k();e=E.props.interactive&&t===vt||"parent"===t?n.parentNode:Lt(t,[n]);e.contains(v)||e.appendChild(v);E.state.isMounted=!0,X()}()},hide:function(){var e=!E.state.isVisible,t=E.state.isDestroyed,n=!E.state.isEnabled,o=_t(E.props.duration,1,Kt.duration);if(e||t||n)return;if(P("onHide",[E],!1),!1===E.props.onHide(E))return;E.state.isVisible=!1,E.state.isShown=!1,m=!1,p=!1,N()&&(v.style.visibility="hidden");if(M(),H(),O(!0),N()){var i=w(),s=i.box,a=i.content;E.props.animation&&(Pt([s,a],o),Rt([s,a],"hidden"))}R(),D(),E.props.animation?N()&&function(e,t){F(e,(function(){!E.state.isVisible&&v.parentNode&&v.parentNode.contains(v)&&t()}))}(o,E.unmount):E.unmount()},hideWithInteractivity:function(e){S().addEventListener("mousemove",f),Nt(Jt,f),f(e)},enable:function(){E.state.isEnabled=!0},disable:function(){E.hide(),E.state.isEnabled=!1},unmount:function(){E.state.isVisible&&E.hide();if(!E.state.isMounted)return;Z(),J().forEach((function(e){e._tippy.unmount()})),v.parentNode&&v.parentNode.removeChild(v);en=en.filter((function(e){return e!==E})),E.state.isMounted=!1,P("onHidden",[E])},destroy:function(){if(E.state.isDestroyed)return;E.clearDelayTimeouts(),E.unmount(),Y(),delete e._tippy,E.state.isDestroyed=!0,P("onDestroy",[E])}};if(!d.render)return E;var A=d.render(E),v=A.popper,_=A.onUpdate;v.setAttribute("data-tippy-root",""),v.id="tippy-"+E.id,E.popper=v,e._tippy=E,v._tippy=E;var I=y.map((function(e){return e.fn(E)})),L=e.hasAttribute("aria-expanded");return W(),D(),O(),P("onCreate",[E]),d.showOnCreate&&ee(),v.addEventListener("mouseenter",(function(){E.props.interactive&&E.state.isVisible&&E.clearDelayTimeouts()})),v.addEventListener("mouseleave",(function(){E.props.interactive&&E.props.trigger.indexOf("mouseenter")>=0&&S().addEventListener("mousemove",f)})),E;function T(){var e=E.props.touch;return Array.isArray(e)?e:[e,0]}function x(){return"hold"===T()[0]}function N(){var e;return!(null==(e=E.props.render)||!e.$$tippy)}function k(){return l||e}function S(){var e,t,n=k().parentNode;return n?null!=(t=xt(n)[0])&&null!=(e=t.ownerDocument)&&e.body?t.ownerDocument:document:document}function w(){return qt(v)}function C(e){return E.state.isMounted&&!E.state.isVisible||Bt.isTouch||s&&"focus"===s.type?0:_t(E.props.delay,e?0:1,Kt.delay)}function O(e){void 0===e&&(e=!1),v.style.pointerEvents=E.props.interactive&&!e?"":"none",v.style.zIndex=""+E.props.zIndex}function P(e,t,n){var o;(void 0===n&&(n=!0),I.forEach((function(n){n[e]&&n[e].apply(n,t)})),n)&&(o=E.props)[e].apply(o,t)}function R(){var t=E.props.aria;if(t.content){var n="aria-"+t.content,o=v.id;xt(E.props.triggerTarget||e).forEach((function(e){var t=e.getAttribute(n);if(E.state.isVisible)e.setAttribute(n,t?t+" "+o:o);else{var i=t&&t.replace(o,"").trim();i?e.setAttribute(n,i):e.removeAttribute(n)}}))}}function D(){!L&&E.props.aria.expanded&&xt(E.props.triggerTarget||e).forEach((function(e){E.props.interactive?e.setAttribute("aria-expanded",E.state.isVisible&&e===k()?"true":"false"):e.removeAttribute("aria-expanded")}))}function M(){S().removeEventListener("mousemove",f),Jt=Jt.filter((function(e){return e!==f}))}function B(t){if(!Bt.isTouch||!h&&"mousedown"!==t.type){var n=t.composedPath&&t.composedPath()[0]||t.target;if(!E.props.interactive||!Mt(v,n)){if(xt(E.props.triggerTarget||e).some((function(e){return Mt(e,n)}))){if(Bt.isTouch)return;if(E.state.isVisible&&E.props.trigger.indexOf("click")>=0)return}else P("onClickOutside",[E,t]);!0===E.props.hideOnClick&&(E.clearDelayTimeouts(),E.hide(),u=!0,setTimeout((function(){u=!1})),E.state.isMounted||H())}}}function $(){h=!0}function G(){h=!1}function U(){var e=S();e.addEventListener("mousedown",B,!0),e.addEventListener("touchend",B,At),e.addEventListener("touchstart",G,At),e.addEventListener("touchmove",$,At)}function H(){var e=S();e.removeEventListener("mousedown",B,!0),e.removeEventListener("touchend",B,At),e.removeEventListener("touchstart",G,At),e.removeEventListener("touchmove",$,At)}function F(e,t){var n=w().box;function o(e){e.target===n&&(Dt(n,"remove",o),t())}if(0===e)return t();Dt(n,"remove",a),Dt(n,"add",o),a=o}function K(t,n,o){void 0===o&&(o=!1),xt(E.props.triggerTarget||e).forEach((function(e){e.addEventListener(t,n,o),g.push({node:e,eventType:t,handler:n,options:o})}))}function W(){var e;x()&&(K("touchstart",z,{passive:!0}),K("touchend",V,{passive:!0})),(e=E.props.trigger,e.split(/\s+/).filter(Boolean)).forEach((function(e){if("manual"!==e)switch(K(e,z),e){case"mouseenter":K("mouseleave",V);break;case"focus":K(Ft?"focusout":"blur",j);break;case"focusin":K("focusout",j)}}))}function Y(){g.forEach((function(e){var t=e.node,n=e.eventType,o=e.handler,i=e.options;t.removeEventListener(n,o,i)})),g=[]}function z(e){var t,n=!1;if(E.state.isEnabled&&!q(e)&&!u){var o="focus"===(null==(t=s)?void 0:t.type);s=e,l=e.currentTarget,D(),!E.state.isVisible&&It(e,"MouseEvent")&&Jt.forEach((function(t){return t(e)})),"click"===e.type&&(E.props.trigger.indexOf("mouseenter")<0||p)&&!1!==E.props.hideOnClick&&E.state.isVisible?n=!0:ee(e),"click"===e.type&&(p=!n),n&&!o&&te(e)}}function Q(e){var t=e.target,n=k().contains(t)||v.contains(t);if("mousemove"!==e.type||!n){var o=J().concat(v).map((function(e){var t,n=null==(t=e._tippy.popperInstance)?void 0:t.state;return n?{popperRect:e.getBoundingClientRect(),popperState:n,props:d}:null})).filter(Boolean);(function(e,t){var n=t.clientX,o=t.clientY;return e.every((function(e){var t=e.popperRect,i=e.popperState,s=e.props.interactiveBorder,a=i.placement.split("-")[0],r=i.modifiersData.offset;if(!r)return!0;var l="bottom"===a?r.top.y:0,c="top"===a?r.bottom.y:0,d="right"===a?r.left.x:0,p="left"===a?r.right.x:0,u=t.top-o+l>s,h=o-t.bottom-c>s,m=t.left-n+d>s,g=n-t.right-p>s;return u||h||m||g}))})(o,e)&&(M(),te(e))}}function V(e){q(e)||E.props.trigger.indexOf("click")>=0&&p||(E.props.interactive?E.hideWithInteractivity(e):te(e))}function j(e){E.props.trigger.indexOf("focusin")<0&&e.target!==k()||E.props.interactive&&e.relatedTarget&&v.contains(e.relatedTarget)||te(e)}function q(e){return!!Bt.isTouch&&x()!==e.type.indexOf("touch")>=0}function X(){Z();var t=E.props,n=t.popperOptions,o=t.placement,i=t.offset,s=t.getReferenceClientRect,a=t.moveTransition,l=N()?qt(v).arrow:null,c=s?{getBoundingClientRect:s,contextElement:s.contextElement||k()}:e,d={name:"$$tippy",enabled:!0,phase:"beforeWrite",requires:["computeStyles"],fn:function(e){var t=e.state;if(N()){var n=w().box;["placement","reference-hidden","escaped"].forEach((function(e){"placement"===e?n.setAttribute("data-placement",t.placement):t.attributes.popper["data-popper-"+e]?n.setAttribute("data-"+e,""):n.removeAttribute("data-"+e)})),t.attributes.popper={}}}},p=[{name:"offset",options:{offset:i}},{name:"preventOverflow",options:{padding:{top:2,bottom:2,left:5,right:5}}},{name:"flip",options:{padding:5}},{name:"computeStyles",options:{adaptive:!a}},d];N()&&l&&p.push({name:"arrow",options:{element:l,padding:3}}),p.push.apply(p,(null==n?void 0:n.modifiers)||[]),E.popperInstance=ft(c,v,Object.assign({},n,{placement:o,onFirstUpdate:r,modifiers:p}))}function Z(){E.popperInstance&&(E.popperInstance.destroy(),E.popperInstance=null)}function J(){return kt(v.querySelectorAll("[data-tippy-root]"))}function ee(e){E.clearDelayTimeouts(),e&&P("onTrigger",[E,e]),U();var t=C(!0),o=T(),i=o[0],s=o[1];Bt.isTouch&&"hold"===i&&s&&(t=s),t?n=setTimeout((function(){E.show()}),t):E.show()}function te(e){if(E.clearDelayTimeouts(),P("onUntrigger",[E,e]),E.state.isVisible){if(!(E.props.trigger.indexOf("mouseenter")>=0&&E.props.trigger.indexOf("click")>=0&&["mouseleave","mousemove"].indexOf(e.type)>=0&&p)){var t=C(!1);t?o=setTimeout((function(){E.state.isVisible&&E.hide()}),t):i=requestAnimationFrame((function(){E.hide()}))}}else H()}}function nn(e,t){void 0===t&&(t={});var n=Kt.plugins.concat(t.plugins||[]);document.addEventListener("touchstart",Gt,At),window.addEventListener("blur",Ht);var o=Object.assign({},t,{plugins:n}),i=Ot(e).reduce((function(e,t){var n=t&&tn(t,o);return n&&e.push(n),e}),[]);return Ct(e)?i[0]:i}nn.defaultProps=Kt,nn.setDefaultProps=function(e){Object.keys(e).forEach((function(t){Kt[t]=e[t]}))},nn.currentInput=Bt,Object.assign({},Ae,{effect:function(e){var t=e.state,n={popper:{position:t.options.strategy,left:"0",top:"0",margin:"0"},arrow:{position:"absolute"},reference:{}};Object.assign(t.elements.popper.style,n.popper),t.styles=n,t.elements.arrow&&Object.assign(t.elements.arrow.style,n.arrow)}}),nn.setDefaultProps({render:Xt});const on={mainTRC:2.4,get mainTRCencode(){return 1/this.mainTRC},sRco:.2126729,sGco:.7151522,sBco:.072175,normBG:.56,normTXT:.57,revTXT:.62,revBG:.65,blkThrs:.022,blkClmp:1.414,scaleBoW:1.14,scaleWoB:1.14,loBoWoffset:.027,loWoBoffset:.027,deltaYmin:5e-4,loClip:.1,mFactor:1.9468554433171,get mFactInv(){return 1/this.mFactor},mOffsetIn:.0387393816571401,mExpAdj:.283343396420869,get mExp(){return this.mExpAdj/this.blkClmp},mOffsetOut:.312865795870758};function sn(e,t=2){const n=[["Lc",100,200,300,400,500,600,700,800,900],[0,999,999,999,999,999,999,999,999,999],[10,999,999,999,999,999,999,999,999,999],[15,777,777,777,777,777,777,777,777,777],[20,777,777,777,777,777,777,777,777,777],[25,777,777,777,120,120,108,96,96,96],[30,777,777,120,108,108,96,72,72,72],[35,777,120,108,96,72,60,48,48,48],[40,120,108,96,60,48,42,32,32,32],[45,108,96,72,42,32,28,24,24,24],[50,96,72,60,32,28,24,21,21,21],[55,80,60,48,28,24,21,18,18,18],[60,72,48,42,24,21,18,16,16,18],[65,68,46,32,21.75,19,17,15,16,18],[70,64,44,28,19.5,18,16,14.5,16,18],[75,60,42,24,18,16,15,14,16,18],[80,56,38.25,23,17.25,15.81,14.81,14,16,18],[85,52,34.5,22,16.5,15.625,14.625,14,16,18],[90,48,32,21,16,15.5,14.5,14,16,18],[95,45,28,19.5,15.5,15,14,13.5,16,18],[100,42,26.5,18.5,15,14.5,13.5,13,16,18],[105,39,25,18,14.5,14,13,12,16,18],[110,36,24,18,14,13,12,11,16,18],[115,34.5,22.5,17.25,12.5,11.875,11.25,10.625,14.5,16.5],[120,33,21,16.5,11,10.75,10.5,10.25,13,15],[125,32,20,16,10,10,10,10,12,14]],o=[["∆Lc",100,200,300,400,500,600,700,800,900],[0,0,0,0,0,0,0,0,0,0],[10,0,0,0,0,0,0,0,0,0],[15,0,0,0,0,0,0,0,0,0],[20,0,0,0,0,0,0,0,0,0],[25,0,0,0,12,12,12,24,24,24],[30,0,0,12,12,36,36,24,24,24],[35,0,12,12,36,24,18,16,16,16],[40,12,12,24,18,16,14,8,8,8],[45,12,24,12,10,4,4,3,3,3],[50,16,12,12,4,4,3,3,3,3],[55,8,12,6,4,3,3,2,2,0],[60,4,2,10,2.25,2,1,1,0,0],[65,4,2,4,2.25,1,1,.5,0,0],[70,4,2,4,1.5,2,1,.5,0,0],[75,4,3.75,1,.75,.188,.188,0,0,0],[80,4,3.75,1,.75,.188,.188,0,0,0],[85,4,2.5,1,.5,.125,.125,0,0,0],[90,3,4,1.5,.5,.5,.5,.5,0,0],[95,3,1.5,1,.5,.5,.5,.5,0,0],[100,3,1.5,.5,.5,.5,.5,1,0,0],[105,3,1,0,.5,1,1,1,0,0],[110,1.5,1.5,.75,1.5,1.125,.75,.375,1.5,1.5],[115,1.5,1.5,.75,1.5,1.125,.75,.375,1.5,1.5],[120,1,1,.5,1,.75,.5,.25,1,1],[125,0,0,0,0,0,0,0,0,0]];let i=[e.toFixed(t),0,0,0,0,0,0,0,0,0];i.length;let s=777;const a=0==(e=Math.abs(e))?1:.2*e|0;let r=0,l=.2*(e-n[a][r]);for(r++;r<10;r++)s=n[a][r],i[r]=s>400?s:e<14.5?999:e<29.5?777:s>24?Math.round(s-o[a][r]*l):s-.5*(2*o[a][r]*l|0);return i}function an(e=[0,0,0]){function t(e){return Math.pow(e/255,on.mainTRC)}return on.sRco*t(e[0])+on.sGco*t(e[1])+on.sBco*t(e[2])}function rn(e=[0,0,0,1],t=[0,0,0],n=!0){e[3]=Math.max(Math.min(e[3],1),0);let o=1-e[3],i=[0,0,0,1,!0];for(let s=0;s<3;s++)i[s]=t[s]*o+e[s]*e[3],n&&(i[s]=Math.min(Math.round(i[s]),255));return i}function ln(e){const t=parseInt(e,10);if(!Number.isNaN(t))return t;return{lighter:100,normal:400,bold:700,bolder:900}[e]||400}function cn(e,t){const n=e;let o,i,s,a=1;if(n.startsWith("rgb")){const e=n.match(/[\d.]+/g).map(Number);[o,i,s,a]=4===e.length?e:[...e,1]}else{if(n.startsWith("color(rec2020")||n.startsWith("color(display-p3"))return"unsupported";const e=document.createElement("canvas").getContext("2d");e.fillStyle=n,e.fillRect(0,0,1,1);const t=e.getImageData(0,0,1,1);[o,i,s,a]=t.data,a=(a/255).toFixed(2)}return t&&t<1&&(a=(a*t).toFixed(2)),[o,i,s,Number(a)]}function dn(e){let t=e;for(;t&&1===t.nodeType;){const e=getComputedStyle(t),n=cn(e.backgroundColor),o=e.backgroundImage;if("none"!==o)return{type:"image",value:o};if(0!==n[3]&&"transparent"!==n){if(n[3]<1){let e=t.parentElement,o="rgba(255, 255, 255, 1)";for(;e&&1===e.nodeType;){if(o=getComputedStyle(e).backgroundColor,"rgba(0, 0, 0, 0)"!==o)break;"rgba(0, 0, 0, 0)"===o&&"HTML"===e.tagName&&(o="rgba(255, 255, 255, 1)"),e=e.parentElement}return rn(n,cn(o||"rgba(255, 255, 255, 1)"))}return n}if("HTML"===t.tagName)return[255,255,255];t=t.parentNode}return[255,255,255]}function pn(e){const t=e.slice(0,3).map((e=>{const t=e/255;return t<=.03928?t/12.92:((t+.055)/1.055)**2.4}));return.2126*t[0]+.7152*t[1]+.0722*t[2]}function un(e,t){return(Math.max(e,t)+.05)/(Math.min(e,t)+.05)}function hn(e,t){return e.map(((e,n)=>{if(n<3){const n=Math.ceil(e+(255-e)*t);return n>=255?255:n}return e}))}function mn(e,t){return e.map(((e,n)=>{if(n<3){const n=Math.floor(e*(1-t));return n<=0?0:n}return e}))}function gn(e){const[t,n,o]=e.map((e=>Math.min(255,Math.max(0,e))));return`#${t.toString(16).padStart(2,"0")}${n.toString(16).padStart(2,"0")}${o.toString(16).padStart(2,"0")}`}function fn(e){return n.Global.contrastAPCA?Math.abs(Number(e.toFixed(1))):`${e.toFixed(2)}:1`}function bn(e,t){let o;const i=rn(e,t).slice(0,4);if(n.Global.contrastAPCA){o=function(e,t,n=-1){const o=[0,1.1];if(isNaN(e)||isNaN(t)||Math.min(e,t)<o[0]||Math.max(e,t)>o[1])return 0;let i=0,s=0,a="BoW";return e=e>on.blkThrs?e:e+Math.pow(on.blkThrs-e,on.blkClmp),t=t>on.blkThrs?t:t+Math.pow(on.blkThrs-t,on.blkClmp),Math.abs(t-e)<on.deltaYmin?0:(t>e?(i=(Math.pow(t,on.normBG)-Math.pow(e,on.normTXT))*on.scaleBoW,s=i<on.loClip?0:i-on.loBoWoffset):(a="WoB",i=(Math.pow(t,on.revBG)-Math.pow(e,on.revTXT))*on.scaleWoB,s=i>-on.loClip?0:i+on.loWoBoffset),n<0?100*s:0==n?Math.round(100*Math.abs(s))+"<sub>"+a+"</sub>":Number.isInteger(n)?(100*s).toFixed(n):0)}(an(i),an(t))}else{o=un(pn(i),pn(t))}return{ratio:o,blendedColor:i}}function yn(e,t,n,o){const i=an(t);let s=e,a=bn(s,t),r=sn(a.ratio).slice(1);const l=Math.floor(n/100)-1,c=r[l],d=o<c||999===c||777===c,p=((e,t)=>{const n=bn(e,[0,0,0,1]),o=bn(e,[255,255,255,1]),i=Math.abs(n.ratio)>Math.abs(o.ratio),s=i?[0,0,0,1]:[255,255,255,1],a=sn(i?n.ratio:o.ratio).slice(1);return{suggestedColor:s,size:Math.ceil(a[Math.floor(t/100)-1])}})(t,n);if(p.size>o)return{color:gn(p.suggestedColor),size:p.size};let u=e,h=s,m=a.ratio,g=.16;let f=0;if(d)for(;g>=.01;)if(f+=1,b=s,y=g,s=i<=.179?hn(b,y):mn(b,y),a=bn(s,t),r=sn(a.ratio).slice(1),r[l]<=o&&(h=Math.abs(a.ratio)<=Math.abs(m)?s:h,m=a.ratio,h=s,s=u,g*=.5),u=s,50===f)return{color:gn(p.suggestedColor),size:p.size};var b,y;return{color:gn(h),size:null}}function En(e){let o;const{color:i,background:s,fontWeight:a,fontSize:r,isLargeText:l,type:c}=e;if(i&&s&&"image"!==s.type&&"text"===c){const c=n.Global.contrastAPCA?yn(i,s,a,r):function(e,t,n){const o=n?3:4.5,i=pn(e),s=pn(t),a=i>s?un(1,s)>o:un(0,s)<o;let r=e,l=r,c=un(i,s),d=c,p=e,u=.16;for(;u>=.01;)h=r,m=u,r=a?hn(h,m):mn(h,m),c=un(pn(r),s),c>=o&&(l=c<=d?r:l,d=c,r=p,u*=.5),p=r;var h,m;return{color:gn(l)}}(i,s,l);let d;const p='<hr aria-hidden="true">',u=`<strong class="badge" style="${`color:${c.color};background-color:${gn(e.background)};`}">${c.color}</strong>`,h=`<strong class="normal-badge">${c.size}px</strong>`;n.Global.contrastAPCA?c.color&&c.size?d=`${p} ${t._("CONTRAST_APCA")} ${u} ${h}`:c.color?d=`${p} ${t._("CONTRAST_COLOR")} ${u}`:c.size&&(d=`${p} ${t._("CONTRAST_SIZE")} ${h}`):d=`${p} ${t._("CONTRAST_COLOR")} ${u}`,o=document.createElement("div"),o.id="advice";const m=e.opacity<1?`<hr aria-hidden="true"> ${t.sprintf("CONTRAST_OPACITY")}`:d;o.innerHTML=m}return o}function An(e,t){const o=e?.querySelector("#contrast-tools");if(o){const{fontSize:o,fontWeight:i,type:s}=t,a=e.querySelector("#contrast"),r=e.querySelector("#contrast-preview"),l=e.querySelector("#fg-input"),c=e.querySelector("#bg-input"),d=e.querySelector("#non-text"),p=e.querySelector("#body-text"),u=e.querySelector("#large-text"),h=e.querySelector("#value"),m=e.querySelector("#apca"),g=e.querySelector("#apca-table"),f=(e,t)=>{e.forEach((e=>{e.classList.toggle("good-contrast",t),e.classList.toggle("error-badge",!t)}))},b=()=>{const e=l.value,t=c.value;[l,c].forEach((e=>e.classList.remove("unknown"))),r.style.color=e,r.style.backgroundColor=t,r.style.backgroundImage="none";const b=r.querySelectorAll("svg *");if(1===b.length){const{fill:t,stroke:n}=getComputedStyle(b[0]);b[0].style.opacity=1,"none"!==t&&(b[0].style.fill=e),"none"!==n&&(b[0].style.stroke=e)}const y=bn(cn(e),cn(t)),E=[h,a];if(n.Global.contrastAPCA){const e=y.ratio;h.textContent=fn(e);const t=sn(e).slice(1),n=e>=45&&t[0]>=0&&t[0]<=777;let a;switch(s){case"svg-error":case"svg-warning":d.hidden=!n,a=n,f(E,a);break;case"svg-text":d.hidden=!n,a=t.slice(1,7).some((e=>999!==e&&777!==e)),f(E,a),function(e,t){const n=e;n.innerHTML="",n.hidden=!1;const o=document.createElement("div");o.classList.add("row");const i=t.slice(1,7);for(let e=0;e<i.length;e++){const t=i[e],s=100*(e+2);if(777!==t&&999!==t){const e=document.createElement("div");e.classList.add("cell");const i=document.createElement("div");i.classList.add("font-size"),i.textContent=`${Math.ceil(t)}px`;const a=document.createElement("div");a.classList.add("font-weight"),a.textContent=`${s}`,e.appendChild(i),e.appendChild(a),o.appendChild(e),n.appendChild(o)}}}(g,t);break;default:{const e=t[Math.floor(i/100)-1];a=o>=e,f(E,a),m.hidden=!a;break}}}if(!n.Global.contrastAPCA){const e=y.ratio;h.textContent=fn(e);const t=e>=3;switch(s){case"svg-error":case"svg-warning":d.hidden=!t,f(E,t);break;case"svg-text":d.hidden=!t,f(E,t),u.hidden=!t,p.hidden=e<=4.5;break;default:f([h,a],t),u.hidden=!t,p.hidden=e<=4.5}}};l.addEventListener("input",b),c.addEventListener("input",b)}}function vn(e,t,n,o,i,s){const{ratio:a,blendedColor:r}=bn(t,n),l=o>=24||o>=18.67&&i>=700;return l&&a<3||!l&&(a>1&&a<4.5)?{$el:e,ratio:fn(a),color:r,background:n,fontSize:o,fontWeight:i,isLargeText:l,opacity:s,textUnderline:getComputedStyle(e).textDecorationLine}:null}function _n(e,t,n,o,i,s){const{ratio:a,blendedColor:r}=bn(t,n);return o<sn(a).slice(1)[Math.floor(i/100)-1]?{$el:e,ratio:fn(a),color:r,background:n,fontWeight:i,fontSize:o,opacity:s,textUnderline:getComputedStyle(e).textDecorationLine}:null}function In(e,t,o,i,s,a){return(n.Global.contrastAPCA?_n:vn)(e,t,o,i,s,a)}var Ln='a,button,code,div,h1,h2,kbd,li,ol,p,span,strong,svg,ul{all:unset;box-sizing:border-box!important}div{display:block}:after,:before{all:unset}.tippy-box[data-animation=fade][data-state=hidden]{opacity:0}[data-tippy-root]{max-width:calc(100vw - 10px)}@media (forced-colors:active){[data-tippy-root]{border:2px solid transparent;border-radius:5px}}.tippy-box[data-placement^=top]>.tippy-arrow{bottom:0}.tippy-box[data-placement^=top]>.tippy-arrow:before{border-top-color:initial;border-width:8px 8px 0;bottom:-7px;left:0;transform-origin:center top}.tippy-box[data-placement^=bottom]>.tippy-arrow{top:0}.tippy-box[data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:initial;border-width:0 8px 8px;left:0;top:-7px;transform-origin:center bottom}.tippy-box[data-placement^=left]>.tippy-arrow{right:0}.tippy-box[data-placement^=left]>.tippy-arrow:before{border-left-color:initial;border-width:8px 0 8px 8px;right:-7px;transform-origin:center left}.tippy-box[data-placement^=right]>.tippy-arrow{left:0}.tippy-box[data-placement^=right]>.tippy-arrow:before{border-right-color:initial;border-width:8px 8px 8px 0;left:-7px;transform-origin:center right}.tippy-arrow{color:#333;height:16px;width:16px}.tippy-arrow:before{border-color:transparent;border-style:solid;content:"";position:absolute}.tippy-content{padding:5px 9px;position:relative;z-index:1}.tippy-box[data-theme~=sa11y-theme][role=tooltip]{box-sizing:border-box!important}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-animation=fade][data-state=hidden]{opacity:0}.tippy-box[data-theme~=sa11y-theme][role=tooltip][data-inertia][data-state=visible]{transition-timing-function:cubic-bezier(.54,1.5,.38,1.11)}[role=dialog]{word-wrap:break-word;min-width:300px;text-align:start}[role=tooltip]{min-width:185px;text-align:center}.tippy-box[data-theme~=sa11y-panel]{border:1px solid var(--sa11y-panel-bg-splitter);box-shadow:var(--sa11y-box-shadow)}.tippy-box[data-theme~=sa11y-theme]:not([data-theme~=sa11y-panel]){box-shadow:0 0 20px 4px rgba(154,161,177,.15),0 4px 80px -8px rgba(36,40,47,.25),0 4px 4px -2px rgba(91,94,105,.15)!important}.tippy-box[data-theme~=sa11y-theme]{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-bg);border-radius:4px;color:var(--sa11y-panel-primary);display:block;font-family:var(--sa11y-font-face);font-size:var(--sa11y-normal-text);font-weight:400;letter-spacing:normal;line-height:22px;outline:0;padding:8px;position:relative;transition-property:transform,visibility,opacity}.tippy-box[data-theme~=sa11y-theme] code{font-family:monospace;font-size:calc(var(--sa11y-normal-text) - 1px);font-weight:500}.tippy-box[data-theme~=sa11y-theme] code,.tippy-box[data-theme~=sa11y-theme] kbd{-webkit-font-smoothing:auto;background-color:var(--sa11y-panel-badge);border-radius:3.2px;color:var(--sa11y-panel-primary);letter-spacing:normal;line-height:22px;padding:1.6px 4.8px}.tippy-box[data-theme~=sa11y-theme] .tippy-content{padding:5px 9px}.tippy-box[data-theme~=sa11y-theme] sub,.tippy-box[data-theme~=sa11y-theme] sup{font-size:var(--sa11y-small-text)}.tippy-box[data-theme~=sa11y-theme] ul{margin:0;margin-block-end:0;margin-block-start:0;padding:0;position:relative}.tippy-box[data-theme~=sa11y-theme] li{display:list-item;margin:5px 10px 0 20px;padding-bottom:5px}.tippy-box[data-theme~=sa11y-theme] a{color:var(--sa11y-hyperlink);cursor:pointer;font-weight:500;text-decoration:underline}.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] a:hover{text-decoration:none}.tippy-box[data-theme~=sa11y-theme] strong{font-weight:600}.tippy-box[data-theme~=sa11y-theme] hr{background:var(--sa11y-panel-bg-splitter);border:none;height:1px;margin:10px 0;opacity:1;padding:0}.tippy-box[data-theme~=sa11y-theme] button.close-btn{margin:0}.tippy-box[data-theme~=sa11y-theme] .dismiss-group{margin-top:5px}.tippy-box[data-theme~=sa11y-theme] .dismiss-group button{background:var(--sa11y-panel-bg-secondary);border:2px solid var(--sa11y-button-outline);border-radius:5px;color:var(--sa11y-panel-primary);cursor:pointer;display:inline-block;margin:10px 5px 5px 0;margin-inline-end:15px;padding:4px 8px}.tippy-box[data-theme~=sa11y-theme] .dismiss-group button:focus,.tippy-box[data-theme~=sa11y-theme] .dismiss-group button:hover{background:var(--sa11y-shortcut-hover)}.tippy-box[data-theme~=sa11y-theme] .good-icon{background:var(--sa11y-good-text);display:inline-block;height:14px;margin-bottom:-2.5px;-webkit-mask:var(--sa11y-good-svg) center no-repeat;mask:var(--sa11y-good-svg) center no-repeat;width:14px}.tippy-box[data-theme~=sa11y-theme] .link-icon{background:var(--sa11y-panel-primary);display:inline-block;height:16px;margin-bottom:-3.5px;-webkit-mask:var(--sa11y-link-icon-svg) center no-repeat;mask:var(--sa11y-link-icon-svg) center no-repeat;width:16px}.tippy-box[data-theme~=sa11y-theme] .error .badge{background:var(--sa11y-error);color:var(--sa11y-error-text)}.tippy-box[data-theme~=sa11y-theme] .error .colour{color:var(--sa11y-red-text)}.tippy-box[data-theme~=sa11y-theme] .error .link-icon{background:var(--sa11y-error-text)}.tippy-box[data-theme~=sa11y-theme] .warning .badge{background:var(--sa11y-yellow-text);color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme] .warning .colour{color:var(--sa11y-yellow-text)}.tippy-box[data-theme~=sa11y-theme] .warning .link-icon{background:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme] #apca-table{width:100%}.tippy-box[data-theme~=sa11y-theme] #apca-table .row{display:flex;margin-top:10px}.tippy-box[data-theme~=sa11y-theme] #apca-table .cell{align-items:center;display:flex;flex:1;flex-direction:column;padding:1px}.tippy-box[data-theme~=sa11y-theme] #apca-table .font-weight{font-size:calc(var(--sa11y-normal-text) - 2px);font-weight:700}.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{border-top-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before{border-bottom-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before{border-left-color:var(--sa11y-panel-bg)}.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before{border-right-color:var(--sa11y-panel-bg)}@media (forced-colors:active){.tippy-box[data-theme~=sa11y-theme][data-placement^=bottom]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=left]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=right]>.tippy-arrow:before,.tippy-box[data-theme~=sa11y-theme][data-placement^=top]>.tippy-arrow:before{forced-color-adjust:none}.tippy-box[data-theme~=sa11y-theme] .tippy-arrow{z-index:-1}}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:active,.tippy-box[data-theme~=sa11y-theme] button:focus,.tippy-box[data-theme~=sa11y-theme] input:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] a:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] button:focus:not(:focus-visible),.tippy-box[data-theme~=sa11y-theme] input:focus:not(:focus-visible){box-shadow:none;outline:0}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus-visible,.tippy-box[data-theme~=sa11y-theme] a:focus-visible,.tippy-box[data-theme~=sa11y-theme] button:focus-visible,.tippy-box[data-theme~=sa11y-theme] input:focus-visible{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){.tippy-box[data-theme~=sa11y-theme] .error-icon,.tippy-box[data-theme~=sa11y-theme] .hidden-icon,.tippy-box[data-theme~=sa11y-theme] .link-icon{filter:invert(1)}.tippy-box[data-theme~=sa11y-theme] [tabindex="-1"]:focus,.tippy-box[data-theme~=sa11y-theme] a:focus,.tippy-box[data-theme~=sa11y-theme] button:focus{outline:3px solid transparent!important}}';class Tn extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),o=document.createElement("style");o.innerHTML=Ln+Y,e.appendChild(o);const i=[];O.Annotations.Array.forEach((e=>{const t=e.shadowRoot.querySelectorAll(".sa11y-btn");t&&i.push(...Array.from(t))}));const s=nn(i,{interactive:!0,trigger:"mouseenter click",hideOnClick:!1,arrow:!0,offset:[0,8],delay:[0,400],maxWidth:375,theme:"sa11y-theme",placement:"auto-start",allowHTML:!0,role:"dialog",aria:{content:null,expanded:"auto"},appendTo:e,zIndex:2147483645,onShow(e){s.forEach((t=>{t!==e.popper&&t.hide()}));const o=e.reference.getRootNode().host;o.setAttribute("data-sa11y-opened","");const i=e.popper.querySelector(".close-btn"),a=()=>{e.hide(),e.reference.focus()};i.addEventListener("click",a);const r=t=>{"Escape"===t.key&&(e.hide(),e.reference.focus())};if(e.popper.addEventListener("keydown",r),!e.popper.hasAttribute("contrast-tools-initialized")){const i=parseInt(o.getAttribute("data-sa11y-annotation"),10),s=window.sa11yCheckComplete.results.find((e=>e.id===i)),{contrastDetails:a}=s||{};if(a){const o=e.popper.querySelector("[data-sa11y-contrast-details]"),i=function(e){const{sanitizedText:o,color:i,background:s,fontWeight:a,fontSize:r,ratio:l,textUnderline:c}=e,d=s&&"image"!==s.type,p=d?gn(s):"#000000",u=i?gn(i):"#000000",h=a?`font-weight:${a};`:"",m=r?`font-size:${r}px;`:"",g=c?`text-decoration:${c};`:"",f=i?"":'class="unknown"',b=s&&"image"!==s.type?"":'class="unknown"',y=i?"":`<span class="visually-hidden">(${t._("UNKNOWN")})</span>`,E=s?"":`<span class="visually-hidden">(${t._("UNKNOWN")})</span>`;let A;A=n.Global.contrastAPCA?0===Math.abs(l)?0:Math.abs(l)||t._("UNKNOWN"):l||t._("UNKNOWN");const v=document.createElement("div");return v.id="contrast-tools",v.innerHTML=`\n      <hr aria-hidden="true">\n      <div id="contrast" class="badge">${t._("CONTRAST")}</div>\n      <div id="value" class="badge">${A}</div>\n      <div id="non-text" class="badge good-contrast" hidden>${t._("NON_TEXT")}</div>\n      <div id="large-text" class="badge good-contrast" hidden>${t._("LARGE_TEXT")}</div>\n      <div id="body-text" class="badge good-contrast" hidden>${t._("BODY_TEXT")}</div>\n      <div id="apca" class="badge good-contrast" hidden>${t._("GOOD")}</div>\n      <div id="apca-table" hidden></div>\n      <div id="contrast-preview" style="color:${u};${d?`background:${p};${o.length?"":"display: none;"}`:""}${h+m+g}">${o}</div>\n      <div id="color-pickers">\n        <label for="fg-text">${t._("FG")} ${y}\n          <input type="color" id="fg-input" value="${u}" ${f}/>\n        </label>\n        <label for="bg">${t._("BG")} ${E}\n          <input type="color" id="bg-input" value="${p}" ${b}/>\n        </label>\n      </div>`,v}(a);o.appendChild(i),An(e.popper,a);const s=En(a);s&&o.appendChild(s),e.popper.setAttribute("contrast-tools-initialized",!0)}}let l=!0;e.popper.addEventListener("mousedown",(function t(n){l&&n.target.matches('input[type="color"]')&&(e.reference.click(),l=!1,e.popper.removeEventListener("mousedown",t))}));const c=()=>{i.removeEventListener("click",a),e.popper.removeEventListener("keydown",r),e.popper.removeEventListener("hidden",c)};e.popper.addEventListener("hidden",c)},onTrigger(e,t){"click"===t.type&&setTimeout((()=>{e.popper.querySelector(".close-btn").focus(),function(e){const t=e.querySelectorAll('a[href]:not([disabled]), button:not([disabled]), input[type="color"]'),n=t[0],o=t[t.length-1];e.addEventListener("keydown",(t=>{const i="Tab"===t.key||9===t.keyCode,s=e.getRootNode();i&&(t.shiftKey?s.activeElement===n&&(o.focus(),t.preventDefault()):s.activeElement===o&&(n.focus(),t.preventDefault()))}))}(e.popper)}),0)},onHide(e){e.popper.querySelector(".close-btn").removeEventListener("click",(()=>{e.hide()}));e.reference.getRootNode().host.removeAttribute("data-sa11y-opened")}})}}class xn extends HTMLElement{connectedCallback(){const e=e=>({allowHTML:!0,delay:[500,0],trigger:"mouseenter focusin",arrow:!0,placement:"top",theme:"sa11y-theme sa11y-panel",role:"tooltip",aria:{content:null,expanded:null},appendTo:e,zIndex:2147483645}),o=this.attachShadow({mode:"open"}),i=document.createElement("style");i.innerHTML=Ln+Y,o.appendChild(i);const s=-1!==navigator.userAgent.indexOf("Mac")?'<span class="kbd">Option</span> + <span class="kbd">S</span>':'<span class="kbd">Alt</span> + <span class="kbd">S</span>';if(nn(n.Panel.skipButton,{...e(o),offset:[0,8],maxWidth:200,content:`${t._("SKIP_TO_ISSUE")} &raquo; <br> ${s}`}),this.object=nn(n.Panel.dismissButton,{offset:[0,8],maxWidth:200,...e(o)}),n.Global.developerPlugin){nn(n.Panel.developerItem.querySelector(".info-icon"),{...e(o),triggerTarget:[n.Panel.developerItem],offset:[0,10],maxWidth:250,content:t._("DEVELOPER_DESC")})}}}class Nn extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.innerHTML='.instance{display:block;position:relative}.instance-inline{display:inline-block;position:relative;text-align:end}button{border-radius:50%;box-shadow:0 0 16px 0 rgba(0,0,0,.31);cursor:pointer;display:block;padding:0;transition:all .2s ease-in-out;z-index:8888}button,button:after{height:36px;position:absolute;width:36px}button:after{content:"";left:-7px;padding:7px;top:-7px}.warning-btn{margin:20px}.error-btn,.good-btn{margin:10px}.error-btn-text,.good-btn-text,.warning-btn-text{margin:-30px 10px}.error-btn,.error-btn-text{background:50% 50% var(--sa11y-error-svg) no-repeat;background-color:var(--sa11y-error);background-size:22px;border:1px solid var(--sa11y-error)}.error-btn-text:focus,.error-btn-text:hover,.error-btn:focus,.error-btn:hover{background-color:var(--sa11y-error-hover)}.good-btn,.good-btn-text{background:50% 50% var(--sa11y-good) var(--sa11y-good-svg) no-repeat;background-color:var(--sa11y-good);background-size:20px;border:1px solid var(--sa11y-good)}.good-btn-text:focus,.good-btn-text:hover,.good-btn:focus,.good-btn:hover{background-color:var(--sa11y-good-hover)}.warning-btn,.warning-btn-text{background:50% 50% var(--sa11y-warning) var(--sa11y-warning-svg) no-repeat;background-color:var(--sa11y-warning);background-size:24px;border:1px solid var(--sa11y-warning);transform:scaleX(var(--sa11y-icon-direction))}.warning-btn-text:focus,.warning-btn-text:hover,.warning-btn:focus,.warning-btn:hover{background-color:var(--sa11y-warning-hover)}.sa11y-btn:active,.sa11y-btn:focus{box-shadow:0 0 0 5px var(--sa11y-focus-color);outline:0}@media screen and (forced-colors:active){.sa11y-btn{border:1px solid transparent!important;forced-color-adjust:none;outline:3px solid transparent!important}}'+Y,e.appendChild(t)}}const kn=e=>{document.querySelectorAll("sa11y-annotation").forEach((t=>{const n=((e,t,n)=>{let o=e;for(;null!==o;){if(window.getComputedStyle(o).getPropertyValue(t)===n)return o;o=o.parentElement}return null})(t,"overflow","hidden");if(null!==n){if(e){if(e.split(",").flatMap((e=>[...document.querySelectorAll(e)])).includes(n))return}n.setAttribute("data-sa11y-overflow","")}}))};class Sn extends HTMLElement{connectedCallback(){this.attachShadow({mode:"open"})}}class wn extends HTMLElement{connectedCallback(){const e=this.attachShadow({mode:"open"}),t=document.createElement("style");t.textContent="\n      span.heading-label {\n        background-color: #777678;\n        background-image: linear-gradient(to bottom right, #b629ce, #16aec2);\n        border-radius: 5px;\n        border: 1px solid #36a5c3;\n        color: white;\n        display: inline-block;\n        font-family: var(--sa11y-font-face);\n        font-weight: 500;\n        font-size: 18px;\n        line-height: normal;\n        letter-spacing: normal;\n        margin: -5px 0 0 5px;\n        padding: 3px;\n        position: absolute;\n        text-shadow: 1px 1px black;\n        -webkit-text-fill-color: white;\n        word-break: keep-all;\n        z-index: 200;\n      }\n      @media screen and (forced-colors: active) {\n        span.heading-label {\n          border: 2px solid transparent;\n        }\n      }",e.appendChild(t)}}const Cn=(e,o)=>{if(0===e.offsetTop){const n=e.getRootNode().host,i=E(n,"display","none"),s=parseInt(n.getAttribute("data-sa11y-annotation"),10),a=w(o.find((e=>e.id===s)));(e=>{const t=E(e.getRootNode().host,"display","none");if(null!==t){_(t.previousElementSibling||t.parentNode)}})(e);const r=e.getAttribute("data-tippy-content");if(T(`${t._("NOT_VISIBLE")}`,r,a),(()=>{const e=document.querySelector("sa11y-tooltips").shadowRoot.querySelector("button");null!==e&&e.click()})(),i){const e=i.previousElementSibling,{parentNode:t}=i;return e?A(e).top-150:A(t).top-150}}else L(),n.Panel.skipButton.focus();return A(e).top-150};let On=-1;const Pn=()=>{const e=v.getItem("sa11y-latest-dismissed");null!==e&&(On=parseInt(e,10)-1),v.removeItem("sa11y-latest-dismissed");const t=o("[data-sa11y-opened]","root");t[0]&&(On=parseInt(t[0].getAttribute("data-sa11y-position"),10))},Rn=e=>{Pn();const t=O.Annotations.Array;On>=t.length-1&&(On=-1);const o=t[On+1].shadowRoot.querySelector("button"),i=Cn(o,e);window.scrollTo({top:i,behavior:`${n.Global.scrollBehaviour}`}),0!==o.offsetTop&&(o.focus(),o.click()),On+=1};function Dn(e,t){O.Annotations.Array.length&&!n.Panel.skipButton.hasAttribute("disabled")&&(!e.altKey||"KeyS"!==e.code&&"Period"!==e.code?!e.altKey||"KeyW"!==e.code&&"Comma"!==e.code||(e.preventDefault(),(e=>{Pn();const t=O.Annotations.Array;On<=0&&(On=t.length);const o=O.Annotations.Array[On-1].shadowRoot.querySelector("button"),i=Cn(o,e);window.scrollTo({top:i,behavior:`${n.Global.scrollBehaviour}`}),0!==o.offsetTop&&(o.focus(),o.click()),On-=1,-1===On&&(On=O.Annotations.Array.length-1)})(t)):(e.preventDefault(),Rn(t)))}let Mn,Bn;function $n(e,o){return O.Found.Images.forEach((i=>{const s="noAria"===a(i)?i.getAttribute("alt"):a(i),l=i.closest(o.imageWithinLightbox?`a[href]:not(${o.imageWithinLightbox})`:"a[href]"),c=i.getAttribute("src")?i.getAttribute("src"):i.getAttribute("srcset"),p=l?g(l,n.Exclusions.LinkSpan).textContent:"",h=o.linkIgnoreStrings?p.replace(o.linkIgnoreStrings,""):p,m=l?b(h).length:0;if("true"!==i.getAttribute("aria-hidden")&&(1!==i.height||1!==i.width||!d(i)))if(l&&"true"===l.getAttribute("aria-hidden")){const n="-1"===l.getAttribute("tabindex");o.checks.HIDDEN_FOCUSABLE&&!n&&e.push({element:i,type:o.checks.HIDDEN_FOCUSABLE.type||"error",content:t.sprintf(o.checks.HIDDEN_FOCUSABLE.content||"HIDDEN_FOCUSABLE"),dismiss:I(`IMGHIDDENFOCUSABLE${c}`),dismissAll:!!o.checks.HIDDEN_FOCUSABLE.dismissAll&&"LINK_HIDDEN_FOCUSABLE",developer:o.checks.HIDDEN_FOCUSABLE.developer||!0})}else if(null===s)if(l){const n=0===m?o.checks.MISSING_ALT_LINK:o.checks.MISSING_ALT_LINK_HAS_TEXT,s=0===m?"MISSING_ALT_LINK":"MISSING_ALT_LINK_HAS_TEXT";n&&e.push({element:i,type:n.type||"error",content:t.sprintf(n.content||0===m?"MISSING_ALT_LINK":"MISSING_ALT_LINK_HAS_TEXT"),dismiss:I(`${s+c+m}`),dismissAll:!!n.dismissAll&&s,developer:n.developer||!1})}else o.checks.MISSING_ALT&&e.push({element:i,type:o.checks.MISSING_ALT.type||"error",content:t.sprintf(o.checks.MISSING_ALT.content||"MISSING_ALT"),dismiss:I(`IMGNOALT${c}`),dismissAll:!!o.checks.MISSING_ALT.dismissAll&&"MISSING_ALT",developer:o.checks.MISSING_ALT.developer||!1});else{const n=b(u(s)),a=(e=>{const n=[null,null,null];[".avif",".png",".jpg",".jpeg",".webp",".gif",".tiff",".svg",".heif",".heic","http"].forEach((t=>{if(-1!==e.toLowerCase().indexOf(t.toLowerCase()))n[0]=t;else{const t=/\b\d{2,6}\s*x\s*\d{2,6}\b/,o=e.toLowerCase().match(t);o&&([n[0]]=o)}})),(o.susAltStopWords?o.susAltStopWords.split(",").map((e=>e.trim())):t._("SUS_ALT_STOPWORDS")).forEach((t=>{const o=e.toLowerCase().indexOf(t);o>-1&&o<6&&(n[1]=t)})),t._("PLACEHOLDER_ALT_STOPWORDS").forEach((t=>{e.length===t.length&&e.toLowerCase().indexOf(t)>=0&&(n[2]=t)}));const{extraPlaceholderStopWords:i}=o;i.length&&i.split(",").map((e=>e.trim())).forEach((t=>{const o=e.toLowerCase().indexOf(t);o>-1&&o<6&&(n[2]=t)}));return n})(n),d=i.getAttribute("aria-label")||i.getAttribute("aria-labelledby"),p=i.getAttribute("title"),h=""===s||" "===s,g=i.closest("figure"),f=g?.querySelector("figcaption"),E=f?f.textContent.trim():"",A=o.checks.LINK_IMAGE_LONG_ALT.maxLength||250,v=o.checks.IMAGE_ALT_TOO_LONG.maxLength||250;if(d&&""===n)return void(o.checks.MISSING_ALT&&e.push({element:i,type:o.checks.MISSING_ALT.type||"error",content:t.sprintf(o.checks.MISSING_ALT.content||"MISSING_ALT"),dismiss:I(`IMGNOALTARIA${c}`),dismissAll:!!o.checks.MISSING_ALT.dismissAll&&"MISSING_ALT",developer:o.checks.MISSING_ALT.developer||!1}));if(h){const n=o.checks.IMAGE_DECORATIVE_CAROUSEL.sources,s=n?i.closest(n):"";if(s){const n=s.querySelectorAll("img"),a=1===n.length?o.checks.IMAGE_DECORATIVE:o.checks.IMAGE_DECORATIVE_CAROUSEL,r=1===n.length?"IMAGE_DECORATIVE":"IMAGE_DECORATIVE_CAROUSEL";a&&e.push({element:i,type:a.type||"warning",content:t.sprintf(a.content||r),dismiss:I(r+c),dismissAll:!!a.dismissAll&&r,developer:a.developer||!1})}else if(l){const n=0===m?o.checks.LINK_IMAGE_NO_ALT_TEXT:o.checks.LINK_IMAGE_TEXT,s=0===m?"LINK_IMAGE_NO_ALT_TEXT":"LINK_IMAGE_TEXT";n&&e.push({element:i,type:n.type||(0===m?"error":"good"),content:t.sprintf(n.content||s),dismiss:I(`${s+c+m}`),dismissAll:!!n.dismissAll&&s,developer:n.developer||!1})}else if(g){const n=f&&E.length?o.checks.IMAGE_FIGURE_DECORATIVE:o.checks.IMAGE_DECORATIVE,s=f&&E.length?"IMAGE_FIGURE_DECORATIVE":"IMAGE_DECORATIVE";n&&e.push({element:i,type:n.type||"warning",content:t.sprintf(n.content||s),dismiss:I(`${s+c+E}`),dismissAll:!!n.dismissAll&&s,developer:n.developer||!1})}else o.checks.IMAGE_DECORATIVE&&e.push({element:i,type:o.checks.IMAGE_DECORATIVE.type||"warning",content:t.sprintf(o.checks.IMAGE_DECORATIVE.content||"IMAGE_DECORATIVE"),dismiss:I(`DECIMAGE${c}`),dismissAll:!!o.checks.IMAGE_DECORATIVE.dismissAll&&"IMAGE_DECORATIVE",developer:o.checks.IMAGE_DECORATIVE.developer||!1});return}if(null!==a[0]){const s=l?o.checks.LINK_ALT_FILE_EXT:o.checks.ALT_FILE_EXT,r=l?"LINK_ALT_FILE_EXT":"ALT_FILE_EXT";s&&e.push({element:i,type:s.type||"error",content:t.sprintf(s.content||l?"LINK_ALT_FILE_EXT":"ALT_FILE_EXT",a[0],n),dismiss:I(`${r+c+n}`),dismissAll:!!s.dismissAll&&r,developer:s.developer||!1})}else if(null!==a[2]){const s=l?o.checks.LINK_PLACEHOLDER_ALT:o.checks.ALT_PLACEHOLDER,a=l?"LINK_PLACEHOLDER_ALT":"ALT_PLACEHOLDER";s&&e.push({element:i,type:s.type||"error",content:t.sprintf(s.content||l?"LINK_PLACEHOLDER_ALT":"ALT_PLACEHOLDER",n),dismiss:I(`${a+c+n}`),dismissAll:!!s.dismissAll&&a,developer:s.developer||!1})}else if(null!==a[1]){const s=l?o.checks.LINK_SUS_ALT:o.checks.SUS_ALT,r=l?"LINK_SUS_ALT":"SUS_ALT";s&&e.push({element:i,type:s.type||"warning",content:t.sprintf(s.content||l?"LINK_SUS_ALT":"SUS_ALT",a[1],n),dismiss:I(`${r+c+n}`),dismissAll:!!s.dismissAll&&r,developer:s.developer||!1})}else if(l?s.length>A:s.length>v){const a=l?o.checks.LINK_IMAGE_LONG_ALT:o.checks.IMAGE_ALT_TOO_LONG,r=l?"LINK_IMAGE_LONG_ALT":"IMAGE_ALT_TOO_LONG",d=y(n,600);a&&e.push({element:i,type:a.type||"warning",content:t.sprintf(a.content||(l?"LINK_IMAGE_LONG_ALT":"IMAGE_ALT_TOO_LONG"),s.length,d),dismiss:I(`${r+c+n}`),dismissAll:!!a.dismissAll&&r,developer:a.developer||!1})}else if(l){const s=0===m?o.checks.LINK_IMAGE_ALT:o.checks.LINK_IMAGE_ALT_AND_TEXT,a=0===m?"LINK_IMAGE_ALT":"LINK_IMAGE_ALT_AND_TEXT";if(s){const o=u(b(r(l))),d=0===m?t.sprintf("LINK_IMAGE_ALT",n):`${t.sprintf("LINK_IMAGE_ALT_AND_TEXT",n,o)} ${t.sprintf("ACC_NAME_TIP")}`;e.push({element:i,type:s.type||"warning",content:s.content?t.sprintf(s.content,n,o):d,dismiss:I(`${a+c+n}`),dismissAll:!!s.dismissAll&&a,developer:s.developer||!1})}}else if(g){!!f&&E.toLowerCase()===n.trim().toLowerCase()?o.checks.IMAGE_FIGURE_DUPLICATE_ALT&&e.push({element:i,type:o.checks.IMAGE_FIGURE_DUPLICATE_ALT.type||"warning",content:t.sprintf(o.checks.IMAGE_FIGURE_DUPLICATE_ALT.content||"IMAGE_FIGURE_DUPLICATE_ALT",n),dismiss:I(`FIGDUPLICATE${c}`),dismissAll:!!o.checks.IMAGE_FIGURE_DUPLICATE_ALT.dismissAll&&"IMAGE_FIGURE_DUPLICATE_ALT",developer:o.checks.IMAGE_FIGURE_DUPLICATE_ALT.developer||!1}):o.checks.IMAGE_PASS&&e.push({element:i,type:o.checks.IMAGE_PASS.type||"good",content:t.sprintf(o.checks.IMAGE_PASS.content||"IMAGE_PASS",n),dismiss:I(`FIGIMGPASS${c+n}`),dismissAll:!!o.checks.IMAGE_PASS.dismissAll&&"IMAGE_PASS",developer:o.checks.IMAGE_PASS.developer||!1})}else o.checks.IMAGE_PASS&&(i.closest('button, [role="button"]')||e.push({element:i,type:o.checks.IMAGE_PASS.type||"good",content:t.sprintf(o.checks.IMAGE_PASS.content||"IMAGE_PASS",n),dismiss:I(`IMAGEPASS${c+n}`),dismissAll:!!o.checks.IMAGE_PASS.dismissAll&&"IMAGE_PASS",developer:o.checks.IMAGE_PASS.developer||!1}));p?.toLowerCase()===s.toLowerCase()&&o.checks.DUPLICATE_TITLE&&e.push({element:i,type:o.checks.DUPLICATE_TITLE.type||"warning",content:t.sprintf(o.checks.DUPLICATE_TITLE.content||"DUPLICATE_TITLE"),inline:!0,dismiss:I(`ALTDUPLICATETITLE${n}`),dismissAll:!!o.checks.DUPLICATE_TITLE.dismissAll&&"DUPLICATE_TITLE",developer:o.checks.DUPLICATE_TITLE.developer||!1})}})),e}function Gn(e,o){const i=o.linkStopWords?[...t._("PARTIAL_ALT_STOPWORDS"),...o.linkStopWords.split(",").map((e=>e.trim()))]:t._("PARTIAL_ALT_STOPWORDS"),s=e=>e.replace(/[^\w\s./]/g,"").replace(/\s+/g," ").trim(),a=(e,t)=>{const n=e.replace(/\./g,"").toLowerCase();let o=null;return t.forEach((e=>{n.length===e.length&&n.indexOf(e.toLowerCase())>=0&&(o=e)})),o},l={};return O.Found.Links.forEach((c=>{const d=function(e){let t=e.getAttribute("href");return t=b(t).toLowerCase(),t.endsWith("/")&&(t=t.slice(0,-1)),t.replace(/^https?:\/\/(www\.)?/,"")}(c),p=r(c,n.Exclusions.LinkSpan),h=b(o.linkIgnoreStrings?p.replace(o.linkIgnoreStrings,""):p),m=(e=>{const n=[null,null,null,null];return n[0]=a(e,i),t._("CLICK").forEach((t=>(new RegExp(`\\b${t}\\b`,"i").test(e)&&(n[1]=t),!1))),["doi.org/","dl.acm.org/","link.springer.com/","pubmed.ncbi.nlm.nih.gov/","scholar.google.com/","ieeexplore.ieee.org/","researchgate.net/publication/","sciencedirect.com/science/article/"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[2]=t),!1))),["www.","http"].forEach((t=>(e.toLowerCase().startsWith(t)&&(n[3]=t),!1))),[".edu/",".com/",".net/",".org/",".us/",".ca/",".de/",".icu/",".uk/",".ru/",".info/",".top/",".xyz/",".tk/",".cn/",".ga/",".cf/",".nl/",".io/",".fr/",".pe/",".nz/",".pt/",".es/",".pl/",".ua/"].forEach((t=>(e.toLowerCase().indexOf(t)>=0&&(n[3]=t),!1))),n})(s(h)),y=1===h.length&&/[^a-zA-Z0-9]/g.test(h),E=h.match(/([<>↣↳←→↓«»↴]+)/),A=E?E[1]:null,v=c.getAttribute("title"),_="true"===c.getAttribute("aria-hidden"),L="-1"===c.getAttribute("tabindex"),T=c.querySelector(":scope [aria-labelledby], :scope [aria-label]")||c.getAttribute("aria-labelledby")||c.getAttribute("aria-label"),x=c.querySelector(":scope [aria-labelledby]")||c.getAttribute("aria-labelledby"),N=t._("NEW_WINDOW_PHRASES").some((e=>h.toLowerCase().includes(e)||f(c).toLowerCase().includes(e))),k=t._("CLICK").some((e=>new RegExp(`\\b${e}\\b`,"i").test(c.textContent))),S=["pdf","doc","docx","word","mp3","ppt","text","pptx","txt","exe","dmg","rtf","windows","macos","csv","xls","xlsx","mp4","mov","avi","zip"].concat(t._("FILE_TYPE_PHRASES")).some((e=>h.toLowerCase().includes(e)||f(c).toLowerCase().includes(e))),w=c.matches("\n          a[href$='.pdf'],\n          a[href$='.doc'],\n          a[href$='.docx'],\n          a[href$='.zip'],\n          a[href$='.mp3'],\n          a[href$='.txt'],\n          a[href$='.exe'],\n          a[href$='.dmg'],\n          a[href$='.rtf'],\n          a[href$='.pptx'],\n          a[href$='.ppt'],\n          a[href$='.xls'],\n          a[href$='.xlsx'],\n          a[href$='.csv'],\n          a[href$='.mp4'],\n          a[href$='.mov'],\n          a[href$='.avi']\n        "),O=h.replace(/'|"|-|\.|\s+/g,"").toLowerCase();if(!c.querySelectorAll("img").length){if(_)L||o.checks.HIDDEN_FOCUSABLE&&e.push({element:c,type:o.checks.HIDDEN_FOCUSABLE.type||"error",content:t.sprintf(o.checks.HIDDEN_FOCUSABLE.content||"HIDDEN_FOCUSABLE"),inline:!0,position:"afterend",dismiss:I(`LINKHIDDENFOCUS${d+O}`),dismissAll:!!o.checks.HIDDEN_FOCUSABLE.dismissAll&&"LINK_HIDDEN_FOCUSABLE",developer:o.checks.HIDDEN_FOCUSABLE.developer||!0});else if(!d&&""!==d||0!==h.length)if(null!==m[0])o.checks.LINK_STOPWORD&&e.push({element:c,type:o.checks.LINK_STOPWORD.type||"error",content:o.checks.LINK_STOPWORD.content?t.sprintf(o.checks.LINK_STOPWORD.content,m[0]):t.sprintf("LINK_STOPWORD",m[0])+t.sprintf("LINK_TIP"),inline:!0,position:"afterend",dismiss:I(`LINKSTOPWORD${d+O}`),dismissAll:!!o.checks.LINK_STOPWORD.dismissAll&&"LINK_STOPWORD",developer:o.checks.LINK_STOPWORD.developer||!1});else if(null!==m[2])h.length>8&&o.checks.LINK_DOI&&e.push({element:c,type:o.checks.LINK_DOI.type||"warning",content:t.sprintf(o.checks.LINK_DOI.content||"LINK_DOI"),inline:!0,dismiss:I(`LINKDOI${d+O}`),dismissAll:!!o.checks.LINK_DOI.dismissAll&&"LINK_DOI",developer:o.checks.LINK_DOI.developer||!1});else if(null!==m[3])h.length>(o.checks.LINK_URL.maxLength||40)&&o.checks.LINK_URL&&e.push({element:c,type:o.checks.LINK_URL.type||"warning",content:o.checks.LINK_URL.content?t.sprintf(o.checks.LINK_URL.content):t.sprintf("LINK_URL")+t.sprintf("LINK_TIP"),inline:!0,dismiss:I(`LINKURLNAME${d+O}`),dismissAll:!!o.checks.LINK_URL.dismissAll&&"LINK_URL",developer:o.checks.LINK_URL.developer||!1});else if(T){const r=u(h),l=g(c,n.Exclusions.LinkSpan),p=o.linkIgnoreStrings?f(l).replace(o.linkIgnoreStrings,""):f(l),m=s(p),b=a(m,i);o.checks.LINK_STOPWORD_ARIA&&null!==b?e.push({element:c,type:o.checks.LINK_STOPWORD_ARIA.type||"warning",content:o.checks.LINK_STOPWORD_ARIA.content?t.sprintf(o.checks.LINK_STOPWORD_ARIA.content,b,r):t.sprintf("LINK_STOPWORD_ARIA",b,r)+t.sprintf("LINK_TIP"),inline:!0,dismiss:I(`LINKSTOPWORDARIA${d+O}`),dismissAll:!!o.checks.LINK_STOPWORD_ARIA.dismissAll&&" LINK_STOPWORD_ARIA",developer:o.checks.LINK_STOPWORD_ARIA.developer||!1}):o.checks.LINK_LABEL&&e.push({element:c,type:o.checks.LINK_LABEL.type||"good",content:o.checks.LINK_LABEL.content?t.sprintf(o.checks.LINK_LABEL.content,r):`${t.sprintf("ACC_NAME",r)} ${t.sprintf("ACC_NAME_TIP")}`,inline:!0,position:"afterend",dismiss:I(`LINKGOOD${d+O}`),dismissAll:!!o.checks.LINK_LABEL.dismissAll&&"LINK_LABEL",developer:o.checks.LINK_LABEL.developer||!1});const y=C(c);o.checks.LABEL_IN_NAME&&y&&0!==c.textContent.length&&e.push({element:c,type:o.checks.LABEL_IN_NAME.type||"warning",content:t.sprintf(o.checks.LABEL_IN_NAME.content||"LABEL_IN_NAME",r),inline:!0,position:"afterend",dismiss:I(`LINKLABELNAME${d+O}`),dismissAll:!!o.checks.LABEL_IN_NAME.dismissAll&&"BTN_LABEL_IN_NAME",developer:o.checks.LABEL_IN_NAME.developer||!0})}else A?o.checks.LINK_SYMBOLS&&e.push({element:c,type:o.checks.LINK_SYMBOLS.type||"warning",content:t.sprintf(o.checks.LINK_SYMBOLS.content||"LINK_SYMBOLS",A),inline:!0,dismiss:I(`LINKSYMBOL${d+O}`),dismissAll:!!o.checks.LINK_SYMBOLS.dismissAll&&"LINK_SYMBOLS",developer:o.checks.LINK_SYMBOLS.developer||!1}):y&&o.checks.LINK_EMPTY&&e.push({element:c,type:o.checks.LINK_EMPTY.type||"error",content:t.sprintf(o.checks.LINK_EMPTY.content||"LINK_EMPTY"),inline:!0,position:"afterend",dismiss:I(`LINKCHAR${d}`),dismissAll:!!o.checks.LINK_EMPTY.dismissAll&&"LINK_EMPTY",developer:o.checks.LINK_EMPTY.developer||!1});else x?o.checks.LINK_EMPTY_LABELLEDBY&&e.push({element:c,type:o.checks.LINK_EMPTY_LABELLEDBY.type||"error",content:t.sprintf(o.checks.LINK_EMPTY_LABELLEDBY.content||"LINK_EMPTY_LABELLEDBY"),inline:!0,position:"afterend",dismiss:I(`LINKEMPTYLABELLEDBY${d}`),dismissAll:!!o.checks.LINK_EMPTY_LABELLEDBY.dismissAll&&"LINK_EMPTY_LABELLEDBY",developer:o.checks.LINK_EMPTY_LABELLEDBY.developer||!0}):c.children.length?o.checks.LINK_EMPTY_NO_LABEL&&e.push({element:c,type:o.checks.LINK_EMPTY_NO_LABEL.type||"error",content:t.sprintf(o.checks.LINK_EMPTY_NO_LABEL.content||"LINK_EMPTY_NO_LABEL"),inline:!0,position:"afterend",dismiss:I(`LINKEMPTYNOLABEL${d}`),dismissAll:!!o.checks.LINK_EMPTY_NO_LABEL.dismissAll&&"LINK_EMPTY_NO_LABEL",developer:o.checks.LINK_EMPTY_NO_LABEL.developer||!1}):o.checks.LINK_EMPTY&&e.push({element:c,type:o.checks.LINK_EMPTY.type||"error",content:t.sprintf(o.checks.LINK_EMPTY.content||"LINK_EMPTY"),inline:!0,position:"afterend",dismiss:I(`LINKEMPTY${d}`),dismissAll:!!o.checks.LINK_EMPTY.dismissAll&&"LINK_EMPTY",developer:o.checks.LINK_EMPTY.developer||!1});(null!==m[1]||k)&&o.checks.LINK_CLICK_HERE&&e.push({element:c,type:o.checks.LINK_CLICK_HERE.type||"warning",content:o.checks.LINK_CLICK_HERE.content?t.sprintf(o.checks.LINK_CLICK_HERE.content):t.sprintf("LINK_CLICK_HERE")+t.sprintf("LINK_TIP"),inline:!0,dismiss:I(`LINKCLICKHERE${d+O}`),dismissAll:!!o.checks.LINK_CLICK_HERE.dismissAll&&"LINK_CLICK_HERE",developer:o.checks.LINK_CLICK_HERE.developer||!1}),0!==f(c).length&&v?.toLowerCase()===h.toLowerCase()&&o.checks.DUPLICATE_TITLE&&e.push({element:c,type:o.checks.DUPLICATE_TITLE.type||"warning",content:t.sprintf(o.checks.DUPLICATE_TITLE.content||"DUPLICATE_TITLE"),inline:!0,dismiss:I(`LINKDUPLICATETITLE${d+O}`),dismissAll:!!o.checks.DUPLICATE_TITLE.dismissAll&&"DUPLICATE_TITLE",developer:o.checks.DUPLICATE_TITLE.developer||!1})}if(o.linksAdvancedPlugin&&0!==O.length){if(l[O]&&!l[d]){if(o.checks.LINK_IDENTICAL_NAME){const n=u(h);e.push({element:c,type:o.checks.LINK_IDENTICAL_NAME.type||"warning",content:o.checks.LINK_IDENTICAL_NAME.content?t.sprintf(o.checks.LINK_IDENTICAL_NAME.content,n):`${t.sprintf("LINK_IDENTICAL_NAME",n)} ${t.sprintf("ACC_NAME_TIP")}`,inline:!0,dismiss:I(`LINKSEEN${d+O}`),dismissAll:!!o.checks.LINK_IDENTICAL_NAME.dismissAll&&"LINK_IDENTICAL_NAME",developer:o.checks.LINK_IDENTICAL_NAME.developer||!1})}}else l[O]=!0,l[d]=!0;"_blank"!==c.getAttribute("target")?.toLowerCase()||w||N||o.checks.LINK_NEW_TAB&&e.push({element:c,type:o.checks.LINK_NEW_TAB.type||"warning",content:t.sprintf(o.checks.LINK_NEW_TAB.content||"LINK_NEW_TAB"),inline:!0,dismiss:I(`LINKNEWTAB${d+O}`),dismissAll:!!o.checks.LINK_NEW_TAB.dismissAll&&"LINK_NEW_TAB",developer:o.checks.LINK_NEW_TAB.developer||!1}),w&&!S&&o.checks.LINK_FILE_EXT&&e.push({element:c,type:o.checks.LINK_FILE_EXT.type||"warning",content:t.sprintf(o.checks.LINK_FILE_EXT.content||"LINK_FILE_EXT"),inline:!0,dismiss:I(`LINKEXT${d+O}`),dismissAll:!!o.checks.LINK_FILE_EXT.dismissAll&&"LINK_FILE_EXT",developer:o.checks.LINK_FILE_EXT.developer||!1})}})),e}function Un(e,o){if(o.checks.QA_BAD_LINK&&O.Found.CustomErrorLinks.forEach((n=>{e.push({element:n,type:o.checks.QA_BAD_LINK.type||"error",content:t.sprintf(o.checks.QA_BAD_LINK.content||"QA_BAD_LINK",n),inline:!0,dismiss:I(n.tagName+n.textContent),dismissAll:!!o.checks.QA_BAD_LINK.dismissAll&&"QA_BAD_LINK",developer:o.checks.QA_BAD_LINK.developer||!1})})),o.checks.QA_STRONG_ITALICS&&O.Found.StrongItalics.forEach((n=>{const i=f(n);0!==i.length&&i.length>400&&e.push({element:n.parentNode,type:o.checks.QA_STRONG_ITALICS.type||"warning",content:t.sprintf(o.checks.QA_STRONG_ITALICS.content||"QA_STRONG_ITALICS"),dismiss:I(n.tagName+n.textContent),dismissAll:!!o.checks.QA_STRONG_ITALICS.dismissAll&&"QA_STRONG_ITALICS",developer:o.checks.QA_STRONG_ITALICS.developer||!1})})),O.Found.Links.forEach((i=>{if(i.hasAttribute("href")){const s=i.getAttribute("href"),a=i.matches(n.Global.documentSources),r=i.matches('a[href$=".pdf"], a[href*=".pdf?"]');if(o.checks.QA_IN_PAGE_LINK){const n="button"===i.getAttribute("role")||i.hasAttribute("aria-haspopup")||i.hasAttribute("aria-expanded")||i.hasAttribute("onclick"),a=0!==f(i).length;if((s.startsWith("#")||""===s)&&!n&&a){const n=s.substring(1),a=i.getAttribute("aria-controls");document.getElementById(n)||document.getElementById(decodeURIComponent(n))||document.getElementById(encodeURIComponent(n))||document.getElementById(a)||document.querySelector(`a[name="${n}"]`)||e.push({element:i,type:o.checks.QA_IN_PAGE_LINK.type||"error",content:t.sprintf(o.checks.QA_IN_PAGE_LINK.content||"QA_IN_PAGE_LINK"),inline:!0,dismiss:I(`QAINPAGE${s}`),dismissAll:!!o.checks.QA_IN_PAGE_LINK.dismissAll&&"QA_IN_PAGE_LINK",developer:o.checks.QA_IN_PAGE_LINK.developer||!1})}}o.checks.QA_DOCUMENT&&a?e.push({element:i,type:o.checks.QA_DOCUMENT.type||"warning",content:t.sprintf(o.checks.QA_DOCUMENT.content||"QA_DOCUMENT"),inline:!0,dismiss:I(`DOC${s}`),dismissAll:!!o.checks.QA_DOCUMENT.dismissAll&&"QA_DOCUMENT",developer:o.checks.QA_DOCUMENT.developer||!1}):o.checks.QA_PDF&&r&&e.push({element:i,type:o.checks.QA_PDF.type||"warning",content:t.sprintf(o.checks.QA_PDF.content||"QA_PDF"),inline:!0,dismiss:I(`PDF${s}`),dismissAll:!!o.checks.QA_PDF.dismissAll&&"QA_PDF",developer:o.checks.QA_PDF.developer||!1})}})),o.checks.QA_BLOCKQUOTE&&O.Found.Blockquotes.forEach((n=>{const i=f(n);if(0!==i.length&&i.length<25){const s=u(i);e.push({element:n,type:o.checks.QA_BLOCKQUOTE.type||"warning",content:t.sprintf(o.checks.QA_BLOCKQUOTE.content||"QA_BLOCKQUOTE",s),dismiss:I(`BLOCKQUOTE${s}`),dismissAll:!!o.checks.QA_BLOCKQUOTE.dismissAll&&"QA_BLOCKQUOTE",developer:o.checks.QA_BLOCKQUOTE.developer||!1})}})),O.Found.Tables.forEach((n=>{if(!1===d(n)){const i=n.querySelectorAll("th"),s=n.querySelectorAll("h1, h2, h3, h4, h5, h6"),a=I(`TABLE${n.textContent}`);o.checks.TABLES_MISSING_HEADINGS&&0===i.length&&e.push({element:n,type:o.checks.TABLES_MISSING_HEADINGS.type||"error",content:t.sprintf(o.checks.TABLES_MISSING_HEADINGS.content||"TABLES_MISSING_HEADINGS"),dismiss:a,dismissAll:!!o.checks.TABLES_MISSING_HEADINGS.dismissAll&&"TABLES_MISSING_HEADINGS",developer:o.checks.TABLES_MISSING_HEADINGS.developer||!1}),o.checks.TABLES_SEMANTIC_HEADING&&s.length>0&&s.forEach((n=>{e.push({element:n,type:o.checks.TABLES_SEMANTIC_HEADING.type||"error",content:t.sprintf(o.checks.TABLES_SEMANTIC_HEADING.content||"TABLES_SEMANTIC_HEADING"),dismiss:a,dismissAll:!!o.checks.TABLES_SEMANTIC_HEADING.dismissAll&&"TABLES_SEMANTIC_HEADING",developer:o.checks.TABLES_SEMANTIC_HEADING.developer||!1})})),i.forEach((n=>{o.checks.TABLES_EMPTY_HEADING&&0===n.textContent.trim().length&&e.push({element:n,type:o.checks.TABLES_EMPTY_HEADING.type||"error",content:t.sprintf(o.checks.TABLES_EMPTY_HEADING.content||"TABLES_EMPTY_HEADING"),position:"afterbegin",dismiss:a,dismissAll:!!o.checks.TABLES_EMPTY_HEADING.dismissAll&&"TABLES_EMPTY_HEADING",developer:o.checks.TABLES_EMPTY_HEADING.developer||!1})}))}})),o.checks.QA_FAKE_HEADING){const n=(n,i)=>{e.push({element:n,type:o.checks.QA_FAKE_HEADING.type||"warning",content:t.sprintf(o.checks.QA_FAKE_HEADING.content||"QA_FAKE_HEADING",i),dismiss:I(`BOLD${i}`),dismissAll:!!o.checks.QA_FAKE_HEADING.dismissAll&&"QA_FAKE_HEADING",developer:o.checks.QA_FAKE_HEADING.developer||!1})},i=e=>{const t=e.previousElementSibling;if(!t)return!1;return["H1","H2","H3","H4","H5","H6"].includes(t.tagName)},s='h1, h2, h3, h4, h5, h6, [role="heading"][aria-level], blockquote, table',a=e=>{const t=getComputedStyle(e).fontSize.replace("px",""),o=f(e),a=null===o.match(/[.;?!"]/),r=o.length>=4&&o.length<=120;if(t>=24&&!e.closest(s)&&r&&a&&!i(e)){const t=u(o);n(e,t)}},r=e=>{if(/^(<strong>|<b>)/i.test(e.innerHTML.trim())&&!e.closest(s)){const t=e.querySelector("strong, b"),o=f(t),i=null===o.match(/[.:;?!"']/);if(o.length>=3&&o.length<=120&&i){const i=g(e,["strong","b"]).textContent.trim().length;if(0!==i&&i<=250)return;const s=u(o);n(t,s)}}};O.Found.Paragraphs.forEach((e=>{a(e),r(e)}))}if(o.checks.QA_FAKE_LIST){const n=new RegExp(/(([023456789][\d\s])|(1\d))/,""),i=new RegExp(/(^[aA1αаΑ]|[^\p{Alphabetic}\s])[-\s.)]/,"u"),s=new RegExp(/\p{Extended_Pictographic}/,"u"),a=["a","A","α","Α","а","А","1"],r=/[([{#]/,l={2:"1",b:"a",B:"A","β":"α","Β":"Α","б":"а","Б":"А"},c=e=>e.replace(/^b|^B|^б|^Б|^β|^В|^2/,(e=>l[e]));let d="",p="",u=!1;O.Found.Paragraphs.forEach(((l,h)=>{let m=!1,g=!1;p=p||f(l).replace("(","");const b=p.substring(0,2),y=b.match(i),E=b.match(n),A=b.match(s),v=r.test(b.charAt(0));if(b.length>0&&b!==d&&!E&&(y||A||v)){const n=O.Found.Paragraphs[h+1];if(n){if(m=f(n).replace("(","").substring(0,2),a.includes(m?.toLowerCase().trim()))return;const e=c(m);y?"A "!==b&&b===e&&(g=!0):A&&!u&&e.match(s)&&(g=!0,u=!0)}if(!g){let e=l?.querySelector("br")?.nextSibling?.nodeValue;if(e){e=e.replace(/<\/?[^>]+(>|$)/g,"").trim().substring(0,2);(r.test(e.charAt(0))||b===c(e)||!u&&e.match(s))&&(g=!0)}}g?(e.push({element:l,type:o.checks.QA_FAKE_LIST.type||"warning",content:t.sprintf(o.checks.QA_FAKE_LIST.content||"QA_FAKE_LIST",b),dismiss:I(`LIST${l.textContent}`),dismissAll:!!o.checks.QA_FAKE_LIST.dismissAll&&"QA_FAKE_LIST",developer:o.checks.QA_FAKE_LIST.developer||!1}),d=b):d=""}p=m?"":m}))}if(o.checks.QA_UPPERCASE){const n=n=>{let i="";"LI"===n.tagName?n.childNodes.forEach((e=>{3===e.nodeType&&(i+=e.textContent)})):i=f(n);const s=i.match(/([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,})/g);s&&s[0].length>10&&e.push({element:n,type:o.checks.QA_UPPERCASE.type||"warning",content:t.sprintf(o.checks.QA_UPPERCASE.content||"QA_UPPERCASE"),dismiss:I(`UPPERCASE${i}`),dismissAll:!!o.checks.QA_UPPERCASE.dismissAll&&"QA_UPPERCASE",developer:o.checks.QA_UPPERCASE.developer||!1})};O.Found.Paragraphs.forEach((e=>n(e))),O.Found.Headings.forEach((e=>n(e))),O.Found.Lists.forEach((e=>n(e))),O.Found.Blockquotes.forEach((e=>n(e)))}const i=n=>{const i=getComputedStyle(n),{textDecorationLine:s,textAlign:a,fontSize:r}=i;!o.checks.QA_UNDERLINE||"underline"!==s||n.closest("[onclick]")||n.closest("a[href]")||n.closest("ABBR")||(n=>{e.push({element:n,type:o.checks.QA_UNDERLINE.type||"warning",content:t.sprintf(o.checks.QA_UNDERLINE.content||"QA_UNDERLINE"),inline:!0,dismiss:I(`UNDERLINE${n.textContent}`),dismissAll:!!o.checks.QA_UNDERLINE.dismissAll&&"QA_UNDERLINE",developer:o.checks.QA_UNDERLINE.developer||!1})})(n);const l=o.checks.QA_SMALL_TEXT.fontSize||10,c=parseFloat(r),d=!((n.parentElement?parseFloat(getComputedStyle(n.parentElement).fontSize):null)===c)&&c>1&&c<=l;o.checks.QA_SMALL_TEXT&&d&&(n=>{e.push({element:n,type:o.checks.QA_SMALL_TEXT.type||"warning",content:t.sprintf(o.checks.QA_SMALL_TEXT.content||"QA_SMALL_TEXT"),dismiss:I(`SMALL${n.textContent}`),dismissAll:!!o.checks.QA_SMALL_TEXT.dismissAll&&"QA_SMALL_TEXT",developer:o.checks.QA_SMALL_TEXT.developer||!1})})(n);const p=(n.parentElement?getComputedStyle(n.parentElement).textAlign:null)===a;o.checks.QA_JUSTIFY&&"justify"===a&&!p&&(n=>{e.push({element:n,type:o.checks.QA_JUSTIFY.type||"warning",content:t.sprintf(o.checks.QA_JUSTIFY.content||"QA_JUSTIFY"),dismiss:I(`JUSTIFIED${n.textContent}`),dismissAll:!!o.checks.QA_JUSTIFY.dismissAll&&"QA_JUSTIFY",developer:o.checks.QA_JUSTIFY.developer||!1})})(n)};if(o.checks.QA_UNDERLINE||o.checks.QA_JUSTIFY||o.checks.QA_SMALL_TEXT)for(let e=0;e<O.Found.Everything.length;e++){const t=O.Found.Everything[e];0!==Array.from(t.childNodes).filter((e=>3===e.nodeType)).map((e=>e.textContent)).join("").trim().length&&i(t)}return o.checks.QA_SUBSCRIPT&&O.Found.Subscripts.forEach((n=>{const i=f(n);i.length>=80&&e.push({element:n,type:o.checks.QA_SUBSCRIPT.type||"warning",content:t.sprintf(o.checks.QA_SUBSCRIPT.content||"QA_SUBSCRIPT"),inline:!0,dismiss:I(n.tagName+i),dismissAll:!!o.checks.QA_SUBSCRIPT.dismissAll&&"QA_SUBSCRIPT",developer:o.checks.QA_SUBSCRIPT.developer||!1})})),o.checks.QA_NESTED_COMPONENTS&&O.Found.NestedComponents.forEach((n=>{const i=o.checks.QA_NESTED_COMPONENTS.sources||'[role="tablist"], details';n.querySelector(i)&&e.push({element:n,type:o.checks.QA_NESTED_COMPONENTS.type||"warning",content:t.sprintf(o.checks.QA_NESTED_COMPONENTS.content||"QA_NESTED_COMPONENTS"),dismiss:I(`NESTED${n.textContent}`),dismissAll:!!o.checks.QA_NESTED_COMPONENTS.dismissAll&&"QA_NESTED_COMPONENTS",developer:o.checks.QA_NESTED_COMPONENTS.developer||!1})})),e}class Hn{constructor(i){const s={...e,...i,checks:{...e.checks,...i.checks}};this.initialize=()=>{var e;(()=>{const{doNotRun:e}=s;return e.trim().length>0&&document.querySelector(e)})()||(customElements.define("sa11y-heading-label",wn),customElements.define("sa11y-heading-anchor",Sn),customElements.define("sa11y-annotation",Nn),customElements.define("sa11y-tooltips",Tn),customElements.define("sa11y-panel-tooltips",xn),customElements.define("sa11y-control-panel",Q),customElements.define("sa11y-console-error",z),n.initializeGlobal(s),n.initializeReadability(s),n.initializeExclusions(s),s.developerChecksOnByDefault&&(null===v.getItem("sa11y-developer")||s.checkAllHideToggles)&&v.setItem("sa11y-developer","On"),e=()=>{if(s.headless)this.checkAll(),v.removeItem("sa11y-dismissed");else{const i=v.getItem("sa11y-position"),{panelPosition:a}=s;!s.showMovePanelToggle||i&&!i.includes("top")==!a.includes("top")||v.setItem("sa11y-position",a);const r=new Q;document.body.appendChild(r),function(e,o){n.Global.showMovePanelToggle&&(n.Panel.movePanelToggle.onclick=async()=>{const e=v.getItem("sa11y-position"),[t,o]=e.includes("top")?["top-right","top-left"]:["right","left"],i=e===t?o:t;v.setItem("sa11y-position",i),[t,o].forEach((e=>{n.Panel.toggle.classList.replace(e,i),n.Panel.panel.classList.replace(e,i)})),n.Panel.movePanelToggle.setAttribute("aria-pressed",e===t?"true":"false")}),n.Global.developerPlugin?n.Panel.developerToggle.onclick=async()=>{"On"===v.getItem("sa11y-developer")?(v.setItem("sa11y-developer","Off"),n.Panel.developerToggle.textContent=`${t._("OFF")}`,n.Panel.developerToggle.setAttribute("aria-pressed","false"),o(!1),await e()):(v.setItem("sa11y-developer","On"),n.Panel.developerToggle.textContent=`${t._("ON")}`,n.Panel.developerToggle.setAttribute("aria-pressed","true"),o(!1),await e())}:v.setItem("sa11y-developer","Off"),n.Readability.Plugin&&(n.Panel.readabilityToggle.onclick=async()=>{"On"===v.getItem("sa11y-readability")?(v.setItem("sa11y-readability","Off"),n.Panel.readabilityToggle.textContent=`${t._("OFF")}`,n.Panel.readabilityToggle.setAttribute("aria-pressed","false"),n.Panel.readability.classList.remove("active"),o(!1),await e()):(v.setItem("sa11y-readability","On"),n.Panel.readabilityToggle.textContent=`${t._("ON")}`,n.Panel.readabilityToggle.setAttribute("aria-pressed","true"),n.Panel.readability.classList.add("active"),o(!1),await e())},"On"===v.getItem("sa11y-readability")&&n.Panel.readability.classList.add("active"));const i=window.matchMedia("(prefers-color-scheme: dark)"),{themeToggle:s}=n.Panel,{html:a}=n.Global,r=e=>{a.setAttribute("data-sa11y-theme",e),v.setItem("sa11y-theme",e);const t=s.querySelector("span").classList;t.toggle("moon-icon","light"===e),t.toggle("sun-icon","dark"===e),s.setAttribute("aria-pressed","dark"===e?"true":"false")},l=v.getItem("sa11y-theme")||(i.matches?"dark":"light");r(l),i.addEventListener("change",(()=>{r(i.matches?"dark":"light")})),s.onclick=()=>{const e=v.getItem("sa11y-theme")||(i.matches?"dark":"light");r("dark"===e?"light":"dark")},n.Global.colourFilterPlugin&&n.Panel.colourFilterSelect.addEventListener("change",(async()=>{const i=parseInt(n.Panel.colourFilterSelect.value,10),s=["protanopia","deuteranopia","tritanopia","monochromacy"],a=[t._("RED_EYE"),t._("GREEN_EYE"),t._("BLUE_EYE"),t._("MONO_EYE")];i>=1&&i<=4?window.matchMedia("(forced-colors: active)").matches?T(t._("COLOUR_FILTER_HIGH_CONTRAST")):(n.Root.areaToCheck.setAttribute("data-sa11y-filter",s[i-1]),n.Panel.colourFilterIcon.setAttribute("aria-label",a[i-1]),x(["data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow"],"document"),N(["sa11y-annotation","sa11y-tooltips","sa11y-heading-label"],"document"),n.Panel.skipButton.disabled=!0,n.Panel.pageIssues.classList.remove("active"),n.Panel.settingsContent.classList.add("hide-settings-border"),n.Panel.colourFilterSelect.classList.add("active"),n.Panel.colourPanel.classList.add("active"),n.Panel.colourPanel.setAttribute("data-colour",s[i-1]),n.Panel.content.hidden=!0):(n.Root.areaToCheck.removeAttribute("data-sa11y-filter"),n.Panel.settingsContent.classList.remove("hide-settings-border"),n.Panel.colourFilterSelect.classList.remove("active"),n.Panel.colourPanel.classList.remove("active"),n.Panel.colourPanel.removeAttribute("data-colour"),n.Panel.content.hidden=!1,o(!1),await e())}))}(this.checkAll,this.resetAll),function(){n.Panel.outlineToggle.addEventListener("click",(()=>{"true"===n.Panel.outlineToggle.getAttribute("aria-expanded")?j():(V(),J(),X()),n.Panel.outlineHeader.focus()})),"Opened"===v.getItem("sa11y-outline")&&V(),n.Global.showImageOutline&&(n.Panel.imagesToggle.addEventListener("click",(()=>{"true"===n.Panel.imagesToggle.getAttribute("aria-expanded")?X():(q(),j(),J()),n.Panel.imagesHeader.focus()})),"Opened"===v.getItem("sa11y-images")&&q()),n.Panel.settingsToggle.addEventListener("click",(()=>{"true"===n.Panel.settingsToggle.getAttribute("aria-expanded")?J():(Z(),j(),X()),n.Panel.settingsHeader.focus()})),"Opened"===v.getItem("sa11y-settings")&&Z(),n.Panel.skipToPageIssues.addEventListener("click",(()=>{n.Panel.pageIssuesHeader.focus()}));const e=n.Panel.panel.querySelectorAll("[role=tab]");let t=Array.from(e).findIndex((e=>e.classList.contains("active")));e.forEach((n=>{n.addEventListener("keydown",(n=>{"ArrowRight"===n.key?(n.preventDefault(),t=(t+1)%e.length,e[t].focus()):"ArrowLeft"===n.key&&(n.preventDefault(),t=(t-1+e.length)%e.length,e[t].focus())}))}))}(),function(){if(n.Global.colourFilterPlugin&&!1===n.Global.headless){const e=document.createElement("div");e.id="sa11y-colour-filters",e.setAttribute("aria-hidden","true"),e.innerHTML='\n        \x3c!-- DaltonLens SVG filters to simulate color vision deficiencies --\x3e\n        <svg id="sa11y-svg-filters" xmlns="http://www.w3.org/2000/svg">\n          <filter id="sa11y-protanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.10889,0.89111,-0.00000,0,0\n                0.10889,0.89111,0.00000,0,0\n                0.00447,-0.00447,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-deuteranopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" values="\n                0.29031,0.70969,-0.00000,0,0\n                0.29031,0.70969,-0.00000,0,0\n                -0.02197,0.02197,1.00000,0,0\n                0,0,0,1,0"\n            />\n          </filter>\n          <filter id="sa11y-tritanopia" color-interpolation-filters="linearRGB">\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane1" values="\n                1.01354, 0.14268, -0.15622, 0, 0\n                -0.01181, 0.87561, 0.13619, 0, 0\n                0.07707, 0.81208, 0.11085, 0, 0\n                7.92482, -5.66475, -2.26007, 1, -0.2"\n            />\n            <feComponentTransfer in="ProjectionOnPlane1" result="ProjectionOnPlane1">\n                <feFuncA type="discrete" tableValues="0 0 0 0 1"/>\n            </feComponentTransfer>\n            <feColorMatrix type="matrix" in="SourceGraphic" result="ProjectionOnPlane2" values="\n                0.93337, 0.19999, -0.13336, 0, 0\n                0.05809, 0.82565, 0.11626, 0, 0\n                -0.37923, 1.13825, 0.24098, 0, 0\n                0,0,0,1,0"\n            />\n            <feBlend in="ProjectionOnPlane1" in2="ProjectionOnPlane2" mode="normal"/>\n          </filter>\n          <filter id="sa11y-monochromacy">\n            <feColorMatrix values="0.299,0.587,0.114,0,0,0.299,0.587,0.114,0,0,0.299,0.587,0.114,0,0,0,0,0,1,0"></feColorMatrix>\n          </filter>\n        </svg>',document.body.appendChild(e)}}(),R(s.detectSPArouting,this.checkAll,this.resetAll),this.panelTooltips=new xn,document.body.appendChild(this.panelTooltips),n.Panel.toggle.disabled=!1,setTimeout((()=>{this.resetAll(),this.checkAll()}),s.delayCheck),s.delayCheck>=700&&(n.Panel.toggle.disabled=!0),e=this.checkAll,o=this.resetAll,n.Panel.toggle.addEventListener("click",(t=>{"Opened"===v.getItem("sa11y-panel")?(t.preventDefault(),v.setItem("sa11y-panel","Closed"),n.Panel.toggle.classList.remove("on"),n.Panel.toggle.setAttribute("aria-expanded","false"),o(),0===n.Panel.notifCount.innerHTML.trim().length?n.Panel.notifBadge.style.display="none":n.Panel.notifBadge.style.display="flex"):(t.preventDefault(),v.setItem("sa11y-panel","Opened"),n.Panel.toggle.classList.add("on"),n.Panel.toggle.setAttribute("aria-expanded","true"),e(),k(n.Panel.outlineList,n.Panel.outlineContent))})),"Opened"===v.getItem("sa11y-panel")&&(n.Panel.toggle.classList.add("on"),n.Panel.toggle.setAttribute("aria-expanded","true"),n.Panel.panel.style.transform=""),document.onkeydown=e=>{const t=e||window.event;t.altKey&&"KeyA"===t.code&&(n.Panel.toggle.click(),n.Panel.toggle.focus())}}var e,o},"complete"===document.readyState?e():window.addEventListener("load",e))},this.checkAll=async(e=s.checkRoot,o=s.readabilityRoot)=>{try{this.results=[],this.headingOutline=[],this.imageOutline=[],this.errorCount=0,this.warningCount=0,this.customChecksRunning=!1;document.querySelector(e)||!1!==s.headless||T(`${t.sprintf("MISSING_ROOT",e)}`),n.initializeRoot(e,o),function(e){if(e.autoDetectShadowComponents){const t=n.Exclusions.Sa11yElements,o=document.querySelector(e.checkRoot);(o?Array.from(o.querySelectorAll(`*:not(${t})`)):Array.from(document.body.querySelectorAll(`*:not(${t})`))).forEach((e=>{e.shadowRoot&&"open"===e.shadowRoot.mode&&(e.setAttribute("data-sa11y-has-shadow-root",""),P(e))}))}else e.shadowComponents&&document.querySelectorAll(e.shadowComponents).forEach((e=>{e.setAttribute("data-sa11y-has-shadow-root",""),P(e)}))}(s),O.initializeElements(s),function(e,o,i){let s,a="";O.Found.Headings.forEach(((c,d)=>{const p=r(c,n.Exclusions.HeaderSpan),h=b(o.headerIgnoreStrings?p.replace(o.headerIgnoreStrings,""):p),m=u(h),g=n.Root.areaToCheck.contains(c),f=n.Root.areaToCheck.contains(c.getRootNode().host),A=g||f,v=parseInt(c.getAttribute("aria-level")||c.tagName.slice(1),10),_=h.length,L=o.checks.HEADING_LONG.maxLength||160;let T=null,x=null,N=null,k=null;if(v-s>1&&0!==d)o.checks.HEADING_SKIPPED_LEVEL&&(T=o.checks.HEADING_SKIPPED_LEVEL.type||"error",x=t.sprintf(o.checks.HEADING_SKIPPED_LEVEL.content||"HEADING_SKIPPED_LEVEL",s,v,y(m,60),y(a,60),s+1),N=o.checks.HEADING_SKIPPED_LEVEL.developer||!1,k=!!o.checks.HEADING_SKIPPED_LEVEL.dismissAll&&"HEADING_SKIPPED_LEVEL");else if(0===_)if(c.querySelectorAll("img").length){const e=c.querySelector("img")?.getAttribute("alt");!c.querySelector("img")||e&&""!==e.trim()||o.checks.HEADING_EMPTY_WITH_IMAGE&&(T=o.checks.HEADING_EMPTY_WITH_IMAGE.type||"error",x=t.sprintf(o.checks.HEADING_EMPTY_WITH_IMAGE.content||"HEADING_EMPTY_WITH_IMAGE",v),N=o.checks.HEADING_EMPTY_WITH_IMAGE.developer||!1,k=!!o.checks.HEADING_EMPTY_WITH_IMAGE.dismissAll&&"HEADING_EMPTY_WITH_IMAGE")}else o.checks.HEADING_EMPTY&&(T=o.checks.HEADING_EMPTY.type||"error",x=t.sprintf(o.checks.HEADING_EMPTY.content||"HEADING_EMPTY",v),N=o.checks.HEADING_EMPTY.developer||!1,k=!!o.checks.HEADING_EMPTY.dismissAll&&"HEADING_EMPTY");else 0===d&&1!==v&&2!==v?o.checks.HEADING_FIRST&&(T=o.checks.HEADING_FIRST.type||"error",x=t.sprintf(o.checks.HEADING_FIRST.content||"HEADING_FIRST"),N=o.checks.HEADING_FIRST.developer||!1,k=!!o.checks.HEADING_FIRST.dismissAll&&"HEADING_FIRST"):_>L&&o.checks.HEADING_LONG&&(T=o.checks.HEADING_LONG.type||"warning",x=t.sprintf(o.checks.HEADING_LONG.content||"HEADING_LONG",L,_),N=o.checks.HEADING_LONG.developer||!1,k=!!o.checks.HEADING_LONG.dismissAll&&"HEADING_LONG");x&&T&&e.push({element:c,type:T,content:x,dismiss:I(`H${v+m}`),dismissAll:k,isWithinRoot:A,developer:N}),s=v,a=m;const S=l(c),w=E(c,"display","none");i.push({element:c,headingLevel:v,text:m,index:d,type:T,hidden:S,visibleParent:w,dismiss:I(`H${v+m}`),isWithinRoot:A})})),o.checks.HEADING_MISSING_ONE&&0===O.Found.HeadingOne.length&&e.push({type:o.checks.HEADING_MISSING_ONE.type||"warning",content:t.sprintf(o.checks.HEADING_MISSING_ONE.content||"HEADING_MISSING_ONE"),dismiss:"MISSINGH1",developer:o.checks.HEADING_MISSING_ONE.developer||!1})}(this.results,s,this.headingOutline),Gn(this.results,s),$n(this.results,s),function(e,n){n.formLabelsPlugin&&O.Found.Inputs.forEach((o=>{const i="true"===o.getAttribute("aria-hidden"),s="-1"===o.getAttribute("tabindex");if(d(o)||i&&s)return;const a=b(r(o)),l=o.getAttribute("alt"),c=o.getAttribute("type"),p=o.getAttribute("title"),h=o.getAttribute("aria-label")||o.getAttribute("aria-labelledby");if("submit"===c||"button"===c||"hidden"===c)return;if("image"===c)return void(!n.checks.LABELS_MISSING_IMAGE_INPUT||l&&""!==l.trim()||h||p||e.push({element:o,type:n.checks.LABELS_MISSING_IMAGE_INPUT.type||"error",content:t.sprintf(n.checks.LABELS_MISSING_IMAGE_INPUT.content||"LABELS_MISSING_IMAGE_INPUT"),dismiss:I(`INPUTIMAGE${c+a}`),dismissAll:!!n.checks.LABELS_MISSING_IMAGE_INPUT.dismissAll&&"LABELS_MISSING_IMAGE_INPUT",developer:n.checks.LABELS_MISSING_IMAGE_INPUT.developer||!0}));if("reset"===c)return void(n.checks.LABELS_INPUT_RESET&&e.push({element:o,type:n.checks.LABELS_INPUT_RESET.type||"warning",content:t.sprintf(n.checks.LABELS_INPUT_RESET.content||"LABELS_INPUT_RESET"),dismiss:I(`INPUTRESET${c+a}`),dismissAll:!!n.checks.LABELS_INPUT_RESET.dismissAll&&"LABELS_INPUT_RESET",developer:n.checks.LABELS_INPUT_RESET.developer||!1}));if(h||p){if(0===a.length)n.checks.LABELS_MISSING_LABEL&&e.push({element:o,type:n.checks.LABELS_MISSING_LABEL.type||"error",content:t.sprintf(n.checks.LABELS_MISSING_LABEL.content||"LABELS_MISSING_LABEL"),dismiss:I(`INPUTMISSING${c+a}`),dismissAll:!!n.checks.LABELS_MISSING_LABEL.dismissAll&&"LABELS_MISSING_LABEL",developer:n.checks.LABELS_MISSING_LABEL.developer||!0});else if(n.checks.LABELS_ARIA_LABEL_INPUT){const i=u(a);e.push({element:o,type:n.checks.LABELS_ARIA_LABEL_INPUT.type||"warning",content:n.checks.LABELS_ARIA_LABEL_INPUT.content?t.sprintf(n.checks.LABELS_ARIA_LABEL_INPUT.content,i):`${t.sprintf("LABELS_ARIA_LABEL_INPUT",i)} ${t.sprintf("ACC_NAME_TIP")}`,dismiss:I(`INPUTARIA${c+a}`),dismissAll:!!n.checks.LABELS_ARIA_LABEL_INPUT.dismissAll&&"LABELS_ARIA_LABEL_INPUT",developer:n.checks.LABELS_ARIA_LABEL_INPUT.developer||!0})}return}const m=o.closest("label"),g=m?b(r(m)):"";if(m&&g.length)return;const f=o.getAttribute("id");f?O.Found.Labels.some((e=>e.getAttribute("for")===f))||n.checks.LABELS_NO_FOR_ATTRIBUTE&&e.push({element:o,type:n.checks.LABELS_NO_FOR_ATTRIBUTE.type||"error",content:t.sprintf(n.checks.LABELS_NO_FOR_ATTRIBUTE.content||"LABELS_NO_FOR_ATTRIBUTE",f),dismiss:I(`INPUTNOFOR${c+a}`),dismissAll:!!n.checks.LABELS_NO_FOR_ATTRIBUTE.dismissAll&&"LABELS_NO_FOR_ATTRIBUTE",developer:n.checks.LABELS_NO_FOR_ATTRIBUTE.developer||!0}):n.checks.LABELS_MISSING_LABEL&&e.push({element:o,type:n.checks.LABELS_MISSING_LABEL.type||"error",content:t.sprintf(n.checks.LABELS_MISSING_LABEL.content||"LABELS_MISSING_LABEL"),dismiss:I(`INPUTNOID${c+a}`),dismissAll:!!n.checks.LABELS_MISSING_LABEL.dismissAll&&"LABELS_MISSING_LABEL",developer:n.checks.LABELS_MISSING_LABEL.developer||!0}),o.placeholder&&0!==o.placeholder&&e.push({element:o,type:n.checks.LABELS_PLACEHOLDER.type||"warning",content:t.sprintf(n.checks.LABELS_PLACEHOLDER.content||"LABELS_PLACEHOLDER"),dismiss:I(`INPUTPLACEHOLDER${c+a}`),dismissAll:!!n.checks.LABELS_PLACEHOLDER.dismissAll&&"LABELS_PLACEHOLDER",developer:n.checks.LABELS_PLACEHOLDER.developer||!0})}))}(this.results,s),Un(this.results,s),function(e,o){if(o.checks.META_LANG&&(!O.Found.Language||O.Found.Language.length<2)&&e.push({type:o.checks.META_LANG.type||"error",content:t.sprintf(o.checks.META_LANG.content||"META_LANG"),dismiss:I("LANG"),developer:o.checks.META_LANG.developer||!0}),o.checks.META_TITLE){const n=document.querySelector("title:not(svg title)");n&&0!==n.textContent.trim().length||e.push({type:o.checks.META_TITLE.type||"error",content:t.sprintf(o.checks.META_TITLE.content||"META_TITLE"),dismiss:I("TITLE"),developer:o.checks.META_TITLE.developer||!0})}if(o.checks.META_SCALABLE||o.checks.META_MAX){const n=document.querySelector('meta[name="viewport"]');if(n){const i=n.getAttribute("content");if(i){const n=i.split(",").reduce(((e,t)=>{const[n,o]=t.split("=").map((e=>e.trim()));return e[n]=o,e}),{});!o.checks.META_SCALABLE||"no"!==n["user-scalable"]&&"0"!==n["user-scalable"]||e.push({type:o.checks.META_SCALABLE.type||"error",content:t.sprintf(o.checks.META_SCALABLE.content||"META_SCALABLE"),dismiss:I("SCALABLE"),developer:o.checks.META_SCALABLE.developer||!0});const s=parseFloat(n["maximum-scale"]);o.checks.META_MAX&&!Number.isNaN(s)&&s<2&&e.push({type:o.checks.META_MAX.type||"error",content:t.sprintf(o.checks.META_MAX.content||"META_MAX"),dismiss:I("MAXSCALE"),developer:o.checks.META_MAX.developer||!0})}}}o.checks.META_REFRESH&&document.querySelector('meta[http-equiv="refresh"]')&&e.push({type:o.checks.META_REFRESH.type||"error",content:t.sprintf(o.checks.META_REFRESH.content||"META_REFRESH"),dismiss:I("REFRESH"),developer:o.checks.META_REFRESH.developer||!0});o.checks.DUPLICATE_ID&&document.querySelectorAll("body, [data-sa11y-has-shadow-root]").forEach((i=>{const s=new Set,a=(n,i)=>{n.forEach((n=>{const{id:a}=n;"string"==typeof a&&0!==a.trim().length&&(a&&!s.has(a)?s.add(a):Array.from(i.querySelectorAll(`\n                a[href*="${a}"],\n                label[for*="${a}"],\n                [aria-labelledby*="${a}"],\n                [aria-controls*="${a}"],\n                [aria-owns*="${a}"]`)).length>0&&e.push({element:n,type:o.checks.DUPLICATE_ID.type||"error",content:t.sprintf(o.checks.DUPLICATE_ID.content||"DUPLICATE_ID",a),dismiss:I(`DUPLICATEID${a}${n.textContent}`),dismissAll:!!o.checks.DUPLICATE_ID.dismissAll&&"DUPLICATE_ID",developer:o.checks.DUPLICATE_ID.developer||!0}))}))};i.shadowRoot&&a(Array.from(i.shadowRoot.querySelectorAll(`[id]:not(${n.Exclusions.Container})`)),i.shadowRoot),a(Array.from(i.querySelectorAll(`[id]:not(${n.Exclusions.Container})`)),i)}));(o.checks.BTN_EMPTY||o.checks.BTN_EMPTY_LABELLEDBY||o.checks.BTN_LABEL||o.checks.HIDDEN_FOCUSABLE||o.checks.LABEL_IN_NAME)&&O.Found.Buttons.forEach((n=>{const i=r(n),s=i.replace(/'|"|-|\.|\s+/g,"").toLowerCase(),a=I(`BTN${n.tagName+n.id+n.className+i}`),l=n.querySelector(":scope [aria-labelledby], :scope [aria-label]")||n.getAttribute("aria-labelledby")||n.getAttribute("aria-label"),c=n.querySelector(":scope [aria-labelledby]")||n.getAttribute("aria-labelledby"),d="true"===n.getAttribute("aria-hidden"),p="-1"===n.getAttribute("tabindex");if(d)return void(p||o.checks.HIDDEN_FOCUSABLE&&e.push({element:n,type:o.checks.HIDDEN_FOCUSABLE.type||"error",content:t.sprintf(o.checks.HIDDEN_FOCUSABLE.content||"HIDDEN_FOCUSABLE"),dismiss:a,dismissAll:!!o.checks.HIDDEN_FOCUSABLE.dismissAll&&"BTN_HIDDEN_FOCUSABLE",developer:o.checks.HIDDEN_FOCUSABLE.developer||!0}));if(0===s.length)return void(o.checks.BTN_EMPTY_LABELLEDBY&&c?e.push({element:n,type:o.checks.BTN_EMPTY_LABELLEDBY.type||"error",content:o.checks.BTN_EMPTY_LABELLEDBY.content?t.sprintf(o.checks.BTN_EMPTY_LABELLEDBY.content):`${t.sprintf("BTN_EMPTY_LABELLEDBY")} ${t.sprintf("BTN_TIP")}`,dismiss:I(a),dismissAll:!!o.checks.BTN_EMPTY_LABELLEDBY.dismissAll&&"BTN_EMPTY_LABELLEDBY",developer:o.checks.BTN_EMPTY_LABELLEDBY.developer||!0}):o.checks.BTN_EMPTY&&e.push({element:n,type:o.checks.BTN_EMPTY.type||"error",content:o.checks.BTN_EMPTY.content?t.sprintf(o.checks.BTN_EMPTY.content):`${t.sprintf("BTN_EMPTY")} ${t.sprintf("BTN_TIP")}`,dismiss:a,dismissAll:!!o.checks.BTN_EMPTY.dismissAll&&"BTN_EMPTY",developer:o.checks.BTN_EMPTY.developer||!0}));const h=C(n);if(o.checks.LABEL_IN_NAME&&l&&h){const s=u(i);e.push({element:n,type:o.checks.LABEL_IN_NAME.type||"warning",content:o.checks.LABEL_IN_NAME.content?t.sprintf(o.checks.LABEL_IN_NAME.content,s):`${t.sprintf("LABEL_IN_NAME",s)} ${t.sprintf("ACC_NAME_TIP")}`,dismiss:a,dismissAll:!!o.checks.LABEL_IN_NAME.dismissAll&&"BTN_LABEL_IN_NAME",developer:o.checks.LABEL_IN_NAME.developer||!0})}else o.checks.BTN_ROLE_IN_NAME&&i.includes(t._("BTN"))&&e.push({element:n,type:o.checks.BTN_ROLE_IN_NAME.type||"warning",content:o.checks.BTN_ROLE_IN_NAME.content?t.sprintf(o.checks.BTN_ROLE_IN_NAME.content):`${t.sprintf("BTN_ROLE_IN_NAME")} ${t.sprintf("BTN_TIP")}`,dismiss:a,dismissAll:!!o.checks.BTN_ROLE_IN_NAME.dismissAll&&"BTN_ROLE_IN_NAME",developer:o.checks.BTN_ROLE_IN_NAME.developer||!0})})),o.checks.UNCONTAINED_LI&&O.Found.Lists.forEach((n=>{n.closest("ul, ol, menu")||e.push({element:n,type:o.checks.UNCONTAINED_LI.type||"error",content:t.sprintf(o.checks.UNCONTAINED_LI.content||"UNCONTAINED_LI"),dismiss:I(`UNCONTAINEDLI${n.textContent}`),dismissAll:!!o.checks.UNCONTAINED_LI.dismissAll&&"UNCONTAINED_LI",developer:o.checks.UNCONTAINED_LI.developer||!0})})),o.checks.TABINDEX_ATTR&&O.Found.TabIndex.forEach((n=>{e.push({element:n,type:o.checks.TABINDEX_ATTR.type||"error",content:t.sprintf(o.checks.TABINDEX_ATTR.content||"TABINDEX_ATTR"),dismiss:I(`TABINDEX${n.tagName+n.id+n.className}`),dismissAll:!!o.checks.TABINDEX_ATTR.dismissAll&&"TABINDEX_ATTR",developer:o.checks.TABINDEX_ATTR.developer||!0})}))}(this.results,s),s.embeddedContentPlugin&&function(e,n){const o=e=>"undefined"!==e.getAttribute("src")?e.getAttribute("src"):e.querySelector("[src]")?.getAttribute("src");n.checks.EMBED_AUDIO&&O.Found.Audio.forEach((i=>{e.push({element:i,type:n.checks.EMBED_AUDIO.type||"warning",content:t.sprintf(n.checks.EMBED_AUDIO.content||"EMBED_AUDIO"),dismiss:I(`AUDIO${o(i)}`),dismissAll:!!n.checks.EMBED_AUDIO.dismissAll&&"EMBED_AUDIO",developer:n.checks.EMBED_AUDIO.developer||!1})})),n.checks.EMBED_VIDEO&&O.Found.Videos.forEach((i=>{const s=i.querySelector("track"),a=s?.getAttribute("src");null!==s&&null!==a&&0!==a.trim().length||e.push({element:i,type:n.checks.EMBED_VIDEO.type||"warning",content:t.sprintf(n.checks.EMBED_VIDEO.content||"EMBED_VIDEO"),dismiss:I(`VIDEO${o(i)}`),dismissAll:!!n.checks.EMBED_VIDEO.dismissAll&&"EMBED_VIDEO",developer:n.checks.EMBED_VIDEO.developer||!1})})),n.checks.EMBED_DATA_VIZ&&O.Found.Visualizations.forEach((i=>{e.push({element:i,type:n.checks.EMBED_DATA_VIZ.type||"warning",content:t.sprintf(n.checks.EMBED_DATA_VIZ.content||"EMBED_DATA_VIZ"),dismiss:I(`DATAVIZ${o(i)}`),dismissAll:!!n.checks.EMBED_DATA_VIZ.dismissAll&&"EMBED_DATA_VIZ",developer:n.checks.EMBED_DATA_VIZ.developer||!1})})),O.Found.iframes.forEach((i=>{const s=["presentation","none"].includes(i.getAttribute("role")),r=d(i),l="VIDEO"===i.tagName||"AUDIO"===i.tagName,c="true"===i.getAttribute("aria-hidden"),p="-1"===i.getAttribute("tabindex");if(!(r||l||c&&p||s))if(p)n.checks.EMBED_UNFOCUSABLE&&e.push({element:i,type:n.checks.EMBED_UNFOCUSABLE.type||"error",content:t.sprintf(n.checks.EMBED_UNFOCUSABLE.content||"EMBED_UNFOCUSABLE"),dismiss:I(`EMBEDUNFOCUSABLE${o(i)}`),dismissAll:!!n.checks.EMBED_UNFOCUSABLE.dismissAll&&"EMBED_UNFOCUSABLE",developer:n.checks.EMBED_UNFOCUSABLE.developer||!0});else if(n.checks.EMBED_MISSING_TITLE){const s=a(i);0===b("noAria"===s?i.getAttribute("title")||"":s).length&&e.push({element:i,type:n.checks.EMBED_MISSING_TITLE.type||"error",content:t.sprintf(n.checks.EMBED_MISSING_TITLE.content||"EMBED_MISSING_TITLE"),dismiss:I(`EMBEDMISSTITLE${o(i)}`),dismissAll:!!n.checks.EMBED_MISSING_TITLE.dismissAll&&"EMBED_MISSING_TITLE",developer:n.checks.EMBED_MISSING_TITLE.developer||!0})}})),n.checks.EMBED_GENERAL&&O.Found.EmbeddedContent.forEach((i=>{const s=["presentation","none"].includes(i.getAttribute("role")),a="true"===i.getAttribute("aria-hidden"),r="-1"===i.getAttribute("tabindex");d(i)||a&&r||s||"VIDEO"!==i.tagName&&"AUDIO"!==i.tagName&&e.push({element:i,type:n.checks.EMBED_GENERAL.type||"warning",content:t.sprintf(n.checks.EMBED_GENERAL.content||"EMBED_GENERAL"),dismiss:I(`IFRAMEGENERAL${o(i)}`),dismissAll:!!n.checks.EMBED_GENERAL.dismissAll&&"EMBED_GENERAL",developer:n.checks.EMBED_GENERAL.developer||!1})}))}(this.results,s),s.contrastPlugin&&function(e,n){const o=[];for(let e=0;e<O.Found.Contrast.length;e++){const t=O.Found.Contrast[e],n=getComputedStyle(t),i=parseFloat(n.opacity),s=cn(n.color,i),a=parseFloat(n.fontSize),r=ln(n.fontWeight),l=dn(t),p=c(t),u=d(t)||p||0===i,h=Array.from(t.childNodes).filter((e=>3===e.nodeType)).map((e=>e.textContent)).join("").trim(),m=["SELECT","INPUT","TEXTAREA"].includes(t.tagName);if(0!==h.length||m)if("unsupported"===s||"unsupported"===l)o.push({$el:t,type:"unsupported",fontSize:a,fontWeight:r,opacity:i,..."unsupported"!==l&&{background:l},..."unsupported"!==s&&{color:s}});else if("image"===l.type)u||o.push({$el:t,type:"background-image",color:s,background:l,fontSize:a,fontWeight:r,opacity:i});else if("text"===t.tagName&&t.closest("svg"));else if(u||gn(s)===gn(l));else{const e=In(t,s,l,a,r,i);e&&(e.type=m?"input":"text",o.push(e))}}O.Found.Svg.forEach((e=>{const t=dn(e);if(t&&"image"===t.type)return void o.push({$el:e,type:"svg-warning",background:t});if(e.querySelector("text"))return void o.push({$el:e,type:"svg-text",background:t});const i=e.querySelectorAll("path, polygon, circle, rect, ellipse");if(1===i.length){const s=getComputedStyle(i[0]),{fill:a,opacity:r,stroke:l,strokeWidth:c}=s;if(a.startsWith("url("))return void o.push({$el:e,type:"svg-warning",background:t});const d=a&&"none"!==a,p=l&&"none"!==l&&"0px"!==c;if(!d&&!p)return void o.push({$el:e,type:"svg-warning",background:t});let u,h=!1,m=!1;d&&(u=bn(cn("currentColor"===a?getComputedStyle(e).color:a,r),t),h=n.contrastAPCA?u.ratio>=45:u.ratio>=3),p&&(u=bn(cn("currentColor"===l?getComputedStyle(e).color:l,r),t),m=n.contrastAPCA?u.ratio>=45:u.ratio>=3),(d&&p&&!h&&!m||d&&!p&&!h||!d&&p&&!m)&&o.push({$el:e,ratio:fn(u.ratio),color:u.blendedColor,type:"svg-error",background:t})}else o.push({$el:e,type:"svg-warning",background:t})})),O.Found.Inputs.forEach((e=>{if(e.placeholder&&0!==e.placeholder.length){const t=getComputedStyle(e,"::placeholder"),n=cn(t.getPropertyValue("color")),i=parseFloat(t.fontSize),s=ln(t.fontWeight),a=dn(e),r=parseFloat(t.opacity);if("image"===a.type);else{const t=In(e,n,a,i,s,r);t&&(t.type="placeholder",o.push(t))}}})),(e=>{const t=e.filter((e=>"background-image"===e.type)),o=e.filter((e=>"background-image"!==e.type));let i;if(n.contrastAPCA)i=t.map((e=>({...e})));else{const e=t.reduce(((e,t)=>{const n=e,o=JSON.stringify({background:t.background.value,color:t.color});return n[o]||(n[o]=[]),n[o].push(t),n}),{});i=Object.values(e).map((e=>({...e[0]})))}return[...i,...o]})(o).forEach((o=>{const{$el:i,ratio:s}=o,a=o,r="OPTION"===i.tagName?i.closest("datalist, select, optgroup"):i,l=u(y(f(g(r,["option:not(option:first-child)"])),80));let c;switch(c="placeholder"===o.type?u(i.placeholder):"svg-error"===o.type||"svg-warning"===o.type||"svg-text"===o.type?"":l,a.sanitizedText=c,o.type){case"text":n.checks.CONTRAST_ERROR&&e.push({element:i,type:n.checks.CONTRAST_ERROR.type||"error",content:t.sprintf(n.checks.CONTRAST_ERROR.content||"CONTRAST_ERROR"),dismiss:I(`CONTRAST${l}`),dismissAll:!!n.checks.CONTRAST_ERROR.dismissAll&&"CONTRAST_ERROR",developer:n.checks.CONTRAST_ERROR.developer||!1,contrastDetails:a});break;case"input":n.checks.CONTRAST_INPUT&&e.push({element:r,type:n.checks.CONTRAST_INPUT.type||"error",content:t.sprintf(n.checks.CONTRAST_INPUT.content||"CONTRAST_INPUT",s),dismiss:I(`CONTRAST${i.getAttribute("class")}${i.tagName}${s}`),dismissAll:!!n.checks.CONTRAST_INPUT.dismissAll&&"CONTRAST_INPUT",developer:n.checks.CONTRAST_INPUT.developer||!0,contrastDetails:a});break;case"placeholder":n.checks.CONTRAST_PLACEHOLDER&&e.push({element:i,type:n.checks.CONTRAST_PLACEHOLDER.type||"error",content:t.sprintf(n.checks.CONTRAST_PLACEHOLDER.content||"CONTRAST_PLACEHOLDER"),position:"afterend",dismiss:I(`CPLACEHOLDER${i.getAttribute("class")}${i.tagName}${s}`),dismissAll:!!n.checks.CONTRAST_PLACEHOLDER.dismissAll&&"CONTRAST_PLACEHOLDER",developer:n.checks.CONTRAST_PLACEHOLDER.developer||!0,contrastDetails:a});break;case"svg-error":n.checks.CONTRAST_ERROR_GRAPHIC&&e.push({element:i,type:n.checks.CONTRAST_ERROR_GRAPHIC.type||"error",content:t.sprintf(n.checks.CONTRAST_ERROR_GRAPHIC.content||"CONTRAST_ERROR_GRAPHIC"),dismiss:I(`CONTRASTERROR${i.outerHTML}`),dismissAll:!!n.checks.CONTRAST_ERROR_GRAPHIC.dismissAll&&"CONTRAST_ERROR_GRAPHIC",developer:n.checks.CONTRAST_ERROR_GRAPHIC.developer||!0,contrastDetails:a});break;case"svg-warning":case"svg-text":n.checks.CONTRAST_WARNING_GRAPHIC&&e.push({element:i,type:n.checks.CONTRAST_WARNING_GRAPHIC.type||"warning",content:t.sprintf(n.checks.CONTRAST_WARNING_GRAPHIC.content||"CONTRAST_WARNING_GRAPHIC"),dismiss:I(`CONTRASTWARNING${i.outerHTML}`),dismissAll:!!n.checks.CONTRAST_WARNING_GRAPHIC.dismissAll&&"CONTRAST_WARNING_GRAPHIC",developer:n.checks.CONTRAST_WARNING_GRAPHIC.developer||!0,contrastDetails:a});break;case"background-image":n.checks.CONTRAST_WARNING&&e.push({element:r,type:n.checks.CONTRAST_WARNING.type||"warning",content:t.sprintf(n.checks.CONTRAST_WARNING.content||"CONTRAST_WARNING"),dismiss:I(`CONTRAST${l}`),dismissAll:!!n.checks.CONTRAST_WARNING.dismissAll&&"CONTRAST_WARNING",developer:n.checks.CONTRAST_WARNING.developer||!1,contrastDetails:a});break;case"unsupported":n.checks.CONTRAST_UNSUPPORTED&&e.push({element:r,type:n.checks.CONTRAST_UNSUPPORTED.type||"warning",content:t.sprintf(n.checks.CONTRAST_UNSUPPORTED.content||"CONTRAST_WARNING"),dismiss:I(`CONTRAST${l}`),dismissAll:!!n.checks.CONTRAST_UNSUPPORTED.dismissAll&&"CONTRAST_UNSUPPORTED",developer:n.checks.CONTRAST_UNSUPPORTED.developer||!1,contrastDetails:a})}}))}(this.results,s),s.readabilityPlugin&&function(){let e;if("On"===v.getItem("sa11y-readability")){O.Found.Readability.forEach((e=>{const t=e.textContent;t.length>=120&&"."!==t.charAt(t.length-1)&&e.insertAdjacentHTML("beforeend","<span data-sa11y-readability-period>.</span>")}));const o=[];for(let e=0;e<O.Found.Readability.length;e++){const t=f(g(O.Found.Readability[e]));""!==t&&o.push(t)}const i=o.join(" ").toString();if(["en","es","fr","de","nl","it","pt"].includes(n.Readability.Lang)){const o=e=>{let t=e;if(t=t.toLowerCase().replace(".","").replace("\n",""),t.length<=3)return 1;t=t.replace(/(?:[^laeiouy]es|ed|[^laeiouy]e)$/,""),t=t.replace(/^y/,"");const n=t.match(/[aeiouy]{1,2}/g);let o=0;return!!n&&(o=n.length),o},s=i.replace(/[.!?-]+/g," ").split(" ");let a=0;for(let e=0;e<s.length;e++)0!=s[e]&&(a+=1);const r=i.split(/[.!?]+/);let l=0;for(let e=0;e<r.length;e++)""!==r[e]&&(l+=1);let c=0,d=0,p=0;for(let e=0;e<s.length;e++)if(0!=s[e]){const t=o(s[e]);1===t&&(d+=1),2===t&&(p+=1),c+=t}let u=!1;"en"===n.Readability.Lang?u=206.835-a/l*1.015-c/a*84.6:"fr"===n.Readability.Lang?u=207-a/l*1.015-c/a*73.6:"es"===n.Readability.Lang?u=206.84-a/l*1.02-c/a*100*.6:"de"===n.Readability.Lang?u=180-a/l-c/a*58.5:"nl"===n.Readability.Lang?u=206.84-c/a*100*.77-a/l*.93:"it"===n.Readability.Lang?u=217-a/l*1.3-c/a*100*.6:"pt"===n.Readability.Lang&&(u=248.835-a/l*1.015-c/a*84.6),u>100?u=100:u<0&&(u=0);const h=u.toFixed(1),m=(a/l).toFixed(1),g=Math.round((a-(d+p))/a*100);let f;f=h>=0&&h<30?t._("VERY_DIFFICULT"):h>31&&h<49?t._("DIFFICULT"):h>50&&h<60?t._("FAIRLY_DIFFICULT"):t._("GOOD"),e={score:h,averageWordsPerSentence:m,complexWords:g,difficultyLevel:f,wordCount:a}}else if(["sv","fi","da","no","nb","nn"].includes(n.Readability.Lang)){const n=(e=>{const n=()=>e.replace(/[-'.]/gi,"").split(/[^a-zA-ZöäåÖÄÅÆæØø0-9]/g).filter(Boolean),o=n().length,i=n().filter((e=>e.length>6)).length,s=e.split(/\?|!|\.|\n/g).filter(Boolean).length,a=Math.round(o/s+100*i/o),r=(o/s).toFixed(1),l=Math.round(i/o*100);let c;return c=a>=0&&a<39?t._("GOOD"):a>40&&a<50?t._("FAIRLY_DIFFICULT"):a>51&&a<61?t._("DIFFICULT"):t._("VERY_DIFFICULT"),{score:a,difficulty:c,avgWordsPerSentence:r,complexWords:l,wordCount:o}})(i);e={score:n.score,averageWordsPerSentence:n.avgWordsPerSentence,complexWords:n.complexWords,difficultyLevel:n.difficulty,wordCount:n.wordCount}}!1===n.Global.headless&&(0===i.length?n.Panel.readabilityInfo.innerHTML=t._("READABILITY_NO_CONTENT"):e.wordCount>30?(n.Panel.readabilityInfo.innerHTML=`${e.score} <span class="readability-score">${e.difficultyLevel}</span>`,n.Panel.readabilityDetails.innerHTML=`\n            <li>\n              <strong>${t._("AVG_SENTENCE")}</strong>\n              ${e.averageWordsPerSentence}\n            </li>\n            <li>\n              <strong>${t._("COMPLEX_WORDS")}</strong>\n              ${e.complexWords}%\n            </li>\n            <li>\n              <strong>${t._("TOTAL_WORDS")}</strong>\n              ${e.wordCount}\n            </li>`):n.Panel.readabilityInfo.textContent=t._("READABILITY_NOT_ENOUGH"))}}(),this.imageResults=this.results.filter(((e,t,n)=>{const o=e.element?.tagName,i=e.element?.outerHTML;return"IMG"===o&&n.findIndex((e=>e.element?.outerHTML===i))===t})),!0===s.customChecks?this.results:"object"==typeof s.customChecks?this.results.push(...s.customChecks):"listen"===s.customChecks&&(this.customChecksRunning=!0,this.customChecksFinished=0,document.addEventListener("sa11y-resume",(()=>{this.customChecksFinished+=1,1===this.customChecksFinished&&(this.customChecksRunning=!1,this.updateResults())})),window.setTimeout((()=>{if(!0===this.customChecksRunning)throw this.customChecksRunning=!1,this.updateResults(),Error("Sa11y: No custom checks were returned.")}),s.delayCustomCheck),window.setTimeout((()=>{const e=new CustomEvent("sa11y-custom-checks");document.dispatchEvent(e)}),0)),this.customChecksRunning||this.updateResults()}catch(e){const t=new z(e);throw document.body.appendChild(t),Error(e)}},this.updateResults=()=>{if(this.results=this.results.filter((e=>!1!==e.isWithinRoot)),"Off"!==v.getItem("sa11y-developer")&&null!==v.getItem("sa11y-developer")||(this.results=this.results.filter((e=>!0!==e.developer))),this.results.forEach(((e,t)=>{const n=s.selectorPath?function(e){const t=[];let n=e;for(;n;){let e=n.localName;if(n.id){e+=`#${n.id}`,t.unshift(e);break}n.className&&(e+=`.${n.className.replace(/\s+/g,".")}`);const o=n.parentNode;if(!o)break;{const i=o.children;i.length>1&&(e+=`:nth-child(${Array.prototype.indexOf.call(i,n)+1})`),t.unshift(e)}n=n.parentNode.host||n.parentNode}return t.join(" > ")}(e.element):"",o=e.element?.outerHTML.replace(/\s{2,}/g," ").trim()||"";Object.assign(e,{htmlPath:o,cssPath:n,id:t})})),!1===s.headless){const r=D(this.results,this.panelTooltips,this.checkAll,this.resetAll);this.results=r.updatedResults,this.dismissed=r.dismissedIssues;const l=function(e,t,n){let o=t,i=n;return e.forEach(((t,n)=>{const s=e[n].type;"error"===s?o+=1:"warning"===s&&(i+=1)})),{error:o,warning:i}}(this.results,this.errorCount,this.warningCount);if(function(e,o){const i=e+o;0===i?(n.Panel.notifCount.innerText="",n.Panel.notifText.innerText="",n.Panel.notifBadge.style.display="none"):o>0&&0===e?(n.Panel.notifBadge.classList.add("notification-badge-warning"),n.Panel.notifCount.innerText=`${o}`,n.Panel.notifText.innerText=`${t._("WARNINGS_FOUND")}`):(n.Panel.notifBadge.classList.remove("notification-badge-warning"),n.Panel.notifCount.innerText=`${i}`,n.Panel.notifText.innerText=t._("TOTAL_FOUND")),"Opened"===v.getItem("sa11y-panel")||0===i?n.Panel.notifBadge.style.display="none":n.Panel.notifBadge.style.display="flex"}(l.error,l.warning),"Opened"===v.getItem("sa11y-panel")){this.results.forEach((e=>{Object.assign(e),function(e,o){const{element:i,type:s,content:a,inline:r=!1,position:l="beforebegin",id:c,dismiss:d,dismissAll:u,contrastDetails:h}=e,m=["error","warning","good"];if(-1===m.indexOf(s))throw Error(`Invalid type [${s}] for annotation`);[s].forEach((e=>{if("error"===e&&void 0!==i){const e=r?"data-sa11y-error-inline":"data-sa11y-error";i.setAttribute(e,c)}else if("warning"===e&&void 0!==i){const e=r?"data-sa11y-warning-inline":"data-sa11y-warning";i.setAttribute(e,c)}}));const g={[m[0]]:t._("ERROR"),[m[1]]:t._("WARNING"),[m[2]]:t._("GOOD")};if(!1===o.showGoodImageButton&&"IMG"===i?.tagName&&"good"===s)return;if(!1===o.showGoodLinkButton&&"A"===i?.tagName&&"good"===s)return;const f=!o.dismissAnnotations||"warning"!==s&&"good"!==s||void 0===d?"":`<button data-sa11y-dismiss='${c}' type='button'>${t._("DISMISS")}</button>`,b=o.dismissAnnotations&&o.dismissAll&&"string"==typeof u&&("warning"===s||"good"===s)?`<button data-sa11y-dismiss='${c}' data-sa11y-dismiss-all type='button'>${t._("DISMISS_ALL")}</button>`:"",y=document.createElement("sa11y-annotation");if(y.setAttribute("data-sa11y-annotation",c),void 0===i){const e=document.createElement("li");e.innerHTML=`<h3>${g[s]}</h3> ${a}${f}`,n.Panel.pageIssuesList.insertAdjacentElement("afterbegin",e),n.Panel.pageIssues.classList.add("active"),n.Panel.panel.classList.add("has-page-issues")}else{const e=document.createElement("div");e.classList.add(r?"instance-inline":"instance"),e.innerHTML=`\n    <button\n      type="button"\n      aria-label="${g[s]}"\n      aria-haspopup="dialog"\n      class="sa11y-btn ${[s]}-btn${r?"-text":""}"\n      data-tippy-content=\n        "<div lang='${t._("LANG_CODE")}' class='${[s]}'>\n          <button type='button' class='close-btn close-tooltip' aria-label='${t._("ALERT_CLOSE")}'></button> <h2>${g[s]}</h2>\n          ${p(a)}\n          ${h?"<div data-sa11y-contrast-details></div>":""}\n          <div class='dismiss-group'>${f}${b}</div>\n        </div>"\n    ></button>`;const n=o.insertAnnotationBefore?`, ${o.insertAnnotationBefore}`:"";(i.closest(`a, button, [role="link"], [role="button"] ${n}`)||i).insertAdjacentElement(l,y),y.shadowRoot.appendChild(e)}}(e,s)})),O.initializeAnnotations();const c=new Tn;document.body.appendChild(c),$(this.results,this.dismissed,this.checkAll,this.resetAll),ee(this.dismissed,this.headingOutline,s),s.showImageOutline&&function(e,o,i){const s=()=>{const a=[],r=e.map((e=>o.find((t=>e.key===t.dismiss&&e.href===window.location.pathname)))).filter(Boolean);o.forEach((e=>{const o=r.some((t=>t.element.outerHTML.toLowerCase()===e.element.outerHTML.toLowerCase()));o&&Object.assign(e,{dismissedImage:!0});const s=e.type,l=e.developer,{dismissedImage:c}=e,d=p(e.element.alt),u=!("Off"!==v.getItem("sa11y-developer")&&null!==v.getItem("sa11y-developer")||"error"!==s&&"warning"!==s||!0!==l),h=S(e.element),m=n.Global.editImageURLofCMS?te(e):"",g=i.imageWithinLightbox?`a[href]:not(${i.imageWithinLightbox})`:"a[href]",f=e.element.closest(g)?`<div class="badge ${s}-badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></div>`:"";let b;if("error"!==s||u)if("warning"!==s||c||u){const n=0===d.length?`<div class="badge">${t._("DECORATIVE")}</div>`:"",o=i.imageWithinLightbox?`a[href]:not(${i.imageWithinLightbox})`:"a[href]",s=e.element.closest(o)?`<div class="badge"><span class="link-icon"></span><span class="visually-hidden">${t._("LINKED")}</span></div>`:"";b=`\n        <li class="good">\n          <img src="${h}" alt/>\n          <div class="alt">\n            <div class="badge">${t._("ALT")}</div>\n            ${s} ${n} ${d}\n          </div>\n          ${m}\n        </li>`,a.push(b)}else{const e=0===d.length?`<div class="badge warning-badge">${t._("DECORATIVE")}</div>`:"";b=`\n        <li class="warning">\n          <img src="${h}" alt/>\n          <div class="alt">\n            <div class="badge warning-badge"><span aria-hidden="true">&#63;</span> <span class="visually-hidden">${t._("WARNING")}</span> ${t._("ALT")}</div>\n            ${f} ${e} <strong class="yellow-text">${d}</strong>\n          </div>\n          ${m}\n        </li>`,a.push(b)}else{const e=0===d.length?`<div class="badge error-badge">${t._("MISSING")}</div>`:`<strong class="red-text">${d}</strong>`;b=`\n        <li class="error">\n          <img src="${h}" alt/>\n          <div class="alt">\n            <div class="badge error-badge"><span class="error-icon"></span><span class="visually-hidden">${t._("ERROR")}</span> ${t._("ALT")}</div> ${f} ${e}\n          </div>\n          ${m}\n        </li>`,a.push(b)}})),n.Panel.imagesList.innerHTML=0===a.length?`<li>${t._("NO_IMAGES")}</li>`:a.join(" "),document.removeEventListener("sa11y-build-image-outline",s)};"Opened"===v.getItem("sa11y-images")&&s(),document.addEventListener("sa11y-build-image-outline",s)}(this.dismissed,this.imageResults,s),o=r.dismissCount,i=l.error,a=l.warning,n.Panel.skipButton.disabled=!1,n.Panel.panel.classList.add("active"),n.Global.html.setAttribute("data-sa11y-active","true"),n.Panel.skipButton.classList.add("active"),i>0&&a>0?(n.Panel.content.setAttribute("class","errors"),n.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${i}</span> ${t._("WARNINGS")} <span class="panel-count" id="warning-count">${a}</span>`):i>0?(n.Panel.content.setAttribute("class","errors"),n.Panel.status.innerHTML=`${t._("ERRORS")} <span class="panel-count">${i}</span>`):a>0?(n.Panel.content.setAttribute("class","warnings"),n.Panel.status.innerHTML=`${t._("WARNINGS")} <span class="panel-count" id="warning-count">${a}</span>`):o>0?(n.Panel.status.innerHTML=`${t._("DISMISSED")} <span class="panel-count">${o}</span>`,n.Panel.skipButton.classList.remove("active")):(n.Panel.content.setAttribute("class","good"),n.Panel.status.innerHTML=`${t._("NO_ERRORS_FOUND")}`),0===document.querySelectorAll("sa11y-annotation").length&&(n.Panel.skipButton.disabled=!0),e=this.results,Mn=t=>{Dn(t,e)},Bn=()=>{Rn(e)},document.addEventListener("keydown",Mn),n.Panel.skipButton.addEventListener("click",Bn),s.exportResultsPlugin&&function(e,t){n.Global.exportResultsPlugin&&(F=()=>{U(e,t)},K=()=>{H(e)},n.Panel.exportHTML.addEventListener("click",F),n.Panel.exportCSV.addEventListener("click",K))}(this.results,r.dismissedResults),k(n.Panel.pageIssuesList,n.Panel.pageIssuesContent),kn(s.ignoreHiddenOverflow),document.querySelectorAll("sa11y-annotation").forEach((e=>{const t=e.nextElementSibling;null!==t&&"SA11Y-ANNOTATION"===t.tagName&&customElements.get("sa11y-annotation")&&t.shadowRoot.querySelector("button").setAttribute("style","margin: -5px -15px !important;")}))}n.Panel.toggle.disabled=!1}var e,o,i,a;window.sa11yCheckComplete=null;const r=new CustomEvent("sa11y-check-complete",{detail:{results:this.results,page:window.location.pathname}});window.sa11yCheckComplete=r.detail,document.dispatchEvent(r)},this.resetAll=(e=!0)=>{for(n.Global.html.removeAttribute("data-sa11y-active"),N(["sa11y-annotation","sa11y-heading-label","sa11y-heading-anchor","sa11y-tooltips","[data-sa11y-readability-period]","[data-sa11y-clone-image-text]"],"document"),x(["data-sa11y-parent","data-sa11y-error","data-sa11y-warning","data-sa11y-good","data-sa11y-error-inline","data-sa11y-warning-inline","data-sa11y-overflow","data-sa11y-pulse-border","data-sa11y-filter","data-sa11y-has-shadow-root"],"document"),n.Panel.outlineList.innerHTML="",s.showImageOutline&&(n.Panel.imagesList.innerHTML=""),n.Panel.pageIssuesList.innerHTML="",n.Panel.readabilityInfo.innerHTML="",n.Panel.readabilityDetails.innerHTML="",n.Panel.panel.classList.remove("has-page-issues"),n.Panel.pageIssues.classList.remove("active"),n.Panel.settingsContent.classList.remove("hide-settings-border"),n.Panel.panel.querySelector("#readability-alert")?.remove(),L(),document.removeEventListener("keydown",Mn),n.Panel.skipButton.removeEventListener("click",Bn),n.Global.exportResultsPlugin&&(n.Panel.exportHTML.removeEventListener("click",F),n.Panel.exportCSV.removeEventListener("click",K)),n.Panel.panel?.removeEventListener("click",B),n.Panel.dismissButton?.removeEventListener("click",M),n.Global.colourFilterPlugin&&(n.Panel.colourFilterSelect.value=0,n.Panel.colourPanel.classList.remove("active"),n.Panel.colourFilterSelect.classList.remove("active"),n.Panel.content.hidden=!1);n.Panel.status.firstChild;)n.Panel.status.removeChild(n.Panel.status.firstChild);document.querySelectorAll("[data-sa11y-has-shadow-root]").forEach((e=>{e.shadowRoot.querySelectorAll("style.sa11y-css-utilities").forEach((e=>e.remove())),e.removeAttribute("data-sa11y-has-shadow-root")})),e&&n.Panel.panel.classList.remove("active")},this.disabled=()=>{setTimeout((()=>{"Opened"===v.getItem("sa11y-panel")&&n.Panel.toggle.click(),n.Panel.toggle.disabled=!0}),s.delayCheck+10)},this.enabled=()=>{n.Panel.toggle&&(n.Panel.toggle.disabled=!1)},this.find=(e,t,n)=>o(e,t,n),this.prepareDismissal=e=>I(e),this.sanitizeHTML=e=>u(e),this.initialize()}}export{t as Lang,Hn as Sa11y};
